/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.subpages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.views.pages.AnalysisPageBasic;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DB2ExplainSQLSubpage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String VIEWER_MEMENTO_TYPE = "pages.db2explainsql.viewer";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.explainsql";
    public static final String ID = "com.ca.mat.subpages.db2explainsql";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.dataview.datasetdetails";
    private Composite wrapper;
    private Label db2SsidLabel;
    private Label db2ReleaseLabel;
    private Label planPageLabel;
    private Button prevPageButton;
    private Button nextPageButton;
    private String db2Ssid;
    private String db2Release;
    private int planTableRowSelected = 1;
    private int planTableRowCount = 1;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        viewer.addColumn("Row", 2, "Row", 1, true, true, true, true);
        viewer.addColumn("PLAN_TABLE Column", 7, "Plan Table Column", 1, true, true, true, false);
        viewer.addColumn("QMF Heading", 5, "QMF Heading", 1, true, true, true, false);
        viewer.addColumn("Explain Data", 8, "Explain Data", 1, true, false, true, false);
        viewer.addColumn("Description", 9, "Description", 1, true, true, true, false);
    }

    @Override
    public void createHeaderPart(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        this.wrapper.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.wrapper.setLayoutData((Object)gridData);
        this.prevPageButton = new Button(this.wrapper, 8);
        this.prevPageButton.setText("<<");
        this.prevPageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DB2ExplainSQLSubpage.this.setSelectedPlanTableRow(DB2ExplainSQLSubpage.this.planTableRowSelected - 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.planPageLabel = new Label(this.wrapper, 4);
        this.nextPageButton = new Button(this.wrapper, 8);
        this.nextPageButton.setText(">>");
        this.nextPageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DB2ExplainSQLSubpage.this.setSelectedPlanTableRow(DB2ExplainSQLSubpage.this.planTableRowSelected + 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.wrapper, 4).setText("DB2 SSID: ");
        this.db2SsidLabel = new Label(this.wrapper, 4);
        new Label(this.wrapper, 4).setText("      DB2 Release: ");
        this.db2ReleaseLabel = new Label(this.wrapper, 4);
    }

    public void refreshHeader() {
        this.db2SsidLabel.setText(this.db2Ssid);
        this.db2ReleaseLabel.setText(this.db2Release);
        this.planPageLabel.setText("PLAN_TABLE row " + this.planTableRowSelected + " of " + this.planTableRowCount);
        this.prevPageButton.setEnabled(this.planTableRowSelected != 1);
        this.nextPageButton.setEnabled(this.planTableRowSelected != this.planTableRowCount);
        this.wrapper.getParent().layout(true, true);
    }

    private void setSelectedPlanTableRow(Integer page) {
        this.planTableRowSelected = page;
        ArrayList<Integer> filteredColumns = new ArrayList<Integer>();
        filteredColumns.add(4);
        this.getViewer().addColumnFilter(filteredColumns, page.toString(), true, false);
        this.refreshHeader();
    }

    public void setDb2Ssid(String db2Ssid) {
        this.db2Ssid = db2Ssid;
    }

    public void setDb2Release(String db2Release) {
        this.db2Release = db2Release;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    public void setPlanTableRowCount(int planTableRowCount) {
        this.planTableRowCount = planTableRowCount;
    }
}

