/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageBasic;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public class ProgramViewPage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String ID = "com.ca.mat.pages.programview";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.programview";
    public static final String VIEWER_MEMENTO_TYPE = "pages.programview.viewer";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.programview.histogram";
    public static final String PROPERTIES_MEMENTO_TYPE = "pages.programview.properties";
    private MATTableModel originalModel;
    private Text moduleText;
    private String[] moduleArray = new String[0];
    private Text csectText;
    private String[] csectArray = new String[0];

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        viewer.addColumn("Module", 5, null, 1, true, true);
        viewer.addColumn("Csect", 5, null, 1, true, true);
        viewer.addColumn("Description", 7, null, 1, true, true);
        viewer.addColumn("L", 1, null, 1, true, true);
        viewer.addColumn("C", 1, null, 1, false, false);
        viewer.addColumn("X", 1, null, 1, true, true);
        viewer.addColumn("Active %", 4, null, 9, true, true);
        viewer.addColumn("Wait %", 4, null, 9, true, true);
        viewer.addColumn("Total %", 4, null, 9, true, true);
        viewer.addColumn("Overlap %", 4, null, 9, true, true);
        viewer.setDefaultSortColumn(8);
    }

    @Override
    public void createHeaderPart(Composite parent) {
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ProgramViewPage.this.saveProperties();
                ProgramViewPage.this.recalculateModel();
            }
        };
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        wrapper.setLayoutData((Object)gridData);
        Label label = new Label(wrapper, 4);
        label.setText("Dispatcher Modules:");
        this.moduleText = new Text(wrapper, 4);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 300;
        this.moduleText.setLayoutData((Object)gridData);
        this.moduleText.addListener(14, listener);
        Label label2 = new Label(wrapper, 4);
        label2.setText("Dispatcher Csects:");
        this.csectText = new Text(wrapper, 4);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 300;
        this.csectText.setLayoutData((Object)gridData);
        this.csectText.addListener(14, listener);
        Button button = new Button(wrapper, 0x800000);
        button.setText("Show");
        button.addListener(13, listener);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }

    private void recalculateModel() {
        String moduleString = this.moduleText.getText();
        this.moduleArray = moduleString.split(",");
        int i = 0;
        while (i < this.moduleArray.length) {
            this.moduleArray[i] = this.moduleArray[i].trim();
            ++i;
        }
        String csectString = this.csectText.getText();
        this.csectArray = csectString.split(",");
        int i2 = 0;
        while (i2 < this.csectArray.length) {
            this.csectArray[i2] = this.csectArray[i2].trim();
            ++i2;
        }
        MATTableModel model = AnalysisUtils.callerIdSwap(this.originalModel, this.moduleArray, this.csectArray, this.dsn, false);
        model = AnalysisUtils.calculateCodeView(model, this.dsn, this.type);
        this.setModel(model);
    }

    public String[] getDispatcherModules() {
        return this.moduleArray;
    }

    public String[] getDispatcherCsects() {
        return this.csectArray;
    }

    private void saveProperties() {
        IMemento memento = Singletons.getPersistenceManager().get(PROPERTIES_MEMENTO_TYPE);
        memento.putString("moduleString", this.moduleText.getText());
        memento.putString("csectString", this.csectText.getText());
    }

    private void loadProperties() {
        IMemento memento = Singletons.getPersistenceManager().get(PROPERTIES_MEMENTO_TYPE);
        String moduleString = memento.getString("moduleString");
        if (moduleString == null) {
            moduleString = "";
        }
        this.moduleText.setText(moduleString);
        this.moduleArray = moduleString.split(",");
        int i = 0;
        while (i < this.moduleArray.length) {
            this.moduleArray[i] = this.moduleArray[i].trim();
            ++i;
        }
        String csectString = memento.getString("csectString");
        if (csectString == null) {
            csectString = "";
        }
        this.csectText.setText(csectString);
        this.csectArray = csectString.split(",");
        int i2 = 0;
        while (i2 < this.csectArray.length) {
            this.csectArray[i2] = this.csectArray[i2].trim();
            ++i2;
        }
        if (moduleString.length() + csectString.length() > 0) {
            MATTableModel model = AnalysisUtils.callerIdSwap(this.originalModel, this.moduleArray, this.csectArray, this.dsn, false);
            model = AnalysisUtils.calculateCodeView(model, this.dsn, this.type);
            this.setModel(model);
        }
    }

    public void addCsectToList(String csect) {
        if (csect != null && !(csect = csect.trim()).isEmpty()) {
            String csectString = this.csectText.getText();
            csectString = csectString.trim().isEmpty() ? csect : String.valueOf(csectString) + ", " + csect;
            this.csectText.setText(csectString);
            this.recalculateModel();
            this.saveProperties();
        }
    }

    public boolean isCsectInList(String csect) {
        if (csect == null) {
            return false;
        }
        if ((csect = csect.trim()).isEmpty()) {
            return false;
        }
        String[] stringArray = this.csectArray;
        int n = this.csectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (csect.equalsIgnoreCase(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setOriginalModel(MATTableModel model) {
        this.originalModel = model;
        this.loadProperties();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.originalModel = null;
    }
}

