/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.IPageTextViewer;
import com.ca.mat.views.pages.PageTextViewerFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class LogPage
extends AnalysisPage {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String ID = "com.ca.mat.pages.logmessages";
    public static final String SECTION_NAME = "LogMessages";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.logmessages";
    private IPageTextViewer viewer;
    private String dsn;
    private int type;

    @Override
    public void setDSN(String dsn) {
        this.dsn = dsn;
    }

    @Override
    public void createControl(Composite parent) {
        this.buildReportViewer(parent);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, this.type);
        if (model == null) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, 1);
        }
        this.setModel(model);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
    }

    public void setModel(MATTableModel model) {
        this.viewer.setModel(model, false);
    }

    @Override
    public Control getControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getControl();
    }

    @Override
    public void setType(int type) {
        this.type = type;
        if (this.viewer != null) {
            MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
            if (model == null) {
                model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, 1);
            }
            this.setModel(model);
        }
    }

    @Override
    public void setMenu(Menu popup) {
        this.viewer.getControl().setMenu(popup);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    @Override
    public String getDSN() {
        return this.dsn;
    }

    @Override
    public int getType() {
        return this.type;
    }

    private void buildReportViewer(Composite parent) {
        this.viewer = PageTextViewerFactory.createNew(parent, 2818);
        this.viewer.setEditable(false);
        this.viewer.getControl().setFont(JFaceResources.getTextFont());
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    public IPageTextViewer getViewer() {
        return this.viewer;
    }
}

