/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.connect.MATServer;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.IMonitorListener;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.IMATView;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;

public class MonitorHistoryView
extends ViewPart
implements IMonitorListener,
IDoubleClickListener,
IMATView {
    private static final String MONITOR_HISTORY_UPDATED = "Monitor History updated at %1tT";
    private static final String MONITOR_HISTORY_LOADED = "Monitor History loaded at %1tT";
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    static final String ANALYZE = "com.ca.mat.commands.analyze";
    static int[] columnWidths;
    static int[] columnOrder;
    private IMATTableViewer viewer;
    public static final String ID = "com.ca.mat.views.monitorhistoryview";
    private final String SECTION_NAME = "Monitor History File";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.monitorhistoryview";
    private MonitorManager manager;
    private String profileName;
    public static final String VIEWER_MEMENTO_TYPE = "monitorhistoryview.viewer";
    private boolean initializing = true;

    public static boolean anyOpen() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = activeWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] references;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = references = page.getViewReferences();
            int n3 = references.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference viewRef = iViewReferenceArray[n4];
                String id = viewRef.getId();
                if (id.equals(ID) || id.startsWith("com.ca.mat.views.monitorhistoryview:")) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static void resetView() {
        columnWidths = null;
        columnOrder = null;
    }

    public void init(IViewSite site, IMemento memento) {
        try {
            super.init(site, memento);
            if (memento != null) {
                Singletons.getPersistenceManager().set(ID, memento);
            }
        }
        catch (PartInitException e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.INFO, "Could not load settings for Monitor History View - resetting.", e);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.initializing = true;
        this.manager = Singletons.getMonitorManager();
        this.viewer = MATTableViewerFactory.createNew(parent);
        MATTableModel model = null;
        this.profileName = this.getViewSite().getSecondaryId();
        model = this.manager.getHistoryForMonitor(this.profileName);
        this.manager.addMonitorListener(this);
        this.viewer.addColumn("Measured Job", 5, "Measured Job", 1, true, false);
        this.viewer.addColumn("Run", 2, "Run", 2);
        this.viewer.addColumn("Start Date", 5, "Start Date", 4);
        this.viewer.addColumn("Start Time", 5, "Start Time", 6);
        this.viewer.addColumn("CPU Time", 5, "CPU Time", 6);
        this.viewer.addColumn("EXCP Count", 5, "EXCP Count", 2);
        this.viewer.addColumn("SIO Rate", 5, "SIO Rate", 2);
        this.viewer.addColumn("% Active", 4, "% Active", 3);
        this.viewer.addColumn("% Wait", 4, "% Wait", 3);
        this.viewer.addColumn("% NonDispatch", 4, "% NonDispatch", 3);
        this.viewer.addColumn("% Proc Delay", 4, "% Proc Delay", 3);
        this.viewer.addColumn("% Swapped", 4, "% Swapped", 3);
        this.viewer.addColumn("Observation Rate", 5, "Observation Rate", 2);
        this.viewer.addColumn("Samples Collected", 5, "Samples Collected", 2);
        this.viewer.addColumn("Samples Used", 5, "Samples Used", 2);
        this.viewer.addColumn("Elapsed Time", 5, "Elapsed Time", 6);
        this.viewer.addColumn("Measured JobID", 5, "Measured JobID", 1);
        this.viewer.addColumn("Measured Step", 5, "Measured Step", 1);
        this.viewer.addColumn("Measured Procstep", 5, "Measured Procstep", 1);
        this.viewer.addColumn("Measured Program", 5, "Measured Program", 1);
        this.viewer.addColumn("Measured ASID", 5, "Measured ASID", 2);
        this.viewer.addColumn("System", 5, "System", 1);
        this.viewer.addColumn("SMF ID", 5, "SMF ID", 1);
        this.viewer.addColumn("Exists", 3, "Exists", 1);
        this.viewer.addColumn("Dataset Name", 6, "Dataset Name", 1);
        this.viewer.addColumn("Invocation Date", 5, "Invocation Date", 4);
        this.viewer.addColumn("Invocation Time", 5, "Invocation Time", 6);
        this.viewer.addColumn("Requested Observations", 5, "Requested Observations", 2);
        this.viewer.addColumn("Error Samples", 5, "Error Samples", 2);
        this.viewer.addColumn("Strg Abo", 5, "Strg Abo", 2);
        this.viewer.addColumn("Strg Bel", 5, "Strg Bel", 2);
        this.viewer.addColumn("Page in Count", 5, "Page in Count", 2);
        this.viewer.addColumn("z/OS Version", 5, "z/OS Version", 1);
        this.viewer.addColumn("CPU Type", 5, "CPU Type", 1);
        this.viewer.addColumn("CPU Model", 5, "CPU Model", 1);
        this.viewer.addColumn("CPU Serial", 5, "CPU Serial", 1);
        this.viewer.setSecondarySortColumn(25, 26);
        this.viewer.setSecondarySortColumns(2, new int[]{25, 26});
        this.viewer.setDefaultSortColumn(25);
        this.viewer.setDefaultSortDirection(1024);
        this.viewer.setCATableModel(model);
        this.viewer.addDoubleClickListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Singletons.getViewerSynchronizationManager().addViewer(VIEWER_MEMENTO_TYPE, this.viewer);
        this.viewer.refresh();
        this.setDynamicEvaluationForSelection(new String[]{"com.ca.mat.monitorDsnExists"});
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        IViewSite site = this.getViewSite();
        String secondaryID = site.getSecondaryId();
        if (secondaryID != null) {
            this.setProfileName(secondaryID);
        }
        this.initializing = false;
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.setMessage(String.format(MONITOR_HISTORY_LOADED, Calendar.getInstance()));
    }

    public String getProfile() {
        return this.profileName;
    }

    public void dispose() {
        this.manager.removeMonitorListener(this);
        Singletons.getViewerSynchronizationManager().removeViewer(this.viewer);
        IMemento memento = Singletons.getPersistenceManager().get(ID);
        if (memento != null) {
            this.saveState(memento);
        }
        super.dispose();
    }

    public IMATTableViewer getTableViewer() {
        return this.viewer;
    }

    public void setModel(MATTableModel model) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setCATableModel(model);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public IMATTableViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void monitorProfilesUpdated(MATTableModel profiles) {
        if (!Singletons.getMonitorManager().profileExists(this.profileName)) {
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = activeWindow.getActivePage();
            IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
            manager.setMessage(null);
            page.hideView((IViewPart)this);
        }
    }

    @Override
    public void monitorHistoryUpdated(MATServer server, String profile, MATTableModel history) {
        if (this.profileName.equals(profile)) {
            this.viewer.setCATableModel(history);
            this.viewer.refresh();
        }
    }

    @Override
    public void monitorSchedulesUpdated(MATTableModel schedules) {
    }

    private void setProfileName(String profileName) {
        this.profileName = profileName;
        this.manager = Singletons.getMonitorManager();
        MATTableModel model = this.manager.getHistoryForMonitor(profileName);
        this.viewer.setCATableModel(model);
        this.viewer.refresh();
        this.setPartName(String.format("%s History", profileName));
    }

    public void doubleClick(DoubleClickEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            service.executeCommand(ANALYZE, null);
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Autonavigation failed", e);
        }
    }

    protected void setDynamicEvaluationForSelection(final String[] properties) {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
                IEvaluationContext context = evaluationService.getCurrentState();
                StructuredSelection sel = (StructuredSelection)e.getSelection();
                Object obj = sel.getFirstElement();
                if (obj != null) {
                    context.addVariable("selection", (Object)new StructuredSelection(obj));
                }
                String[] stringArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    String prop = stringArray[n2];
                    evaluationService.requestEvaluation(prop);
                    ++n2;
                }
            }
        });
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }
}

