/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.ModViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;

public class ModuleCsectPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        AnalysisPage focusedPage = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (focusedPage == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = focusedPage.getPresentation();
        String dsn = presentation.getDSN();
        int type = presentation.getAnalysisType();
        if (property.equals("hasModuleCsectInfo")) {
            MATTableRow rowModel;
            String module = null;
            String csect = null;
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            boolean checkPseudoModule = true;
            if (receiver instanceof CodeViewRowModel) {
                rowModel = (CodeViewRowModel)receiver;
                module = ((CodeViewRowModel)rowModel).getModule();
                csect = ((CodeViewRowModel)rowModel).getMode() == CodeViewRowModel.TYPE_CSECT ? ((CodeViewRowModel)rowModel).getCSECT() : "";
            } else if (receiver instanceof CallerIdRowModel) {
                checkPseudoModule = false;
                rowModel = (CallerIdRowModel)receiver;
                module = ((CallerIdRowModel)rowModel).getOutModule();
                csect = ((CallerIdRowModel)rowModel).getOutCsect();
            } else if (receiver instanceof DelayLocationRowModel) {
                rowModel = (DelayLocationRowModel)receiver;
                module = ((DelayLocationRowModel)rowModel).getModule();
                csect = ((DelayLocationRowModel)rowModel).getCsect();
            } else if (receiver instanceof ModViewRowModel) {
                checkPseudoModule = false;
                rowModel = (ModViewRowModel)receiver;
                module = ((ModViewRowModel)rowModel).getModule();
                csect = ((ModViewRowModel)rowModel).getCsect();
            } else {
                return false;
            }
            if (module == null || module.startsWith(".") && checkPseudoModule && csect.startsWith(".") || module.startsWith(".") && checkPseudoModule && csect.isEmpty()) {
                return false;
            }
            String section = "Module-Csect Info";
            MATTableModel baseModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
            if (csect != null) {
                arguments.put("cscsect", new Object[]{csect});
            }
            if (module != null) {
                arguments.put("modnm", new Object[]{module});
            }
            if (baseModel != null) {
                if (!baseModel.contains(arguments)) {
                    arguments.put("cscsect", new Object[]{"N/A"});
                }
                return baseModel.contains(arguments);
            }
        }
        return false;
    }
}

