/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.DB2ViewRowModel;
import com.ca.mat.rowmodels.DataViewRowModel;
import com.ca.mat.rowmodels.DelayViewRowModel;
import com.ca.mat.rowmodels.IMSStatementRowModel;
import com.ca.mat.rowmodels.IMSViewRowModel;
import com.ca.mat.rowmodels.JVMInfoRowModel;
import com.ca.mat.rowmodels.MQQueueActivityRowModel;
import com.ca.mat.rowmodels.MQViewRowModel;
import com.ca.mat.rowmodels.PoolDatasetRowModel;
import com.ca.mat.rowmodels.PoolDetailRowModel;
import com.ca.mat.rowmodels.PoolViewRowModel;
import com.ca.mat.rowmodels.SSARowModel;
import com.ca.mat.rowmodels.TimeViewRowModel;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.rowmodels.USSViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.ProgramViewPage;
import com.ca.mat.views.subpages.QueueActivitySubpage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.PropertyTester;

public class CATableRowPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        int type = -1;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        type = presentation.getAnalysisType();
        if (property.equals("containsAutonav") && receiver instanceof DelayViewRowModel && page instanceof DelayViewPage) {
            DelayViewRowModel row = (DelayViewRowModel)receiver;
            DelayViewPage delayPage = (DelayViewPage)page;
            Map<String, Object[]> filters = delayPage.getFilterExpressions();
            if (filters != null && !filters.isEmpty()) {
                Object[] tranId = filters.get("Transaction");
                if (tranId != null && row.getMajorCat() != null && row.getMajorCat().equals("MQSeries Delay")) {
                    String section = String.format("MQ-Series-Activity Tran %s", tranId[0].toString());
                    return Singletons.getAnalysisManager().getModel(dsn, section, type) != null;
                }
                return false;
            }
            String autonav = row.getAutonav();
            boolean result = autonav != null && !autonav.equals("");
            return result;
        }
        if (property.equals("canExplainSQL") && receiver instanceof DB2ViewRowModel && dsn != null) {
            DB2ViewRowModel row = (DB2ViewRowModel)receiver;
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
            if (model == null || model.isEmpty()) {
                return false;
            }
            HashMap<String, Object[]> filterArgs = new HashMap<String, Object[]>();
            filterArgs.put("expname", new Object[]{row.getDbrmKey()});
            model = model.filterBy(filterArgs);
            if (!model.isEmpty()) {
                return true;
            }
            model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
            String declareKey = AnalysisUtils.createDB2DeclareKey(row);
            filterArgs.put("expname", new Object[]{declareKey});
            model = model.filterBy(filterArgs);
            return !model.isEmpty();
        }
        if (property.equals("canExplainInformation") && receiver instanceof DB2ViewRowModel && dsn != null) {
            DB2ViewRowModel row = (DB2ViewRowModel)receiver;
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
            if (model == null || model.isEmpty()) {
                return false;
            }
            HashMap<String, Object[]> filterArgs = new HashMap<String, Object[]>();
            filterArgs.put("expname", new Object[]{row.getDbrmKey()});
            model = model.filterBy(filterArgs);
            if (!model.isEmpty()) {
                return true;
            }
            model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
            String declareKey = AnalysisUtils.createDB2DeclareKey(row);
            filterArgs.put("expname", new Object[]{declareKey});
            model = model.filterBy(filterArgs);
            return !model.isEmpty();
        }
        if (property.equals("canShowDeclare") && receiver instanceof DB2ViewRowModel && dsn != null) {
            DB2ViewRowModel row = (DB2ViewRowModel)receiver;
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNSQL", 1);
            if (model == null || model.isEmpty()) {
                return false;
            }
            HashMap<String, Object[]> filterArgs = new HashMap<String, Object[]>();
            filterArgs.put("name", new Object[]{AnalysisUtils.createDB2DeclareKey(row)});
            model = model.filterBy(filterArgs);
            return !model.isEmpty();
        }
        if (property.equals("hasVolume") && receiver instanceof DataViewRowModel && dsn != null) {
            DataViewRowModel row = (DataViewRowModel)receiver;
            String section = "Volume Statistics";
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
            String[] volsers = row.getVolsers();
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("volser", volsers);
            if (volsers.length == 0) {
                return false;
            }
            if (model != null) {
                return model.contains(arguments, true);
            }
            return false;
        }
        if (property.equals("hasDatasetStats") && dsn != null) {
            if (receiver instanceof DataViewRowModel) {
                DataViewRowModel row = (DataViewRowModel)receiver;
                return row.hasDatasetStats(dsn, type);
            }
            if (receiver instanceof PoolDatasetRowModel) {
                PoolDatasetRowModel row = (PoolDatasetRowModel)receiver;
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "Dataset Statistics", type);
                if (model == null) {
                    return false;
                }
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("dsnd", new Object[]{row.getDatasetName()});
                arguments.put("ddnd", new Object[]{row.getDDName()});
                return model.contains(arguments);
            }
        } else {
            if (property.equals("datasetHasDDName") && receiver instanceof DataViewRowModel && dsn != null) {
                DataViewRowModel row = (DataViewRowModel)receiver;
                return expectedValue.equals(row.getDDName());
            }
            if (property.equals("hasSSA") && receiver instanceof IMSStatementRowModel && dsn != null) {
                IMSStatementRowModel row = (IMSStatementRowModel)receiver;
                String section = "SSA-Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put(SSARowModel.PSB_NAME, new Object[]{row.getPSB()});
                arguments.put(SSARowModel.DBD_NAME, new Object[]{row.getDBD()});
                arguments.put(SSARowModel.CALLTYPE, new Object[]{row.getCallType()});
                return model != null && model.contains(arguments);
            }
            if (property.equals("hasDataDetails")) {
                if (receiver instanceof TranViewRowModel) {
                    TranViewRowModel rowModel = (TranViewRowModel)receiver;
                    String section = rowModel.getDataDetailSection();
                    return Singletons.getAnalysisManager().getModel(dsn, section, type) != null;
                }
            } else if (property.equals("hasIMSStatements")) {
                if (receiver instanceof TranViewRowModel) {
                    TranViewRowModel rowModel = (TranViewRowModel)receiver;
                    String section = "IMS Statements";
                    MATTableModel baseModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                    arguments.put("tranid", new Object[]{rowModel.getTransactionName()});
                    return baseModel != null && baseModel.contains(arguments);
                }
                if (receiver instanceof IMSViewRowModel) {
                    IMSViewRowModel rowModel = (IMSViewRowModel)receiver;
                    String section = "IMS Statements";
                    MATTableModel baseModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                    arguments.put("tranid", new Object[]{rowModel.getTransactionId()});
                    return baseModel != null && baseModel.contains(arguments);
                }
            } else if (property.equals("hasDB2Statements")) {
                if (receiver instanceof TranViewRowModel) {
                    TranViewRowModel rowModel = (TranViewRowModel)receiver;
                    String section = "DB2 View";
                    MATTableModel baseModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                    arguments.put("Correlation", new Object[]{rowModel.getTransactionName()});
                    return baseModel != null && baseModel.contains(arguments);
                }
            } else {
                if (property.equals("hasDetails") && receiver instanceof TimeViewRowModel) {
                    TimeViewRowModel rowModel = (TimeViewRowModel)receiver;
                    return rowModel.hasDetails();
                }
                if (property.equals("hasHistogram") && receiver instanceof CodeViewRowModel) {
                    CodeViewRowModel rowModel = (CodeViewRowModel)receiver;
                    if (rowModel.getModule().startsWith(".") && rowModel.getCSECT().startsWith(".")) {
                        String mod = rowModel.getModule();
                        return ".USER".equals(mod) || ".EUSER".equals(mod) || ".COMMON".equals(mod) || ".ECOMMON".equals(mod);
                    }
                    return true;
                }
                if (property.equals("hasMethodDetails") && receiver instanceof JVMInfoRowModel) {
                    JVMInfoRowModel rowModel = (JVMInfoRowModel)receiver;
                    return !rowModel.getClassMethod().equals("** No Calls **");
                }
                if (property.equals("hasPoolDatasets") && receiver instanceof PoolDetailRowModel) {
                    PoolDetailRowModel rowModel = (PoolDetailRowModel)receiver;
                    String section = "BufferPoolDSN";
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                    arguments.put("poolkey", new Object[]{rowModel.getPoolKey()});
                    return model != null && model.contains(arguments);
                }
                if (property.equals("hasPoolDetails") && receiver instanceof PoolViewRowModel) {
                    PoolViewRowModel rowModel = (PoolViewRowModel)receiver;
                    String section = "BufferPoolDetails";
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                    arguments.put("poolgrp", new Object[]{rowModel.getGroup()});
                    arguments.put("pooltype", new Object[]{rowModel.getType()});
                    return model != null && model.contains(arguments);
                }
                if (property.equals("hasProcessInfoFromSelection") && receiver instanceof USSViewRowModel) {
                    USSViewRowModel rowModel = (USSViewRowModel)receiver;
                    String section = "USSView Process " + rowModel.getProcessId().trim();
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    return model != null;
                }
                if (property.equals("hasqueuedetails") && receiver instanceof MQQueueActivityRowModel) {
                    String manager = ((QueueActivitySubpage)page).getQueueManager();
                    MQQueueActivityRowModel rowModel = (MQQueueActivityRowModel)receiver;
                    String section = "MQ Queue Info " + manager + "," + rowModel.getQQNC8() + "," + rowModel.getRequestType();
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    return model != null;
                }
                if (property.equals("hasqueuemanagerdetails") && receiver instanceof MQViewRowModel) {
                    MQViewRowModel rowModel = (MQViewRowModel)receiver;
                    String section = "MQ Queue Manager " + rowModel.getQueueManager();
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    return model != null;
                }
                if (property.equals("canAddDispatcher") && receiver instanceof CodeViewRowModel && page instanceof ProgramViewPage) {
                    ProgramViewPage programPage = (ProgramViewPage)page;
                    CodeViewRowModel rowModel = (CodeViewRowModel)receiver;
                    String csect = rowModel.getCSECT();
                    if (csect == null || csect.trim().isEmpty()) {
                        return false;
                    }
                    return !programPage.isCsectInList(csect);
                }
            }
        }
        return false;
    }
}

