/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.rowmodels.LongNameTableRowModel;
import java.util.HashMap;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class JVMInfoRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow,
Cloneable {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    public static final String DATA_MODE_APPLICATION = "data_mode_application";
    public static final String DATA_MODE_VIA = "data_mode_via";
    public static final String DATA_MODE_CURRENT = "data_mode_current";
    public static final String DISPLAY_MODE_PROCESS = "display_mode_process";
    public static final String DISPLAY_MODE_APP = "display_mode_app";
    public static final String DISPLAY_MODE_METHODS = "display_mode_methods";
    public static final String DISPLAY_MODE_THREADS = "display_mode_threads";
    public static final String DISPLAY_MODE_LINES = "display_mode_lines";
    public static final String FIELD_JVMPID = "jvmpid";
    public static final String FIELD_JVMSRCE_APPLICATION = "jvmsrcea";
    public static final String FIELD_JVMSRCE_VIA = "jvmsrcev";
    public static final String FIELD_JVMSRCE_CURRENT = "jvmsrcec";
    public static final String FIELD_JVMMETH_APPLICATION = "jvmmetha";
    public static final String FIELD_JVMMETH_VIA = "jvmmethv";
    public static final String FIELD_JVMMETH_CURRENT = "jvmmethc";
    public static final String FIELD_JVMTCB = "jvmtcb";
    public static final String GROUP_BY_PROCESS = "group_by_process";
    public static final String GROUP_BY_METHOD = "group_by_method";
    public static final String GROUP_BY_THREAD = "group_by_thread";
    public static final String GROUP_BY_LINE = "group_by_line";
    private String jvmtcb = "";
    private String jvmpid = "";
    private String jvmuxid = "";
    private String jvmmetha = "";
    private String jvmsrcea = "";
    private String jvmlinea = "";
    private String jvmmethv = "";
    private String jvmsrcev = "";
    private String jvmlinev = "";
    private String jvmmethc = "";
    private String jvmsrcec = "";
    private String jvmlinec = "";
    private Double jvmpct = null;
    private String jvminfo = "";
    private String jvmtran = "";
    private String displayMode = null;
    private String dataMode = null;
    private String JVMInfoFinal = null;
    private String JVMReleaseFinal = null;
    private String JVMSourceFinal = null;
    private String JVMMethodFinal = null;

    public JVMInfoRowModel() {
        this(null);
    }

    public JVMInfoRowModel(MATTableModel model) {
        super(model);
    }

    @Override
    protected Object[] getArray() {
        if (this.displayMode == null) {
            throw new RuntimeException("displayMode not set in JVM row - check correspoding handler or analysistabbedview method");
        }
        if (this.displayMode.equals(DISPLAY_MODE_PROCESS)) {
            return new Object[]{this.jvmpid, this.getJvmRelease(), this.jvmpct, this.getJvmInfo()};
        }
        if (this.displayMode.equals(DISPLAY_MODE_APP)) {
            return new Object[]{this.getClassMethod(), this.getClassSource(), this.jvmpct};
        }
        if (this.displayMode.equals(DISPLAY_MODE_METHODS)) {
            return new Object[]{this.getClassMethod(), this.getClassSource(), this.jvmpct};
        }
        if (this.displayMode.equals(DISPLAY_MODE_THREADS)) {
            return new Object[]{this.jvmtcb, this.jvmuxid, this.jvmpct};
        }
        if (this.displayMode.equals(DISPLAY_MODE_LINES)) {
            return new Object[]{this.getLine(), this.jvmpct};
        }
        throw new RuntimeException(String.format("(%1$s) Unknown displayMode in getArray() (%2$s)", this.getClass().toString(), this.displayMode));
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        JVMInfoRowModel result = new JVMInfoRowModel(model);
        String value = attr.getValue("JVMTCB");
        if (value != null) {
            result.jvmtcb = value.trim();
        }
        if ((value = attr.getValue("JVMPID")) != null) {
            result.jvmpid = value.trim();
        }
        if ((value = attr.getValue("JVMUXID")) != null) {
            result.jvmuxid = value.trim();
        }
        if ((value = attr.getValue("JVMMETHA")) != null) {
            result.jvmmetha = value.trim();
        }
        if ((value = attr.getValue("JVMSRCEA")) != null) {
            result.jvmsrcea = value.trim();
        }
        if ((value = attr.getValue("JVMLINEA")) != null) {
            result.jvmlinea = value.trim();
        }
        if ((value = attr.getValue("JVMMETHV")) != null) {
            result.jvmmethv = value.trim();
        }
        if ((value = attr.getValue("JVMSRCEV")) != null) {
            result.jvmsrcev = value.trim();
        }
        if ((value = attr.getValue("JVMLINEV")) != null) {
            result.jvmlinev = value.trim();
        }
        if ((value = attr.getValue("JVMMETHC")) != null) {
            result.jvmmethc = value.trim();
        }
        if ((value = attr.getValue("JVMSRCEC")) != null) {
            result.jvmsrcec = value.trim();
        }
        if ((value = attr.getValue("JVMLINEC")) != null) {
            result.jvmlinec = value.trim();
        }
        if ((value = attr.getValue("JVMPCT")) != null) {
            result.jvmpct = Double.valueOf(value);
        }
        if ((value = attr.getValue("JVMINFO")) != null) {
            result.jvminfo = value.trim();
        }
        if ((value = attr.getValue("JVMTRAN")) != null) {
            result.jvmtran = value.trim();
        }
        return result;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (FIELD_JVMPID.equals(fieldName)) {
            return this.jvmpid.equals(value);
        }
        if (FIELD_JVMMETH_APPLICATION.equals(fieldName)) {
            return this.jvmmetha.equals(value);
        }
        if (FIELD_JVMMETH_VIA.equals(fieldName)) {
            return this.jvmmethv.equals(value);
        }
        if (FIELD_JVMMETH_CURRENT.equals(fieldName)) {
            return this.jvmmethc.equals(value);
        }
        if (FIELD_JVMSRCE_APPLICATION.equals(fieldName)) {
            return this.jvmsrcea.equals(value);
        }
        if (FIELD_JVMSRCE_VIA.equals(fieldName)) {
            return this.jvmsrcev.equals(value);
        }
        if (FIELD_JVMSRCE_CURRENT.equals(fieldName)) {
            return this.jvmsrcec.equals(value);
        }
        if (FIELD_JVMTCB.equals(fieldName)) {
            return this.jvmtcb.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public JVMInfoRowModel clone() {
        JVMInfoRowModel result = new JVMInfoRowModel(this.model);
        result.jvmtcb = this.jvmtcb;
        result.jvmpid = this.jvmpid;
        result.jvmuxid = this.jvmuxid;
        result.jvmmetha = this.jvmmetha;
        result.jvmmethv = this.jvmmethv;
        result.jvmmethc = this.jvmmethc;
        result.jvmsrcea = this.jvmsrcea;
        result.jvmsrcev = this.jvmsrcev;
        result.jvmsrcec = this.jvmsrcec;
        result.jvmlinea = this.jvmlinea;
        result.jvmlinev = this.jvmlinev;
        result.jvmlinec = this.jvmlinec;
        result.jvmpct = this.jvmpct;
        result.jvminfo = this.jvminfo;
        result.jvmtran = this.jvmtran;
        result.displayMode = this.displayMode;
        result.dataMode = this.dataMode;
        result.JVMInfoFinal = null;
        result.JVMMethodFinal = null;
        result.JVMReleaseFinal = null;
        result.JVMSourceFinal = null;
        return result;
    }

    public String getClassMethod() {
        if (this.JVMMethodFinal == null) {
            String input = null;
            if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
                input = this.jvmmetha;
            } else if (this.dataMode.equals(DATA_MODE_CURRENT)) {
                input = this.jvmmethc;
            } else if (this.dataMode.equals(DATA_MODE_VIA)) {
                input = this.jvmmethv;
            } else {
                throw new RuntimeException(String.format("getClassMethod: invalid dataMode (%s)", this.dataMode));
            }
            input = input.trim();
            if (input != null && input.equals("No Calls")) {
                this.JVMMethodFinal = "** No Calls **";
            } else {
                String value = null;
                MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("LongName", new Object[]{"JVMPI"});
                arguments.put("ShrtName", new Object[]{input});
                if (longNames != null) {
                    longNames = longNames.filterBy(arguments);
                }
                if (longNames != null) {
                    value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
                }
                if (value != null) {
                    this.JVMMethodFinal = value;
                }
            }
        }
        return this.JVMMethodFinal;
    }

    public String getClassSource() {
        if (this.JVMSourceFinal == null) {
            String input = null;
            if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
                input = this.jvmsrcea;
            } else if (this.dataMode.equals(DATA_MODE_CURRENT)) {
                input = this.jvmsrcec;
            } else if (this.dataMode.equals(DATA_MODE_VIA)) {
                input = this.jvmsrcev;
            } else {
                throw new RuntimeException(String.format("getClasssource: invalid dataMode (%s)", this.dataMode));
            }
            input = input.trim();
            if (input != null && (input.equals("0") || input.equals(""))) {
                this.JVMSourceFinal = "";
            } else {
                String value = null;
                MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("LongName", new Object[]{"JVMPI"});
                arguments.put("ShrtName", new Object[]{input});
                if (longNames != null) {
                    longNames = longNames.filterBy(arguments);
                }
                if (longNames != null) {
                    value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
                }
                if (value != null) {
                    this.JVMSourceFinal = value;
                }
            }
        }
        return this.JVMSourceFinal;
    }

    private String getJvmInfo() {
        if (this.JVMInfoFinal == null) {
            String value = null;
            MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("LongName", new Object[]{"JVMPI"});
            arguments.put("ShrtName", new Object[]{this.jvminfo});
            if (longNames != null) {
                longNames = longNames.filterBy(arguments);
            }
            if (longNames != null) {
                value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
            }
            if (value != null) {
                String[] pair = value.split(":", 2);
                this.JVMInfoFinal = pair[1];
            }
        }
        return this.JVMInfoFinal;
    }

    private String getJvmRelease() {
        if (this.JVMReleaseFinal == null) {
            String value = null;
            MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("LongName", new Object[]{"JVMPI"});
            arguments.put("ShrtName", new Object[]{this.jvminfo});
            if (longNames != null) {
                longNames = longNames.filterBy(arguments);
            }
            if (longNames != null) {
                value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
            }
            if (value != null) {
                String[] pair = value.split(":", 2);
                this.JVMReleaseFinal = pair[0];
            }
        }
        return this.JVMReleaseFinal;
    }

    public String getProcessId() {
        return this.jvmpid;
    }

    public void setDataMode(String dataMode) {
        this.dataMode = dataMode;
    }

    public String getDataMode() {
        return this.dataMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void addRow(JVMInfoRowModel jvmRow) {
        this.jvmpct = this.jvmpct + jvmRow.jvmpct;
    }

    public String getMethodId() {
        if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
            return this.jvmmetha;
        }
        if (this.dataMode.equals(DATA_MODE_CURRENT)) {
            return this.jvmmethc;
        }
        if (this.dataMode.equals(DATA_MODE_VIA)) {
            return this.jvmmethv;
        }
        throw new RuntimeException(String.format("getMethodId: invalid dataMode (%s)", this.dataMode));
    }

    public String getSourceId() {
        if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
            return this.jvmsrcea;
        }
        if (this.dataMode.equals(DATA_MODE_CURRENT)) {
            return this.jvmsrcec;
        }
        if (this.dataMode.equals(DATA_MODE_VIA)) {
            return this.jvmsrcev;
        }
        throw new RuntimeException(String.format("getSourceId: invalid dataMode (%s)", this.dataMode));
    }

    public String getThread() {
        return this.jvmtcb;
    }

    public String getLine() {
        if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
            return this.jvmlinea;
        }
        if (this.dataMode.equals(DATA_MODE_CURRENT)) {
            return this.jvmlinec;
        }
        if (this.dataMode.equals(DATA_MODE_VIA)) {
            return this.jvmlinev;
        }
        throw new RuntimeException(String.format("getLine: invalid dataMode (%s)", this.dataMode));
    }

    public Double getPct() {
        return this.jvmpct;
    }
}

