/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class IMSStatementRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow,
Cloneable {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final int TYPE_PSB = 0;
    public static final int TYPE_DBD = 1;
    public static final String DBD_NAME = "dbdname";
    public static final String TRAN_ID = "tranid";
    Logger log = Logger.getLogger(this.getClass().getName());
    public String trancode = "";
    public String psbname = "";
    public Integer psboff = null;
    public String dbdname = "";
    public String segment = "";
    public String calltype = "";
    public String procopts = "";
    public Double tcpu = null;
    public Double tpct = null;
    public Double dtot = null;
    public int modType = 0;

    public IMSStatementRowModel(MATTableModel model) {
        super(model);
    }

    public IMSStatementRowModel() {
        this(null);
    }

    @Override
    protected Object[] getArray() {
        if (this.modType == 0) {
            return new Object[]{this.psbname, this.psboff, this.dbdname, this.segment, this.calltype, this.procopts, this.tcpu, this.tpct, this.dtot};
        }
        if (this.modType == 1) {
            return new Object[]{this.dbdname, this.tcpu, this.tpct, this.dtot};
        }
        return null;
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        IMSStatementRowModel result = new IMSStatementRowModel();
        String value = attr.getValue("TRANCODE");
        if (value != null) {
            result.trancode = value.trim();
        }
        if ((value = attr.getValue("CALLTYPE")) != null) {
            result.calltype = value.trim();
        }
        if ((value = attr.getValue("DBDNAME")) != null) {
            result.dbdname = value.trim();
        }
        if ((value = attr.getValue("DTOT")) != null) {
            result.dtot = Double.valueOf(value);
        }
        if ((value = attr.getValue("PROCOPTS")) != null) {
            result.procopts = value.trim();
        }
        if ((value = attr.getValue("PSBNAME")) != null) {
            result.psbname = value.trim();
        }
        if ((value = attr.getValue("PSBOFF")) != null) {
            result.psboff = Integer.valueOf(value);
        }
        if ((value = attr.getValue("SEGMENT")) != null) {
            result.segment = value.trim();
        }
        if ((value = attr.getValue("TCPU")) != null) {
            result.tcpu = Double.valueOf(value);
        }
        if ((value = attr.getValue("TPCT")) != null) {
            result.tpct = Double.valueOf(value);
        }
        return result;
    }

    public IMSStatementRowModel clone() {
        IMSStatementRowModel result = new IMSStatementRowModel();
        result.psbname = this.psbname;
        result.psboff = this.psboff;
        result.dbdname = this.dbdname;
        result.segment = this.segment;
        result.calltype = this.calltype;
        result.procopts = this.procopts;
        result.tcpu = this.tcpu;
        result.tpct = this.tpct;
        result.dtot = this.dtot;
        return result;
    }

    public void setType(int type) {
        this.modType = type;
    }

    public void addRow(IMSStatementRowModel statementRow) {
        this.tcpu = this.tcpu + statementRow.tcpu;
        this.tpct = this.tpct + statementRow.tpct;
        this.dtot = this.dtot + statementRow.dtot;
    }

    public Double getAct() {
        return this.tcpu;
    }

    public Double getWait() {
        return this.tpct;
    }

    public Double getTotal() {
        return this.dtot;
    }

    public String getPSB() {
        return this.psbname;
    }

    public String getDBD() {
        return this.dbdname;
    }

    public String getSegment() {
        return this.segment;
    }

    public String getCallType() {
        return this.calltype;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (DBD_NAME.equals(fieldName)) {
            return this.dbdname != null && this.dbdname.equals(value);
        }
        if (TRAN_ID.equals(fieldName)) {
            return this.trancode != null && this.trancode.equals(value);
        }
        throw new IllegalArgumentException("field name unknown or null: " + fieldName);
    }
}

