/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class IDMSViewRowModel
extends MATTableRow
implements IXmlAttrHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String sourceClass = IDMSViewRowModel.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static String TYPE_MODULE = "MODULE";
    public static String TYPE_TASK = "TASK";
    private String modType = TYPE_MODULE;
    private String taskcode = "";
    private String tmodule = "";
    private String toffset = "";
    private String tstatus = "";
    private String twait = "";
    private Double dtot = null;

    public IDMSViewRowModel() {
        this(null);
    }

    public IDMSViewRowModel(MATTableModel model) {
        super(model);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        IDMSViewRowModel result = new IDMSViewRowModel(model);
        String value = null;
        value = attr.getValue("TASKCODE");
        if (value != null) {
            result.taskcode = value.trim();
        }
        if ((value = attr.getValue("TMODULE")) != null) {
            result.tmodule = value.trim();
        }
        if ((value = attr.getValue("TOFFSET")) != null) {
            result.toffset = value.trim();
        }
        if ((value = attr.getValue("TSTATUS")) != null) {
            result.tstatus = value.trim();
        }
        if ((value = attr.getValue("TWAIT")) != null) {
            result.twait = value.trim();
        }
        if ((value = attr.getValue("DTOT")) != null) {
            result.dtot = Double.valueOf(value);
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        if (this.modType.equals(TYPE_MODULE)) {
            return new Object[]{this.taskcode, this.tmodule, this.toffset, this.tstatus, this.dtot, this.twait};
        }
        if (this.modType.equals(TYPE_TASK)) {
            return new Object[]{this.taskcode, this.dtot};
        }
        return null;
    }

    public String getMode() {
        return this.modType;
    }

    public void setType(String modType) {
        this.modType = modType;
    }

    public String getModule() {
        return this.tmodule;
    }

    public String getTaskcode() {
        return this.taskcode;
    }

    public void addRow(IDMSViewRowModel codeRow) {
        this.dtot = this.dtot + codeRow.dtot;
    }

    public Double getTot() {
        return this.dtot;
    }

    public String getWait() {
        return this.twait;
    }

    public IDMSViewRowModel clone() {
        IDMSViewRowModel result = new IDMSViewRowModel();
        result.taskcode = this.taskcode;
        result.tmodule = this.tmodule;
        result.toffset = this.toffset;
        result.tstatus = this.tstatus;
        result.twait = this.twait;
        result.dtot = this.dtot;
        return result;
    }
}

