/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class HistogramRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow,
Cloneable {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String CSECT_ID = "cset";
    public static final String MODULE_ID = "modt";
    public static final String TASK_ID = "taskId";
    public static final String TRANSACTION_ID = "transactionId";
    public static final String DBRM = "dbrm";
    Logger log = Logger.getLogger(this.getClass().getName());
    private String cset = "";
    private String offn = "";
    private Long len = null;
    private Double actp = null;
    private Double waitp = null;
    private Double dtotal = null;
    private String modt = "";
    private Integer tstmt = null;
    private String tsrc1 = "";
    StringBuffer formattedOffset = null;
    private String taskId = "";
    private String transactionId = "";
    private String dbrm = "";
    private String locationName;

    public HistogramRowModel() {
        this(null, "");
    }

    public HistogramRowModel(boolean empty) {
        this(null, "");
        if (empty) {
            this.actp = 0.0;
            this.waitp = 0.0;
            this.dtotal = 0.0;
        }
    }

    public HistogramRowModel(MATTableModel model, String locationName) {
        this(null, "", null, null, null, null);
    }

    public HistogramRowModel(MATTableModel model, String locationName, String module, String csect, String offset, Long length) {
        super(model);
        this.locationName = locationName;
        this.cset = csect;
        this.modt = module;
        this.offn = offset;
        this.len = length;
    }

    @Override
    protected Object[] getArray() {
        String stmtString;
        String string = stmtString = this.tstmt == null ? "" : this.tstmt.toString();
        if (this.tstmt != null && this.tstmt == -1) {
            stmtString = ".END";
        }
        return new Object[]{this.cset, this.getFormattedOffn(), this.len, stmtString, this.tsrc1, this.actp, this.waitp, this.dtotal, this.tsrc1};
    }

    private String getFormattedOffn() {
        if (this.offn == null) {
            return "        ";
        }
        if (this.formattedOffset == null) {
            this.formattedOffset = new StringBuffer();
            int i = 0;
            while (i < 8 - this.offn.length()) {
                this.formattedOffset.append("0");
                ++i;
            }
            this.formattedOffset.append(this.offn);
        }
        return this.formattedOffset.toString();
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel dataset, String datasetName) {
        HistogramRowModel result = new HistogramRowModel(dataset, datasetName);
        String value = null;
        value = attr.getValue("ACTP");
        if (value != null) {
            result.actp = Double.valueOf(value.trim());
        }
        if ((value = attr.getValue("CSET")) != null) {
            result.cset = value.trim();
        }
        if ((value = attr.getValue("TSTMT")) != null) {
            result.tstmt = Integer.valueOf(value.trim());
        }
        if ((value = attr.getValue("DTOTAL")) != null) {
            result.dtotal = Double.valueOf(value.trim());
        }
        if ((value = attr.getValue("LEN")) != null) {
            result.len = Long.valueOf(value);
        }
        if ((value = attr.getValue("MODT")) != null) {
            result.modt = value.trim();
        }
        if ((value = attr.getValue("OFFN")) != null) {
            result.offn = value.trim();
        }
        if ((value = attr.getValue("WAITP")) != null) {
            result.waitp = Double.valueOf(value.trim());
        }
        if ((value = attr.getValue("TTASKID")) != null) {
            result.taskId = value.trim();
        }
        if ((value = attr.getValue("TTRAN")) != null) {
            result.transactionId = value.trim();
        }
        if ((value = attr.getValue("TDBRM")) != null) {
            result.dbrm = value.trim();
        }
        if ((value = attr.getValue("TCPU")) != null) {
            result.actp = Double.valueOf(value.trim());
        }
        if ((value = attr.getValue("TWAIT")) != null) {
            result.waitp = Double.valueOf(value.trim());
        }
        if ((value = attr.getValue("TPCT")) != null) {
            result.dtotal = Double.valueOf(value.trim());
        }
        if ((value = attr.getValue("TSRC1")) != null) {
            result.tsrc1 = value.trim();
        }
        return result;
    }

    public String getOffset() {
        return this.offn;
    }

    public Double getDelay() {
        return this.dtotal;
    }

    public void addRow(HistogramRowModel histRow) {
        this.actp = this.actp == null ? histRow.actp : histRow.actp + this.actp;
        this.waitp = this.waitp == null ? histRow.waitp : histRow.waitp + this.waitp;
        this.dtotal = this.dtotal == null ? histRow.dtotal : histRow.dtotal + this.dtotal;
    }

    public void addPercent(double active, double wait, double total) {
        this.actp = this.actp == null ? active : this.actp + active;
        this.waitp = this.waitp == null ? wait : this.waitp + wait;
        this.dtotal = this.dtotal == null ? total : this.dtotal + total;
    }

    public String getModule() {
        return this.modt;
    }

    public String getCSECT() {
        return this.cset;
    }

    public void setCSECT(String csect) {
        this.cset = csect;
    }

    public void setLength(long length) {
        this.len = length;
    }

    public void setOffset(String offset) {
        this.offn = offset;
        this.formattedOffset = null;
    }

    public void setStatement(Integer statement) {
        this.tstmt = statement;
    }

    public void setSourceLine(String sourceLine) {
        this.tsrc1 = sourceLine;
    }

    public void normalize(Double totalDelay) {
        this.actp = this.actp * 100.0 / totalDelay;
        this.waitp = this.waitp * 100.0 / totalDelay;
        this.dtotal = this.dtotal * 100.0 / totalDelay;
    }

    public HistogramRowModel clone() {
        HistogramRowModel clone = new HistogramRowModel(this.model, this.locationName);
        clone.cset = this.cset;
        clone.offn = this.offn;
        clone.len = this.len;
        clone.actp = this.actp;
        clone.waitp = this.waitp;
        clone.dtotal = this.dtotal;
        clone.modt = this.modt;
        clone.tstmt = this.tstmt;
        clone.tsrc1 = this.tsrc1;
        this.formattedOffset = null;
        return clone;
    }

    public double getTotal() {
        return this.dtotal;
    }

    public Integer getStatement() {
        return this.tstmt;
    }

    public String getVerb() {
        return this.tsrc1;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (CSECT_ID.equals(fieldName)) {
            return this.cset != null && this.cset.equals(value);
        }
        if (MODULE_ID.equals(fieldName)) {
            return this.modt != null && this.modt.equals(value);
        }
        if (TASK_ID.equals(fieldName)) {
            return this.taskId != null && this.taskId.equals(value);
        }
        if (TRANSACTION_ID.equals(fieldName)) {
            return this.transactionId != null && this.transactionId.equals(value);
        }
        if (DBRM.equals(fieldName)) {
            return this.dbrm != null && this.dbrm.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }
}

