/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class DelayLocationRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String MINOR_CATEGORY = "sourceStatement";
    public static final String TRANSACTION = "transaction";
    public static final String TASK = "task";
    private Integer sourceStatement = null;
    private String CSECT = "";
    private String description = "";
    private String module = "";
    private String offset = "";
    private Double active = 0.0;
    private Double wait = 0.0;
    private Double total = 0.0;
    private String D = "";
    private String C = "";
    private String X = "";
    private String minCat = null;
    private String taskId = null;
    private String tranId = null;
    private List<String> allCorrespondingOffsets = new ArrayList<String>();

    public DelayLocationRowModel() {
        this(null);
    }

    public DelayLocationRowModel(MATTableModel model) {
        this(null, null, null, null, null);
    }

    public DelayLocationRowModel(MATTableModel model, String module, String csect, String csectDesc, String offset) {
        super(model);
        this.CSECT = csect;
        this.description = csectDesc;
        this.module = module;
        this.offset = offset;
        this.allCorrespondingOffsets.add(offset);
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.module, this.CSECT, this.offset, this.description, this.sourceStatement, this.D, this.C, this.X, this.active, this.wait, this.total};
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        DelayLocationRowModel result = new DelayLocationRowModel(model);
        String value = null;
        value = attr.getValue("MODULE");
        if (value != null) {
            result.module = value.trim();
        }
        if ((value = attr.getValue("CSECT")) != null) {
            result.CSECT = value.trim();
        }
        if ((value = attr.getValue("OFFSET")) != null) {
            result.offset = value.trim();
        }
        if ((value = attr.getValue("PCT")) != null) {
            result.total = Double.valueOf(value);
        }
        if ((value = attr.getValue("FUNCTION")) != null) {
            result.description = value.trim();
        }
        if ((value = attr.getValue("STMT")) != null) {
            result.sourceStatement = Integer.valueOf(value);
        }
        if ((value = attr.getValue("DET")) != null) {
            result.D = value.trim();
        }
        if ((value = attr.getValue("CID")) != null) {
            result.C = value.trim();
        }
        if ((value = attr.getValue("XID")) != null) {
            result.X = value.trim();
        }
        if ((value = attr.getValue("MINCAT")) != null) {
            result.minCat = value.trim();
        }
        if ((value = attr.getValue("TTASKID")) != null) {
            result.taskId = value.trim();
        }
        if ((value = attr.getValue("TTRAN")) != null) {
            result.tranId = value.trim();
        }
        result.allCorrespondingOffsets.add(result.offset);
        return result;
    }

    public void setHasCallerId(boolean hasCallerId) {
        this.C = hasCallerId ? "Y" : "";
    }

    public void setHasExtendedCallerId(boolean hasExtendedCallerId) {
        this.X = hasExtendedCallerId ? "Y" : "";
    }

    public void setHasDetail(boolean hasDetail) {
        this.D = hasDetail ? "Y" : "";
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (MINOR_CATEGORY.equals(fieldName)) {
            return this.minCat != null && this.minCat.equals(value);
        }
        if (TRANSACTION.equals(fieldName)) {
            return this.tranId != null && this.tranId.equals(value);
        }
        if (TASK.equals(fieldName)) {
            return this.taskId != null && this.taskId.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public void addTotal(double percent) {
        this.total = this.total == null ? percent : this.total + percent;
    }

    public void addActive(double percent) {
        this.active = this.active == null ? percent : this.active + percent;
    }

    public void addWait(double percent) {
        this.wait = this.wait == null ? percent : this.wait + percent;
    }

    public String getModule() {
        return this.module;
    }

    public String getCsect() {
        return this.CSECT;
    }

    public String getMinorCategory() {
        return this.minCat;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getOffset() {
        return this.offset;
    }

    public List<String> getAllCorrespondingOffsets() {
        return this.allCorrespondingOffsets;
    }

    public void setStatement(Integer statement) {
        this.sourceStatement = statement;
    }

    public Integer getStatement() {
        return this.sourceStatement;
    }

    public double getActive() {
        return this.active;
    }

    public double getWait() {
        return this.wait;
    }

    public double getTotal() {
        return this.total;
    }

    public void setActive(Double a) {
        this.active = a;
    }

    public void setWait(Double w) {
        this.wait = w;
    }

    public void setTotal(Double t) {
        this.total = t;
    }

    public void addRow(DelayLocationRowModel resultRow) {
        this.addActive(resultRow.getActive());
        this.addWait(resultRow.getWait());
        this.addTotal(resultRow.getTotal());
        this.getAllCorrespondingOffsets().add(resultRow.getOffset());
    }
}

