/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class CodeViewRowModel
extends MATTableRow
implements IXmlAttrHandler,
Cloneable,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String sourceClass = CodeViewRowModel.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static String TYPE_CSECT = "CSECT";
    public static String TYPE_MODULE = "MODULE";
    public static String TYPE_PSEUDO = "PSEUDO";
    public static final String FIELD_CSECT = "csect";
    public static final String FIELD_MODULE = "modt";
    public static final String TRAN_ID = "ttran";
    public static final String TASK_ID = "ttaskid";
    public static final String DBRM_ID = "tdbrm";
    public static final String DBRMNR_ID = "tdbrmnr";
    private String modType = TYPE_CSECT;
    private String xpseudo = "";
    private String modt = "";
    private String csect = "";
    private String xunction = "";
    private String tloc = "";
    private String cid = "";
    private String xid = "";
    private Double pcta = null;
    private Double pctd = null;
    private Double dpctt = null;
    private Double pcti = null;
    private String munction = null;
    private String punction = null;
    private String ttran = null;
    private String ttaskid = null;
    private String tdbrm = null;
    private String tdbrmnr = null;
    private String locationName;

    public CodeViewRowModel() {
        this(null, "");
    }

    public CodeViewRowModel(MATTableModel dataset, String locationName) {
        this(dataset, locationName, null, null, null, null, null, null, null, null, null);
    }

    public CodeViewRowModel(MATTableModel dataset, String locationName, String module, String moduleDescription, String csect, String csectDescription, String pseudo, String pseudoDescription, String tloc, String cid, String xid) {
        super(dataset);
        if (locationName.equals("")) {
            return;
        }
        if (locationName.startsWith("Tran Code Detail")) {
            this.modType = TYPE_CSECT;
        } else if (locationName.startsWith("Task Code Details")) {
            this.modType = TYPE_CSECT;
        } else if (locationName.startsWith("IMS Code Detail")) {
            this.modType = TYPE_CSECT;
        } else if (locationName.startsWith("DB2 Code Details")) {
            this.modType = TYPE_CSECT;
        } else if (locationName.equals("CodeView Details")) {
            this.modType = TYPE_CSECT;
        } else if (locationName.equals("calculated")) {
            this.modType = TYPE_CSECT;
        } else {
            throw new RuntimeException(String.format("CodeView section has invalid mode - (%s)", locationName));
        }
        this.modt = module;
        this.munction = moduleDescription;
        this.csect = csect;
        this.xunction = csectDescription;
        this.xpseudo = pseudo;
        this.punction = pseudoDescription;
        this.tloc = tloc;
        this.cid = cid;
        this.xid = xid;
    }

    @Override
    protected Object[] getArray() {
        if (this.modType.equals(TYPE_CSECT)) {
            return new Object[]{this.modt, this.csect, this.xunction, this.tloc, this.cid, this.xid, this.pcta, this.pctd, this.dpctt, this.pcti};
        }
        if (this.modType.equals(TYPE_MODULE)) {
            return new Object[]{this.xpseudo, this.modt, this.munction, this.tloc, this.cid, this.xid, this.pcta, this.pctd, this.dpctt, this.pcti};
        }
        if (this.modType.equals(TYPE_PSEUDO)) {
            return new Object[]{this.xpseudo, this.punction, this.pcta, this.pctd, this.dpctt, this.pcti};
        }
        return null;
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel dataset, String datasetName) {
        CodeViewRowModel result = new CodeViewRowModel(dataset, datasetName);
        String value = null;
        value = attr.getValue("XPSEUDO");
        if (value != null) {
            result.xpseudo = value.trim();
        }
        if ((value = attr.getValue("CID")) != null) {
            result.cid = value.trim();
        }
        if ((value = attr.getValue("CSET")) != null) {
            result.csect = value.trim();
        }
        if ((value = attr.getValue("DPCTT")) != null) {
            result.dpctt = Double.valueOf(value);
        }
        if ((value = attr.getValue("XUNCTION")) != null) {
            result.xunction = value.trim();
        }
        if ((value = attr.getValue("MODT")) != null) {
            result.modt = value.trim();
        }
        if ((value = attr.getValue("PCTA")) != null) {
            result.pcta = Double.valueOf(value);
        }
        if ((value = attr.getValue("PCTD")) != null) {
            result.pctd = Double.valueOf(value);
        }
        if ((value = attr.getValue("PCTI")) != null) {
            result.pcti = Double.valueOf(value);
        }
        if ((value = attr.getValue("TLOC")) != null) {
            result.tloc = value.trim();
        }
        if ((value = attr.getValue("XID")) != null) {
            result.xid = value.trim();
        }
        if ((value = attr.getValue("TTASKID")) != null) {
            result.ttaskid = value.trim();
        }
        if ((value = attr.getValue("TTRAN")) != null) {
            result.ttran = value.trim();
        }
        if ((value = attr.getValue("TDBRM")) != null) {
            result.tdbrm = value.trim();
        }
        if ((value = attr.getValue("TDBRMNR")) != null) {
            result.tdbrmnr = value.trim();
        }
        if ((value = attr.getValue("MUNCTION")) != null) {
            result.munction = value.trim();
        }
        if ((value = attr.getValue("PUNCTION")) != null) {
            result.punction = value.trim();
        }
        if (result.munction == null) {
            result.munction = result.xunction;
        }
        if (result.punction == null) {
            result.punction = result.xunction;
        }
        return result;
    }

    public String getCSECT() {
        return this.csect;
    }

    public String getHistogramSection() {
        return "Histogram " + this.csect;
    }

    public String getModule() {
        return this.modt;
    }

    public String getPseudoGroup() {
        return this.xpseudo;
    }

    public void addRow(CodeViewRowModel codeRow) {
        this.addPercent(codeRow.pcta == null ? 0.0 : codeRow.pcta, codeRow.pctd == null ? 0.0 : codeRow.pctd, codeRow.dpctt == null ? 0.0 : codeRow.dpctt, codeRow.pcti == null ? 0.0 : codeRow.pcti);
    }

    public void addPercent(double active, double wait, double total, double overlap) {
        this.pcta = this.pcta == null ? active : this.pcta + active;
        this.pctd = this.pctd == null ? wait : this.pctd + wait;
        this.dpctt = this.dpctt == null ? total : this.dpctt + total;
        this.pcti = this.pcti == null ? overlap : this.pcti + overlap;
    }

    public boolean hasCallerId() {
        return "Y".equals(this.cid);
    }

    public void setHasCallerId(boolean hasCallerId) {
        this.cid = hasCallerId ? "Y" : "";
    }

    public boolean hasExtendedCallerId() {
        return "Y".equals(this.xid);
    }

    public void setHasExtendedCallerId(boolean hasExtendedCallerId) {
        this.xid = hasExtendedCallerId ? "Y" : "";
    }

    public String getMode() {
        return this.modType;
    }

    public void setType(String modType) {
        this.modType = modType;
    }

    public CodeViewRowModel clone() {
        CodeViewRowModel result = new CodeViewRowModel();
        result.xpseudo = this.xpseudo;
        result.cid = this.cid;
        result.csect = this.csect;
        result.dpctt = this.dpctt;
        result.xunction = this.xunction;
        result.munction = this.munction;
        result.punction = this.punction;
        result.modt = this.modt;
        result.pcta = this.pcta;
        result.pctd = this.pctd;
        result.pcti = this.pcti;
        result.tloc = this.tloc;
        result.xid = this.xid;
        result.ttran = this.ttran;
        result.ttaskid = this.ttaskid;
        result.tdbrm = this.tdbrm;
        result.tdbrmnr = this.tdbrmnr;
        return result;
    }

    public String getCallerIdSection() {
        String modulePart = this.modt.equals("") ? "" : " " + this.modt;
        String csectPart = this.csect.equals("") ? "" : " " + this.csect;
        return "Callerid" + modulePart + csectPart;
    }

    public String getCallerIdName() {
        String modulePart = this.modt.equals("") ? "" : " " + this.modt;
        String csectPart = this.csect.equals("") ? "" : " " + this.csect;
        return String.valueOf(modulePart) + csectPart;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (TASK_ID.equals(fieldName)) {
            return this.ttaskid != null && this.ttaskid.equals(value);
        }
        if (TRAN_ID.equals(fieldName)) {
            return this.ttran != null && this.ttran.equals(value);
        }
        if (DBRM_ID.equals(fieldName)) {
            return this.tdbrm != null && this.tdbrm.equals(value);
        }
        if (DBRMNR_ID.equals(fieldName)) {
            return this.tdbrmnr != null && this.tdbrmnr.equals(value);
        }
        if (FIELD_CSECT.equals(fieldName)) {
            return this.csect != null && this.csect.equals(value);
        }
        if (FIELD_MODULE.equals(fieldName)) {
            return this.modt != null && this.modt.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public Double getTotal() {
        return this.dpctt;
    }

    public double getActive() {
        return this.pcta;
    }

    public double getWait() {
        return this.pctd;
    }
}

