/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableFilter;
import com.ca.mat.common.table.MATTableViewerListener;
import com.ca.mat.managers.Singletons;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class ViewerSynchronizationManager
implements MATTableViewerListener {
    static String cacopyright = "Copyright \u00a9 2015 CA";
    private ConcurrentHashMap<String, List<IMATTableViewer>> map = new ConcurrentHashMap();
    private ConcurrentHashMap<IMATTableViewer, String> reverseMap = new ConcurrentHashMap();
    private WeakReference<Display> displayWeakRef = new WeakReference<Display>(Display.getCurrent());

    public void addViewer(String modelName, IMATTableViewer viewer) {
        if (modelName == null) {
            return;
        }
        this.map.putIfAbsent(modelName, new CopyOnWriteArrayList());
        List<IMATTableViewer> list = this.map.get(modelName);
        if (!list.isEmpty()) {
            IMATTableViewer reference = list.get(0);
            viewer.syncWith(reference);
        } else {
            IMemento memento = Singletons.getPersistenceManager((Display)this.displayWeakRef.get()).get(modelName);
            if (memento != null) {
                viewer.loadPropsFromMemento(memento);
            }
        }
        this.map.get(modelName).add(viewer);
        this.reverseMap.put(viewer, modelName);
        viewer.addViewerListener(this);
    }

    public void removeViewer(IMATTableViewer viewer) {
        if (viewer == null) {
            return;
        }
        String modelName = this.reverseMap.get(viewer);
        if (modelName != null) {
            if (!this.map.containsKey(modelName)) {
                return;
            }
            this.map.get(modelName).remove(viewer);
            this.reverseMap.remove(viewer);
            viewer.removeViewerListener(this);
            if (this.map.get(modelName).isEmpty()) {
                this.persist(modelName, viewer);
            }
        }
    }

    public void clearAll() {
        this.map = new ConcurrentHashMap();
        this.reverseMap = new ConcurrentHashMap();
    }

    public void resetGroup(String modelName) {
        List<IMATTableViewer> groupContent;
        if (modelName != null && (groupContent = this.map.get(modelName)) != null) {
            this.map.remove(groupContent);
            for (IMATTableViewer entry : groupContent) {
                entry.resetColumns();
                entry.resetColumnOrder();
                entry.resetSortColumn();
                entry.resetSortDirection();
                if (entry.getTable().isDisposed()) continue;
                entry.refresh();
            }
            this.map.put(modelName, groupContent);
        }
        Singletons.getPersistenceManager((Display)this.displayWeakRef.get()).reset(modelName);
    }

    public String findGroup(IMATTableViewer viewer) {
        if (viewer != null) {
            for (Map.Entry<String, List<IMATTableViewer>> entry : this.map.entrySet()) {
                if (!entry.getValue().contains(viewer)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void persistAll() {
        for (Map.Entry<String, List<IMATTableViewer>> entry : this.map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            IMATTableViewer first = entry.getValue().get(0);
            this.persist(entry.getKey(), first);
        }
    }

    private void persist(String id, IMATTableViewer viewer) {
        IMemento memento = Singletons.getPersistenceManager((Display)this.displayWeakRef.get()).createNew();
        viewer.savePropsToMemento(memento);
        Singletons.getPersistenceManager((Display)this.displayWeakRef.get()).set(id, memento);
    }

    @Override
    public void columnResized(IMATTableViewer viewer, int column, int width) {
        String modelName = this.reverseMap.get(viewer);
        if (modelName != null) {
            for (IMATTableViewer entry : this.map.get(modelName)) {
                if (viewer.equals(entry)) continue;
                if (this.checkViewer(entry)) {
                    entry.setColumnWidth(column, width);
                    continue;
                }
                this.map.get(modelName).remove(entry);
            }
        }
    }

    @Override
    public void columnMoved(IMATTableViewer viewer, int column, int position) {
        int[] columnOrder = viewer.getColumnOrder();
        String modelName = this.reverseMap.get(viewer);
        if (modelName != null) {
            for (IMATTableViewer entry : this.map.get(modelName)) {
                if (viewer.equals(entry)) continue;
                if (this.checkViewer(entry)) {
                    entry.setColumnOrder(columnOrder);
                    continue;
                }
                this.map.get(modelName).remove(entry);
            }
        }
    }

    @Override
    public void columnShownOrHidden(IMATTableViewer viewer, int column, boolean visible) {
        String modelName = this.reverseMap.get(viewer);
        if (modelName != null && modelName != null) {
            for (IMATTableViewer entry : this.map.get(modelName)) {
                if (viewer.equals(entry)) continue;
                if (this.checkViewer(entry)) {
                    entry.setColumnVisible(column, visible);
                    continue;
                }
                this.map.get(modelName).remove(entry);
            }
        }
    }

    @Override
    public void sortChanged(IMATTableViewer viewer, int column, int direction) {
        String modelName;
        if (Singletons.getCompareManager().getCompare() && (modelName = this.reverseMap.get(viewer)) != null) {
            for (IMATTableViewer entry : this.map.get(modelName)) {
                if (viewer.equals(entry)) continue;
                if (this.checkViewer(entry)) {
                    entry.setSortColumn(column, false);
                    entry.setSortDirection(direction, false);
                    continue;
                }
                this.map.get(modelName).remove(entry);
            }
        }
    }

    private boolean checkViewer(IMATTableViewer viewer) {
        return !viewer.getControl().isDisposed();
    }

    @Override
    public void filterAdded(MATTableFilter filter) {
    }

    @Override
    public void filterRemoved(MATTableFilter filter) {
    }
}

