/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.XMLParser;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.connect.MATServer;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.IMonitorListener;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorHistoryRowModel;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.rowmodels.tuntables.ScheduleRowModel;
import com.ca.mat.rowmodels.tuntables.TunprofRowModel;
import com.ca.mat.xml.XMLRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class MonitorManager {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    Logger log;
    private static final String MONITOR_LIST_HEADER = "Profile   Job name  Runs Status";
    private static final String MONITOR_LIST_HEADER_TOOLTIP = "Monitor list header";
    public static final int MONITOR_HISTORY_EMPTY = 0;
    public static final int MONITOR_HISTORY_READY = 1;
    public static final int MONITOR_HISTORY_DOWNLOADING = 2;
    public static final int MONITOR_HISTORY_ERROR = 3;
    private List<IMonitorListener> listeners = new CopyOnWriteArrayList<IMonitorListener>();
    private Map<String, MATTableModel> monitorHistory = new HashMap<String, MATTableModel>();
    private Map<String, Integer> monitorHistoryStatus = new HashMap<String, Integer>();
    private MATTableModel monitorProfiles = new MATTableModel();
    private MATTableModel monitorSchedulesPublic = new MATTableModel();
    private MATTableModel monitorSchedulesInternal = new MATTableModel();
    private WeakReference<Display> displayWeakRef = new WeakReference<Display>(Display.getCurrent());
    private static TunprofRowModel tunProfile;

    public MonitorManager() {
        this.log = Logging.getLogger((Display)this.displayWeakRef.get());
    }

    public MATTableModel getMonitorProfilesTable() {
        return this.monitorProfiles;
    }

    public MATTableModel getMonitorSchedulesTable() {
        return this.monitorSchedulesPublic;
    }

    public void clearMonitorHistory(MATServer server) {
        this.monitorHistory.clear();
        this.monitorHistoryStatus.clear();
    }

    public void addMonitorListener(IMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void removeMonitorListener(IMonitorListener listener) {
        this.listeners.remove(listener);
    }

    public boolean profileExists(String profileName) {
        if (this.monitorProfiles != null) {
            MATTableRow[] mATTableRowArray = this.monitorProfiles.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow monProfile = mATTableRowArray[n2];
                MonitorProfileRowModel monProfileRow = (MonitorProfileRowModel)monProfile;
                if (monProfileRow.getProfileName() != null && monProfileRow.getProfileName().equals(profileName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public MonitorProfileRowModel profileData(String profileName) {
        MATTableRow[] mATTableRowArray = this.monitorProfiles.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow monProfile = mATTableRowArray[n2];
            MonitorProfileRowModel monProfileRow = (MonitorProfileRowModel)monProfile;
            if (monProfileRow.getProfileName() != null && monProfileRow.getProfileName().equals(profileName)) {
                return monProfileRow;
            }
            ++n2;
        }
        return null;
    }

    public int getHistoryStatus(String profile) {
        if (this.monitorHistoryStatus.containsKey(profile)) {
            return this.monitorHistoryStatus.get(profile);
        }
        return 0;
    }

    public void historyDownloadStarted(String profile) {
        this.monitorHistoryStatus.put(profile, 2);
    }

    public void historyDownloadFinished(MATServer server, String profile, XMLRequest reply) throws Exception {
        InputStream inputStream;
        File attachedFile = null;
        if (reply.hasAttachedFile()) {
            attachedFile = reply.getAttachedFile();
            Singletons.getTempFilesManager((Display)this.displayWeakRef.get()).registerTempFile(attachedFile);
            inputStream = new BufferedInputStream(new FileInputStream(attachedFile));
        } else {
            inputStream = reply.toInputStream();
        }
        if (this.monitorHistory.containsKey(profile)) {
            this.monitorHistory.remove(profile);
        }
        new XMLParser(null, inputStream, (Display)this.displayWeakRef.get());
        try {
            inputStream.close();
            if (attachedFile != null) {
                Singletons.getTempFilesManager((Display)this.displayWeakRef.get()).unregisterTempFile(attachedFile);
            }
        }
        catch (IOException e1) {
            this.log.log(Level.INFO, "Exception while closing attachment with monitor history data", e1);
        }
        this.monitorHistoryStatus.put(profile, 1);
        this.notifyListenersHistory(server, profile);
    }

    public void historyDownloadFailed(String profile) {
        this.monitorHistoryStatus.put(profile, 3);
    }

    public void setProfiles(MATTableModel profiles) {
        this.monitorProfiles = profiles;
        this.notifyListenersProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedules(MATTableModel schedules) {
        MATTableModel mATTableModel = this.monitorSchedulesPublic;
        synchronized (mATTableModel) {
            this.monitorSchedulesInternal = schedules;
            this.monitorSchedulesPublic = new MATTableModel();
            int i = 0;
            while (i < schedules.getRows().length) {
                ScheduleRowModel row = (ScheduleRowModel)schedules.getRows()[i];
                if (row.getType() != null && row.getType().equals("P")) {
                    this.monitorSchedulesPublic.addRow(row);
                }
                ++i;
            }
        }
        this.notifyListenersSchedule();
    }

    public void clearProfiles() {
        this.monitorProfiles = null;
        this.notifyListenersProfile();
    }

    public void addHistory(MATTableModel history) {
        if (history != null && history.getRows().length > 0) {
            String profileName = ((MonitorHistoryRowModel)history.getRows()[0]).getProfileName();
            this.monitorHistory.put(profileName, history);
        }
    }

    public MATTableModel getHistoryForMonitor(String profileName) {
        MATTableModel result = this.monitorHistory.get(profileName);
        return result;
    }

    public void notifyListenersProfile() {
        for (IMonitorListener listener : this.listeners) {
            listener.monitorProfilesUpdated(this.monitorProfiles);
        }
    }

    public void notifyListenersSchedule() {
        for (IMonitorListener listener : this.listeners) {
            listener.monitorSchedulesUpdated(this.monitorSchedulesPublic);
        }
    }

    public void notifyListenersHistory(MATServer server, String profile) {
        for (IMonitorListener listener : this.listeners) {
            listener.monitorHistoryUpdated(server, profile, this.monitorHistory.get(profile));
        }
    }

    public synchronized boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public TunprofRowModel getTunProfile() {
        return tunProfile;
    }

    public void setTunProfile(TunprofRowModel row) {
        tunProfile = row;
    }
}

