/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.Activator;
import com.ca.mat.XMLParser;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.connect.AnalysisPostprocessJob;
import com.ca.mat.connect.MATFamily;
import com.ca.mat.connect.MATServer;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.IAnalysisListener;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.LogRowModel;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.LocalXMLFilesView;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.xml.XMLRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.framework.Bundle;

public class AnalysisManager {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final int ANALYSIS_TYPE_NORMAL = 0;
    public static final int ANALYSIS_TYPE_ALL = 1;
    public static final int ANALYSIS_TYPE_ACTIVE = 2;
    public static final int ANALYSIS_TYPE_WAIT = 3;
    public static final int ANALYSIS_STATE_NONE = 0;
    public static final int ANALYSIS_STATE_LOADING = 1;
    public static final int ANALYSIS_STATE_READY = 2;
    public static final int ANALYSIS_STATE_EMPTY = 21;
    public static final int ANALYSIS_STATE_CANCELLED = 3;
    public static final int ANALYSIS_STATE_NOT_IN_LOCAL = 4;
    public static final int ANALYSIS_STATE_PROCESSING = 5;
    public static final int ANALYSIS_STATE_FAILED = 666;
    public String messages;
    private static ConcurrentHashMap<String, MATTableModel> staticCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, MATTableModel[]>> cache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer[]> flags = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, CopyOnWriteArrayList<IAnalysisListener>> listeners = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<Job>> jobs = new ConcurrentHashMap();
    private List<LocalXMLFilesView> localFileViews = new ArrayList<LocalXMLFilesView>();
    private IPersistentPreferenceStore store;
    private AnalysisPage focusedAnalysis;
    IContextActivation activeContext;
    private static final String END_SECTION = "XML COMPLETED";
    Logger log;
    WeakReference<Display> displayWeakRef = new WeakReference<Display>(Display.getCurrent());
    public boolean cancelled = false;

    public AnalysisManager() {
        this.store = Singletons.getUserPreferenceManager((Display)this.displayWeakRef.get()).getStoreForUserId();
        this.log = Logging.getLogger((Display)this.displayWeakRef.get());
    }

    public static String analysisTypeToString(int type) {
        switch (type) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "All";
            }
            case 2: {
                return "Active";
            }
            case 3: {
                return "Wait";
            }
        }
        return "Unknown";
    }

    public void putStatic(String modelName, MATTableModel model) {
        staticCache.put(modelName, model);
    }

    public void put(String datasetName, String modelName, MATTableModel model) {
        this.put(datasetName, modelName, model, 0);
    }

    public void put(String datasetName, String modelName, MATTableModel model, int analysisType) {
        if (datasetName == null || modelName == null) {
            return;
        }
        String key = modelName.replaceAll("\\b\\s{2,}\\b", " ");
        cache.putIfAbsent(datasetName, new ConcurrentHashMap());
        ConcurrentHashMap<String, MATTableModel[]> map = cache.get(datasetName);
        map.putIfAbsent(key, new MATTableModel[4]);
        map.get((Object)key)[analysisType] = model;
    }

    public void analysisParsingCompleted(String dsn, int analysisType) {
        if (dsn == null) {
            return;
        }
        if (this.getModel(dsn, "OverView", analysisType) == null) {
            this.setAnalysisState(dsn, analysisType, 21);
        } else {
            this.setAnalysisState(dsn, analysisType, 2);
        }
        this.notifyChangeListeners(dsn);
    }

    public void analysisIsEmpty(String dsn, int analysisType) {
        this.setAnalysisState(dsn, analysisType, 21);
    }

    public void analysisCancelled(String dsn, int analysisType) {
        this.setAnalysisState(dsn, analysisType, 3);
    }

    public void analysisPageFocused(AnalysisPage page) {
        IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        try {
            IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IEvaluationService.class);
            IEvaluationContext context = evaluationService.getCurrentState();
            service.deferUpdates(true);
            if (page.getSelectionProvider() == null) {
                context.addVariable("selection", (Object)new StructuredSelection());
            } else if (context.getVariable("selection") == null || !context.getVariable("selection").equals(page.getSelectionProvider().getSelection())) {
                context.addVariable("selection", (Object)page.getSelectionProvider().getSelection());
            }
            if (this.focusedAnalysis == null || !this.focusedAnalysis.equals(page)) {
                this.focusedAnalysis = page;
                if (this.activeContext != null) {
                    service.deactivateContext(this.activeContext);
                }
                this.activeContext = service.activateContext(page.getId());
            }
        }
        finally {
            service.deferUpdates(false);
        }
    }

    public AnalysisPage getFocusedAnalysisPage() {
        return this.focusedAnalysis;
    }

    public void registerJob(final String dsn, final int analysisType, final Job job) {
        if (!this.jobs.containsKey(dsn)) {
            this.jobs.put(dsn, new ArrayList());
        }
        this.jobs.get(dsn).add(job);
        job.addJobChangeListener(new IJobChangeListener(){

            public void done(IJobChangeEvent event) {
                AnalysisManager.this.removeJob(dsn, job);
                if (event.getResult() == Status.CANCEL_STATUS && AnalysisManager.this.getAnalysisState(dsn, analysisType) == 1) {
                    AnalysisManager.this.setAnalysisState(dsn, analysisType, 3);
                    AnalysisManager.this.cancelled = true;
                }
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
    }

    public void removeJob(String dsn, Job job) {
        this.jobs.get(dsn).remove(job);
    }

    public void cancelRunningJobs(String dsn) {
        if (this.jobs.get(dsn) != null) {
            Iterator<Job> iter = this.jobs.get(dsn).iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }
        MATFamily dsnFamily = new MATFamily((Display)this.displayWeakRef.get(), 1);
        dsnFamily.setDSN(dsn);
        Job.getJobManager().cancel((Object)dsnFamily);
    }

    public boolean hasRunningJobs(String dsn) {
        return this.jobs.get(dsn) != null && !this.jobs.get(dsn).isEmpty();
    }

    public void registerLocalXMLView(LocalXMLFilesView view) {
        this.localFileViews.add(view);
    }

    public void removeLocalXMLView(LocalXMLFilesView view) {
        this.localFileViews.remove(view);
    }

    public void refreshLocalXMLViews() {
        for (LocalXMLFilesView view : this.localFileViews) {
            view.refreshModel();
        }
    }

    public void analysisRequested(String dsn, int analysisType) {
        this.setAnalysisState(dsn, analysisType, 1);
    }

    public void analysisRequestFailed(String dsn, int analysisType) {
        this.setAnalysisState(dsn, analysisType, 666);
    }

    public int getAnalysisState(String dsn, int analysisType) {
        if (dsn == null || flags.get(dsn) == null) {
            return 0;
        }
        return flags.get(dsn)[analysisType];
    }

    private void setAnalysisState(String dsn, int analysisType, int state) {
        if (dsn == null) {
            return;
        }
        flags.putIfAbsent(dsn, new Integer[]{0, 0, 0, 0});
        AnalysisManager.flags.get((Object)dsn)[analysisType] = state;
        this.notifyChangeListeners(dsn);
    }

    private void notifyChangeListeners(final String dsn) {
        CopyOnWriteArrayList<IAnalysisListener> list = listeners.get(dsn);
        if (list != null) {
            Iterator<IAnalysisListener> it = list.iterator();
            while (it.hasNext()) {
                final IAnalysisListener listener = it.next();
                Display listenerDispl = listener.getDisplay();
                if (listenerDispl == null) continue;
                if (listenerDispl.isDisposed()) {
                    it.remove();
                    continue;
                }
                listenerDispl.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        listener.analysisChanged(dsn);
                    }
                });
            }
        }
    }

    public MATTableModel getModel(String datasetName, String modelName, int analysisType) {
        if (datasetName == null || modelName == null) {
            return null;
        }
        Map map = cache.get(datasetName);
        if (map != null && map.get(modelName) != null) {
            return ((MATTableModel[])map.get(modelName))[analysisType];
        }
        return null;
    }

    public MATTableModel getStaticModel(String modelName) {
        if (modelName == null) {
            return null;
        }
        return staticCache.get(modelName);
    }

    public int getSampleCount(String datasetName, int analysisType) {
        MATTableModel model = this.getModel(datasetName, "TimeView", analysisType);
        return model == null ? 0 : model.getRows().length;
    }

    public boolean hasModel(String datasetName, String modelName) {
        if (datasetName == null || modelName == null) {
            return false;
        }
        Map map = cache.get(datasetName);
        return map != null && map.get(modelName) != null;
    }

    public void addAnalysisListener(IAnalysisListener listener, String dsn) {
        if (dsn == null) {
            return;
        }
        listeners.putIfAbsent(dsn, new CopyOnWriteArrayList());
        listeners.get(dsn).add(listener);
    }

    public void removeAnalysisListener(IAnalysisListener listener, String dsn) {
        if (dsn == null || !listeners.containsKey(dsn)) {
            return;
        }
        CopyOnWriteArrayList<IAnalysisListener> list = listeners.get(dsn);
        list.remove(listener);
        if (list.isEmpty()) {
            this.removeAnalysis(dsn);
            this.cancelRunningJobs(dsn);
            listeners.remove(dsn);
        }
    }

    public void processAnalysis(InputStream inStream, String dsn, String profile, int analysisType, boolean showView, String messages) {
        this.processAnalysis(inStream, dsn, profile, new int[]{analysisType}, showView, messages);
    }

    public void processAnalysis(final InputStream inStream, final String dsn, final String profile, final int[] analysisTypes, final boolean showView, final String messages) {
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        int[] nArray = analysisTypes;
        int n = analysisTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.setAnalysisState(dsn, type, 5);
            ++n2;
        }
        Job job = new Job(String.format("Process analysis results for %s", profile)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int type;
                    SequenceInputStream sequence = new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream("<dummyRoot>".getBytes()), inStream, new ByteArrayInputStream("</dummyRoot>".getBytes()))));
                    new XMLParser(dsn, sequence, (Display)AnalysisManager.this.displayWeakRef.get());
                    int[] nArray = analysisTypes;
                    int n = analysisTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        type = nArray[n2];
                        if (AnalysisManager.this.getAnalysisState(dsn, type) == 0 || AnalysisManager.this.getAnalysisState(dsn, type) == 5) {
                            AnalysisManager.this.setAnalysisState(dsn, type, 4);
                        }
                        ++n2;
                    }
                    nArray = analysisTypes;
                    n = analysisTypes.length;
                    n2 = 0;
                    while (n2 < n) {
                        type = nArray[n2];
                        MATTableModel model = AnalysisManager.this.getModel(dsn, "LogMessages", type);
                        if (model != null) {
                            model.addRow(new LogRowModel(model, messages));
                        }
                        ++n2;
                    }
                    if (showView) {
                        AnalysisManager.this.showAnalysisView(window, profile, dsn);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AnalysisManager.this.log.log(Level.WARNING, "Failed to process analysis data for " + dsn, e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void processAnalysis(String dsn, XMLRequest xml, String profile, int analysisType, boolean showView, MATServer server, StandbyDialog pleaseWaitDialog) {
        if (xml.getErrorLevel() == 0) {
            this.setAnalysisState(dsn, analysisType, 5);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            AnalysisPostprocessJob job = new AnalysisPostprocessJob(String.format("Process analysis results for %s", dsn), dsn, profile, analysisType, xml, window, showView, pleaseWaitDialog);
            job.schedule();
            return;
        }
    }

    public void showAnalysisView(final IWorkbenchWindow window, final String profile, final String dsn) {
        if (this.displayWeakRef.get() != null) {
            ((Display)this.displayWeakRef.get()).syncExec(new Runnable(){

                @Override
                public void run() {
                    Long time = new Date().getTime();
                    try {
                        String id = "com.ca.mat.views.analysistabbedview";
                        IViewPart part = window.getActivePage().showView(id, String.valueOf(profile) + "/" + dsn + "/" + time, 1);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)part);
                    }
                    catch (PartInitException e) {
                        AnalysisManager.this.log.log(Level.WARNING, "Failed to open Analysis View", e);
                    }
                }
            });
        }
    }

    public void storeLocalXMLFile(String profile, String dsn, int hash, InputStream is, String type) {
        block22: {
            IPath localXMLPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
            localXMLPath = localXMLPath.append("analysis");
            File f = localXMLPath.toFile();
            try {
                if (!f.exists()) {
                    f.mkdir();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Error creating directory for XML files", e);
            }
            if (profile != null) {
                localXMLPath = localXMLPath.append(profile);
                f = localXMLPath.toFile();
                try {
                    if (!f.exists()) {
                        f.mkdir();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Error creating directory for XML files", e);
                }
            }
            File[] fileArray = localXMLPath.toFile().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File oldFile = fileArray[n2];
                if (oldFile.getName().startsWith(String.valueOf(dsn.replace("'", "")) + "_" + type)) {
                    oldFile.delete();
                }
                ++n2;
            }
            String fileName = String.valueOf(dsn.replace("'", "")) + "_" + type + "." + hash + ".xml";
            localXMLPath = localXMLPath.append(fileName);
            f = localXMLPath.toFile();
            try {
                if (is == null) break block22;
                if (!f.exists()) {
                    f.createNewFile();
                }
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(f, false);
                        byte[] buffer = new byte[1024];
                        int read = 0;
                        while ((read = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, read);
                        }
                        fos.flush();
                        this.refreshLocalXMLViews();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.log(Level.SEVERE, "IO error storing analysis XML for " + dsn, e);
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getLocalXMLFile(String dsn, String profile, String analysisType) {
        IPath localXMLPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        localXMLPath = localXMLPath.append("analysis");
        if (profile != null) {
            localXMLPath = localXMLPath.append(profile);
        }
        if (localXMLPath.toFile().exists()) {
            File[] fileArray = localXMLPath.toFile().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().startsWith(String.valueOf(dsn.replace("'", "")) + "_" + analysisType)) {
                    return file;
                }
                if (!(file.getName().contains("_ACTIVE.") || file.getName().contains("_ALL.") || file.getName().contains("_NORMAL.") || file.getName().contains("_WAIT.") || !file.getName().startsWith(dsn.replace("'", "")))) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    public File[] getLocalXMLFiles(String dsn, String profile) {
        ArrayList<File> list = new ArrayList<File>();
        File f = this.getLocalXMLFile(dsn, profile, "ALL");
        if (f != null) {
            list.add(f);
        }
        if ((f = this.getLocalXMLFile(dsn, profile, "NORMAL")) != null) {
            list.add(f);
        }
        if ((f = this.getLocalXMLFile(dsn, profile, "ACTIVE")) != null) {
            list.add(f);
        }
        if ((f = this.getLocalXMLFile(dsn, profile, "WAIT")) != null) {
            list.add(f);
        }
        File[] result = new File[list.size()];
        list.toArray(result);
        return result;
    }

    public Integer getLocalXMLFileHash(String dsn, String profile, int analysisType) {
        String type = "";
        switch (analysisType) {
            case 1: {
                type = "ALL";
                break;
            }
            case 0: {
                type = "NORMAL";
                break;
            }
            case 2: {
                type = "ACTIVE";
                break;
            }
            case 3: {
                type = "WAIT";
            }
        }
        File file = this.getLocalXMLFile(dsn, profile, type);
        if (file != null) {
            String[] quals = file.getName().split("\\.");
            try {
                Integer hash = Integer.valueOf(quals[quals.length - 2]);
                return hash;
            }
            catch (NumberFormatException e) {
                this.log.log(Level.WARNING, "Hash for cached file " + file.getName() + " is invalid", e);
            }
        }
        return null;
    }

    public void deleteLocalXMLFiles(String dsn, String profile) {
        this.deleteLocalXMLFile(dsn, profile, "ALL");
        this.deleteLocalXMLFile(dsn, profile, "ACTIVE");
        this.deleteLocalXMLFile(dsn, profile, "NORMAL");
        this.deleteLocalXMLFile(dsn, profile, "WAIT");
    }

    private void deleteLocalXMLFile(String dsn, String profile, String analysisType) {
        IPath localXMLPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        localXMLPath = localXMLPath.append("analysis");
        if (profile != null) {
            localXMLPath = localXMLPath.append(profile);
        }
        if (localXMLPath.toFile().exists()) {
            File[] fileArray = localXMLPath.toFile().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().startsWith(String.valueOf(dsn.replace("'", "")) + "_" + analysisType)) {
                    file.delete();
                } else if (!(file.getName().contains("_ACTIVE.") || file.getName().contains("_ALL.") || file.getName().contains("_NORMAL.") || file.getName().contains("_WAIT.") || !file.getName().startsWith(dsn.replace("'", "")))) {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    public void removeAnalysis(String datasetName) {
        if (datasetName == null) {
            return;
        }
        Map map = cache.get(datasetName);
        if (map != null) {
            map.clear();
        }
        flags.remove(datasetName);
        Singletons.getListingManager((Display)this.displayWeakRef.get()).clearCache(datasetName);
        this.setAnalysisState(datasetName, 1, 0);
        this.setAnalysisState(datasetName, 0, 0);
        this.setAnalysisState(datasetName, 2, 0);
        this.setAnalysisState(datasetName, 3, 0);
        System.gc();
    }

    public void removeAnalysis(String datasetName, int analysisType) {
        if (datasetName == null) {
            return;
        }
        Map map = cache.get(datasetName);
        if (map != null) {
            for (MATTableModel[] value : map.values()) {
                value[analysisType] = null;
            }
        }
        this.setAnalysisState(datasetName, analysisType, 0);
        System.gc();
    }

    public void closeAnalysis(String datasetName) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = activeWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] references;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = references = page.getViewReferences();
            int n3 = references.length;
            int n4 = 0;
            while (n4 < n3) {
                AnalysisTabbedView view;
                IWorkbenchPart part;
                IViewReference viewRef = iViewReferenceArray[n4];
                String id = viewRef.getId();
                if (id.equals("com.ca.mat.views.analysistabbedview") && (part = viewRef.getPart(false)) instanceof AnalysisTabbedView && (view = (AnalysisTabbedView)part).getDSN() != null && view.getDSN().equals(datasetName)) {
                    try {
                        page.hideView(viewRef);
                    }
                    catch (Exception exception) {}
                }
                ++n4;
            }
            ++n2;
        }
    }
}

