/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.USSViewFunctionsRowModel;
import com.ca.mat.rowmodels.USSViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.USSViewPage;
import com.ca.mat.views.subpages.AbstractUSSSubpage;
import com.ca.mat.views.subpages.TextDisplayTableFormatSubpage;
import com.ca.mat.views.subpages.USSFunctionsSubpage;
import com.ca.mat.views.subpages.USSThreadsSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class USSViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        Display display = HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay();
        String processToDisplay = null;
        if (commandId.equals("com.ca.mat.commands.analysis.ussview.codedetails")) {
            String processFilter;
            USSViewPage.USSContextRestrictions currentContext;
            HashMap<String, Object[]> codeViewArgs = new HashMap<String, Object[]>();
            ArrayList<String[]> codeViewTitles = new ArrayList<String[]>();
            if (obj instanceof USSViewRowModel) {
                USSViewRowModel rowModel = (USSViewRowModel)obj;
                AbstractUSSSubpage parentPage = (AbstractUSSSubpage)page;
                currentContext = parentPage.getContextRestrictions();
                processToDisplay = rowModel.getProcessId();
                processFilter = this.toHex(processToDisplay, display);
                if (processFilter != null) {
                    codeViewArgs.put("majnm", new Object[]{processFilter});
                    codeViewTitles.add(new String[]{"Process ID", processToDisplay});
                }
                if (currentContext.getWaitType2() != null) {
                    codeViewArgs.put("ttype2", new Object[]{currentContext.getWaitType2()});
                }
            } else if (obj instanceof USSViewFunctionsRowModel) {
                USSViewFunctionsRowModel rowModel;
                AbstractUSSSubpage parentPage = (AbstractUSSSubpage)page;
                currentContext = parentPage.getContextRestrictions();
                if (parentPage instanceof USSThreadsSubpage) {
                    rowModel = (USSViewFunctionsRowModel)obj;
                    processToDisplay = currentContext.getProcessId();
                    processFilter = this.toHex(processToDisplay, display);
                    if (processFilter != null) {
                        codeViewArgs.put("majnm", new Object[]{processFilter});
                        codeViewTitles.add(new String[]{"Process ID", processToDisplay});
                    }
                    String threadId = rowModel.getThreadId();
                    String half1 = threadId.substring(0, 8);
                    String half2 = threadId.substring(8);
                    codeViewArgs.put("outddn", new Object[]{half1});
                    codeViewArgs.put("out4glan", new Object[]{half2});
                    if (currentContext.getWaitType2() != null) {
                        codeViewArgs.put("ttype2", new Object[]{currentContext.getWaitType2()});
                    }
                    codeViewTitles.add(new String[]{"Thread ID", threadId});
                } else if (parentPage instanceof USSFunctionsSubpage) {
                    rowModel = (USSViewFunctionsRowModel)obj;
                    String half1 = currentContext.getThreadIdHalf1();
                    String half2 = currentContext.getThreadIdHalf2();
                    processToDisplay = currentContext.getProcessId();
                    String processFilter2 = this.toHex(processToDisplay, display);
                    if (processToDisplay != null) {
                        codeViewArgs.put("majnm", new Object[]{processFilter2});
                        codeViewTitles.add(new String[]{"Process ID", processToDisplay});
                    }
                    if (half1 != null) {
                        codeViewArgs.put("outddn", new Object[]{half1});
                        codeViewArgs.put("out4glan", new Object[]{half2});
                        codeViewTitles.add(new String[]{"Thread ID", String.valueOf(half1) + half2});
                    }
                    if (currentContext.getWaitType2() != null) {
                        codeViewArgs.put("ttype2", new Object[]{currentContext.getWaitType2()});
                    }
                    Integer ttype1 = rowModel.getTType1();
                    Integer ttype2 = rowModel.getTType2();
                    codeViewArgs.put("ttype1", new Object[]{ttype1});
                    codeViewArgs.put("ttype2", new Object[]{ttype2});
                    codeViewTitles.add(new String[]{"Function", rowModel.getFunction()});
                }
            } else {
                throw new RuntimeException(String.format("Command %1$s invoked on unsupported class: %2$s", commandId, obj.getClass().toString()));
            }
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            model = model.filterBy(codeViewArgs);
            model = AnalysisUtils.calculateCodeView(model, dsn, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CodeViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.codedetail", model, true);
            String partName = "Code Details:";
            for (String[] entry : codeViewTitles) {
                partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
            }
            detachedView.setPresentationName(partName);
            AnalysisPage newPage = detachedView.getCurrentPage();
            if (newPage != null && newPage instanceof CodeViewPage) {
                CodeViewPage codeViewPage = (CodeViewPage)newPage;
                codeViewPage.setFilterExpressions(codeViewArgs);
                codeViewPage.setTitleExpressions(codeViewTitles);
            }
            if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                ((AnalysisPageCalculated)newPage).refreshHeader();
            }
            Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.ussview.delaydetails")) {
            String processFilter;
            USSViewPage.USSContextRestrictions currentContext;
            HashMap<String, Object[]> delayViewArgs = new HashMap<String, Object[]>();
            ArrayList<String[]> delayViewTitles = new ArrayList<String[]>();
            if (obj instanceof USSViewRowModel) {
                USSViewRowModel rowModel = (USSViewRowModel)obj;
                AbstractUSSSubpage parentPage = (AbstractUSSSubpage)page;
                currentContext = parentPage.getContextRestrictions();
                processToDisplay = rowModel.getProcessId();
                processFilter = this.toHex(processToDisplay, display);
                if (processFilter != null) {
                    delayViewArgs.put("majnm", new Object[]{processFilter});
                    delayViewTitles.add(new String[]{"Process ID", processToDisplay});
                }
                if (currentContext.getWaitType2() != null) {
                    delayViewArgs.put("ttype2", new Object[]{currentContext.getWaitType2()});
                }
            } else if (obj instanceof USSViewFunctionsRowModel) {
                USSViewFunctionsRowModel rowModel;
                AbstractUSSSubpage parentPage = (AbstractUSSSubpage)page;
                currentContext = parentPage.getContextRestrictions();
                if (parentPage instanceof USSThreadsSubpage) {
                    rowModel = (USSViewFunctionsRowModel)obj;
                    processToDisplay = currentContext.getProcessId();
                    processFilter = this.toHex(processToDisplay, display);
                    if (processFilter != null) {
                        delayViewArgs.put("majnm", new Object[]{processFilter});
                        delayViewTitles.add(new String[]{"Process ID", processToDisplay});
                    }
                    if (currentContext.getWaitType2() != null) {
                        delayViewArgs.put("ttype2", new Object[]{currentContext.getWaitType2()});
                    }
                    String threadId = rowModel.getThreadId();
                    String half1 = threadId.substring(0, 8);
                    String half2 = threadId.substring(8);
                    delayViewArgs.put("outddn", new Object[]{half1});
                    delayViewArgs.put("out4glan", new Object[]{half2});
                    delayViewTitles.add(new String[]{"Thread ID", threadId});
                } else if (parentPage instanceof USSFunctionsSubpage) {
                    rowModel = (USSViewFunctionsRowModel)obj;
                    String half1 = currentContext.getThreadIdHalf1();
                    String half2 = currentContext.getThreadIdHalf2();
                    processToDisplay = currentContext.getProcessId();
                    String processFilter3 = this.toHex(processToDisplay, display);
                    if (processToDisplay != null) {
                        delayViewArgs.put("majnm", new Object[]{processFilter3});
                        delayViewTitles.add(new String[]{"Process ID", processToDisplay});
                    }
                    if (half1 != null) {
                        delayViewArgs.put("outddn", new Object[]{half1});
                        delayViewArgs.put("out4glan", new Object[]{half2});
                        delayViewTitles.add(new String[]{"Thread ID", String.valueOf(half1) + half2});
                    }
                    if (currentContext.getWaitType2() != null) {
                        delayViewArgs.put("ttype2", new Object[]{currentContext.getWaitType2()});
                    }
                    Integer ttype1 = rowModel.getTType1();
                    Integer ttype2 = rowModel.getTType2();
                    delayViewArgs.put("ttype1", new Object[]{ttype1});
                    delayViewArgs.put("ttype2", new Object[]{ttype2});
                    delayViewTitles.add(new String[]{"Function", rowModel.getFunction()});
                }
            } else {
                throw new RuntimeException(String.format("Command %1$s invoked on unsupported class: %2$s", commandId, obj.getClass().toString()));
            }
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            model = model.filterBy(delayViewArgs);
            model = AnalysisUtils.calculateDelayView(model, dsn, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DelayViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.delaydetail", model);
            String partName = "Delay Detail:";
            for (String[] entry : delayViewTitles) {
                partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
            }
            detachedView.setPresentationName(partName);
            AnalysisPage newPage = detachedView.getCurrentPage();
            if (newPage != null && newPage instanceof DelayViewPage) {
                DelayViewPage delayViewPage = (DelayViewPage)newPage;
                delayViewPage.setFilterExpressions(delayViewArgs);
                delayViewPage.setTitleExpressions(delayViewTitles);
            }
            if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                ((AnalysisPageCalculated)newPage).refreshHeader();
            }
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.ussview.threads") && page instanceof USSViewPage) {
            USSViewPage.USSContextRestrictions currentContext = ((AbstractUSSSubpage)page).getContextRestrictions();
            String displayMode = "display_mode_thread";
            String groupingKey = "group_by_thread";
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            String section = "USSView Functions";
            if (!(obj instanceof USSViewRowModel)) {
                throw new RuntimeException(String.format("Command %1$s invoked on unsupported class: %2$s", commandId, obj.getClass().toString()));
            }
            USSViewRowModel rowModel = (USSViewRowModel)obj;
            processToDisplay = rowModel.getProcessId();
            currentContext.setProcessId(processToDisplay);
            arguments.put("procesid", new Object[]{processToDisplay});
            if (currentContext.getWaitType2() != null) {
                arguments.put("twaittp2", new Object[]{currentContext.getWaitType2()});
            }
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
            model = model.filterBy(arguments);
            model = AnalysisUtils.aggregateUSS(model, groupingKey, displayMode, dsn);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(USSThreadsSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.ussthreads", model, true);
            detachedView.setPresentationName(String.format("USS Threads: Process ID: %s", processToDisplay));
            ((AbstractUSSSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
            ((AbstractUSSSubpage)detachedView.getCurrentPage()).refreshHeader();
            Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.ussview.ussfunctions")) {
            MATTableRow rowModel;
            USSViewPage.USSContextRestrictions currentContext;
            String displayMode = "display_mode_function";
            String groupingKey = "group_by_function";
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            String section = "USSView Functions";
            if (obj instanceof USSViewRowModel) {
                currentContext = ((AbstractUSSSubpage)page).getContextRestrictions();
                rowModel = (USSViewRowModel)obj;
                processToDisplay = ((USSViewRowModel)rowModel).getProcessId();
                currentContext.setProcessId(processToDisplay);
            } else if (obj instanceof USSViewFunctionsRowModel) {
                currentContext = ((AbstractUSSSubpage)page).getContextRestrictions();
                processToDisplay = currentContext.getProcessId();
                rowModel = (USSViewFunctionsRowModel)obj;
                String threadId = ((USSViewFunctionsRowModel)rowModel).getThreadId();
                arguments.put("threadid", new Object[]{threadId});
                String half1 = threadId.substring(0, 8);
                String half2 = threadId.substring(8);
                currentContext.setThreadIdHalf1(half1);
                currentContext.setThreadIdHalf2(half2);
            } else {
                throw new RuntimeException(String.format("Command %1$s invoked on unsupported class: %2$s", commandId, obj.getClass().toString()));
            }
            arguments.put("procesid", new Object[]{processToDisplay});
            if (currentContext.getWaitType2() != null) {
                arguments.put("twaittp2", new Object[]{currentContext.getWaitType2()});
            }
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
            model = model.filterBy(arguments);
            model = AnalysisUtils.aggregateUSS(model, groupingKey, displayMode, dsn);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(USSFunctionsSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.ussfunctions", model, true);
            detachedView.setPresentationName(String.format("USS Functions: Process ID: %s", processToDisplay));
            ((AbstractUSSSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
            ((AbstractUSSSubpage)detachedView.getCurrentPage()).refreshHeader();
            Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.ussview.ussprocessinfo")) {
            String processId;
            if (obj instanceof USSViewRowModel) {
                processId = ((USSViewRowModel)obj).getProcessId();
            } else if (page instanceof AbstractUSSSubpage) {
                USSViewPage.USSContextRestrictions currentContext = ((AbstractUSSSubpage)page).getContextRestrictions();
                processId = currentContext.getProcessId();
            } else {
                return null;
            }
            String section = "USSView Process " + processId.trim();
            MATTableModel result = Singletons.getAnalysisManager().getModel(dsn, section, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "Process Information ", dsn, type, presentation, "com.ca.mat.help.processinfo", result);
            detachedView.setPresentationName(String.format("Process Information: Process ID %s", processId));
        }
        return null;
    }

    private String toHex(String processToDisplay, Display display) {
        Long formatInput = null;
        try {
            formatInput = Long.valueOf(processToDisplay.trim());
            return String.format("%08X", formatInput);
        }
        catch (Exception exception) {
            Logger log = Logging.getLogger(display);
            log.log(Level.WARNING, String.format("IllegalFormatException for processId, using literal value for filter", "Class: " + formatInput.getClass(), "Value: " + formatInput));
            return processToDisplay;
        }
    }
}

