/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.ProgramViewPage;
import com.ca.mat.views.subpages.HistogramSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class ProgramViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (obj instanceof CodeViewRowModel && page instanceof ProgramViewPage) {
            CodeViewRowModel rowModel = (CodeViewRowModel)obj;
            ProgramViewPage programPage = (ProgramViewPage)page;
            if (commandId.equals("com.ca.mat.commands.analysis.programview.addtolist") && rowModel.getCSECT() != null && !rowModel.getCSECT().trim().isEmpty()) {
                programPage.addCsectToList(rowModel.getCSECT());
            }
            if (commandId.equals("com.ca.mat.commands.analysis.programview.histogram")) {
                HashMap<String, Object[]> histogramArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> histogramTitles = new ArrayList<String[]>();
                histogramArgs.put("Module", new Object[]{rowModel.getModule()});
                histogramArgs.put("Csect", new Object[]{rowModel.getCSECT()});
                histogramTitles.add(new String[]{"Module", rowModel.getModule()});
                histogramTitles.add(new String[]{"Csect", rowModel.getCSECT()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = AnalysisUtils.callerIdSwap(model, programPage.getDispatcherModules(), programPage.getDispatcherCsects(), dsn, false);
                model = model.filterBy(histogramArgs);
                MATTableModel statementModel = null;
                if (AnalysisUtils.csectHasStatements(dsn, rowModel.getCSECT())) {
                    statementModel = AnalysisUtils.calculateHistogramStatement(model, rowModel.getModule(), rowModel.getCSECT(), dsn, type, Display.getCurrent());
                }
                model = AnalysisUtils.calculateHistogramBase(model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(HistogramSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.histogram", model);
                String partName = "Program View Histogram:";
                for (String[] entry : histogramTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof HistogramSubpage) {
                    HistogramSubpage histogramPage = (HistogramSubpage)newPage;
                    histogramPage.setGroupSize(32);
                    histogramPage.setTotalDelay(rowModel.getTotal());
                    if (statementModel != null) {
                        histogramPage.setStatementModel(statementModel);
                        histogramPage.setMode(2);
                    } else {
                        histogramPage.setMode(1);
                    }
                }
            }
        }
        return null;
    }
}

