/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.PoolDetailRowModel;
import com.ca.mat.rowmodels.PoolViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.subpages.PoolDatasetSubpage;
import com.ca.mat.views.subpages.PoolDetailSubpage;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class PoolViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MATTableRow rowModel;
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        if (obj instanceof PoolViewRowModel) {
            rowModel = (PoolViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.poolview.pooldetails")) {
                String section = "BufferPoolDetails";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("poolgrp", new Object[]{((PoolViewRowModel)rowModel).getGroup()});
                arguments.put("pooltype", new Object[]{((PoolViewRowModel)rowModel).getType()});
                if (model != null) {
                    model = model.filterBy(arguments);
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(PoolDetailSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.pooldetail", model);
                detachedView.setPresentationName("Shared Pools");
                ((PoolDetailSubpage)detachedView.getCurrentPage()).setHeaderText(rowModel);
                return null;
            }
        }
        if (obj instanceof PoolDetailRowModel) {
            rowModel = (PoolDetailRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.poolview.pooldatasets")) {
                String section = "BufferPoolDSN";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("poolkey", new Object[]{((PoolDetailRowModel)rowModel).getPoolKey()});
                if (model != null) {
                    model = model.filterBy(arguments);
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(PoolDatasetSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.pooldataset", model);
                detachedView.setPresentationName("Pooled Data Sets");
                ((PoolDatasetSubpage)detachedView.getCurrentPage()).setHeaderText(rowModel);
                return null;
            }
        }
        return null;
    }
}

