/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IDMSViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.IDMSPage;
import com.ca.mat.views.pages.PageWithModesContainer;
import com.ca.mat.views.subpages.IDMSDMLDelaysSubpage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class IDMSViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (commandId.equals("com.ca.mat.commands.analysis.idmsview.idmsdmldelays")) {
            String location = "IDMS DML Delays";
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, location, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IDMSDMLDelaysSubpage.class, location, dsn, type, presentation, "com.ca.mat.help.idmsdmldelays", model);
            detachedView.setPresentationName("IDMS DML Delays");
            return null;
        }
        if (page instanceof IDMSPage) {
            if (commandId.equals("com.ca.mat.commands.analysis.mode.idmsview.task")) {
                this.changeIDMSViewMode(presentation, IDMSViewRowModel.TYPE_TASK, (IDMSPage)page);
                boolean compare = Singletons.getCompareManager().getCompare();
                if (compare) {
                    Singletons.getCompareManager().modeChanged(IDMSViewRowModel.TYPE_TASK);
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.mode.idmsview.module")) {
                this.changeIDMSViewMode(presentation, IDMSViewRowModel.TYPE_MODULE, (IDMSPage)page);
                boolean compare = Singletons.getCompareManager().getCompare();
                if (compare) {
                    Singletons.getCompareManager().modeChanged(IDMSViewRowModel.TYPE_MODULE);
                }
                return null;
            }
        }
        return null;
    }

    private void changeIDMSViewMode(IAnalysisPagePresentation presentation, String newMode, IDMSPage page) {
        AnalysisTabbedView tabView;
        PageWithModesContainer pageContainer = page.changeMode(newMode);
        presentation.addPage(pageContainer.getAnalysisPage(), true);
        ((IDMSPage)pageContainer.getAnalysisPage()).setModel(pageContainer.getModel());
        presentation.showPage(pageContainer.getAnalysisPage());
        if (presentation instanceof AnalysisTabbedView && !page.equals((tabView = (AnalysisTabbedView)presentation).getPage("IDMS"))) {
            page.dispose();
        }
        Singletons.getAnalysisManager().analysisPageFocused(pageContainer.getAnalysisPage());
    }
}

