/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.MATException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.dialogs.DefineScheduleDialog;
import com.ca.mat.handlers.RefreshHandler;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.tuntables.ScheduleRowModel;
import com.ca.mat.views.MonitorSchedulesView;
import com.ca.mat.views.MonitorTreeView;
import com.ca.mat.xml.XMLRequest;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ScheduleHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        String commandId = event.getCommand().getId();
        if (commandId.equals("com.ca.mat.commands.schedule.define")) {
            this.openDefineOrEditScheduleDialog(event, 0);
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.schedule.edit")) {
            this.openDefineOrEditScheduleDialog(event, 1);
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.schedule.copy")) {
            this.openDefineOrEditScheduleDialog(event, 2);
            return null;
        }
        if (part instanceof MonitorSchedulesView) {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            for (Object item : selection) {
                boolean reply;
                if (!(item instanceof ScheduleRowModel)) continue;
                ScheduleRowModel schedule = (ScheduleRowModel)item;
                String scheduleName = schedule.getName();
                ServerProxy serverProxy = Singletons.getServerProxy(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
                if (!commandId.equals("com.ca.mat.commands.schedule.delete") || !(reply = MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Delete Monitor Schedule", (String)("Are you sure you want to delete the schedule: " + scheduleName + " ?")))) continue;
                serverProxy.deleteSchedule(scheduleName, true, reply);
                new ServerCallback(){

                    @Override
                    public void processReply(XMLRequest reply, MATServer server) {
                        RefreshHandler refresh = new RefreshHandler();
                        refresh.refreshServers(server.getDisplay());
                    }

                    @Override
                    public void cancel(XMLRequest reply, MATServer server) {
                    }

                    @Override
                    public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                        return false;
                    }
                };
                RefreshHandler refresh = new RefreshHandler();
                refresh.refreshServers(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
            }
        } else {
            boolean cfr_ignored_0 = part instanceof MonitorTreeView;
        }
        return null;
    }

    private void openDefineOrEditScheduleDialog(ExecutionEvent event, int mode) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DefineScheduleDialog dialog = null;
        if (!(mode != 1 && mode != 2 || selection.isEmpty())) {
            ScheduleRowModel schedule = (ScheduleRowModel)selection.getFirstElement();
            dialog = new DefineScheduleDialog(shell, schedule, mode);
        }
        if (mode == 0) {
            dialog = new DefineScheduleDialog(shell, null, mode);
        }
        if (dialog != null) {
            dialog.create();
            dialog.open();
        }
    }
}

