/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableFilter;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.utils.TextUtil;
import com.ca.mat.utils.VerifytoUpperCase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class FilterDialog
extends TestingToolsDialog
implements Listener {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String DATACOL = "datacol";
    private IMATTableViewer viewer;
    private List<Text> textFields = new ArrayList<Text>();
    private Text quickFilterText;
    int index;
    Logger log;
    Level baseLevel;
    private ViewerFilter[] filters;
    private String title;
    private VerifytoUpperCase verify;
    private boolean update;
    private List<Integer> visibleColumnOrder;

    public FilterDialog(Shell parent, IMATTableViewer viewer) {
        super(parent);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.filterdialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.title = "Configure Filter";
        this.verify = new VerifytoUpperCase();
        this.update = true;
        this.viewer = viewer;
    }

    public FilterDialog(IShellProvider parentShell) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.filterdialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.title = "Configure Filter";
        this.verify = new VerifytoUpperCase();
        this.update = true;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Text selectedField = null;
        int[] currentOrder = this.viewer.getColumnOrder();
        this.visibleColumnOrder = this.viewer.getVisibleSortedColumnList();
        int columnCount = this.viewer.getColumnCount();
        ArrayList<Character> mnemonics = new ArrayList<Character>(columnCount);
        int width = 1;
        if (columnCount > 30) {
            width = (columnCount + 14) / 15;
        } else if (columnCount > 10) {
            width = (columnCount + 9) / 10;
        }
        int height = columnCount / width;
        if (height * width < columnCount) {
            ++height;
        }
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Group group = new Group(superComposite, 16);
        group.setLayout((Layout)new GridLayout(width * 2, false));
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                int ix = row + col * height;
                if (ix < columnCount) {
                    MATTableFilter filter;
                    GridData gData = new GridData(4, 0, true, false);
                    group.setLayoutData((Object)gData);
                    String name = this.viewer.getColumnName(currentOrder[ix]).trim();
                    name = name.isEmpty() ? "* No Label *" : this.setMnemonic(mnemonics, name);
                    Label label = new Label((Composite)group, 0);
                    label.setText(name);
                    gData = new GridData(3);
                    if (col != 0) {
                        gData.horizontalIndent = 20;
                    }
                    label.setLayoutData((Object)gData);
                    Text textField = new Text((Composite)group, 2048);
                    textField.setData(DATACOL, (Object)currentOrder[ix]);
                    textField.addListener(24, (Listener)this);
                    if (selectedField == null) {
                        selectedField = textField;
                    }
                    if ((filter = this.getFilter(currentOrder[ix])) != null) {
                        textField.setText(filter.getText());
                    }
                    gData = new GridData(4, 0, true, false);
                    gData.minimumWidth = TextUtil.calculateWidth((Control)textField, 15);
                    textField.setLayoutData((Object)gData);
                    textField.setTextLimit(255);
                    if (!this.viewer.getColumnVisibile(currentOrder[ix])) {
                        label.setEnabled(false);
                        textField.setEnabled(false);
                    }
                    this.textFields.add(textField);
                } else {
                    Label filler = new Label((Composite)group, 0);
                    filler.setText("");
                    Label filler2 = new Label((Composite)group, 0);
                    filler2.setText("");
                }
                ++col;
            }
            ++row;
        }
        if (selectedField != null) {
            selectedField.setFocus();
        }
        this.getShell().addListener(22, (Listener)this);
        return superComposite;
    }

    private String setMnemonic(ArrayList<Character> mnemonics, String name) {
        if (name.isEmpty()) {
            return name;
        }
        name = name.replace("&", "&&");
        StringBuilder string = new StringBuilder(name);
        int ix = 0;
        while (ix < string.length()) {
            int found;
            char item = string.charAt(ix);
            if (item != '&' && (found = mnemonics.indexOf(Character.valueOf(item))) == -1) {
                mnemonics.add(Character.valueOf(item));
                string.insert(ix, "&");
                return string.toString();
            }
            ++ix;
        }
        return name;
    }

    private MATTableFilter getFilter(int ix) {
        if (this.filters == null) {
            this.filters = this.viewer.getFilters();
        }
        ArrayList<Integer> filteredColumnsForOneField = new ArrayList<Integer>();
        filteredColumnsForOneField.add(ix);
        ViewerFilter[] viewerFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableFilter filter;
            ViewerFilter item = viewerFilterArray[n2];
            if (item instanceof MATTableFilter && (filter = (MATTableFilter)item).isFilteredBySameColumns(filteredColumnsForOneField) && !filter.isInternal()) {
                return (MATTableFilter)item;
            }
            ++n2;
        }
        return null;
    }

    private MATTableFilter getQuickFilter() {
        if (this.filters == null) {
            this.filters = this.viewer.getFilters();
        }
        ViewerFilter[] viewerFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableFilter filter;
            ViewerFilter item = viewerFilterArray[n2];
            if (item instanceof MATTableFilter && (filter = (MATTableFilter)item).isQuickFilter()) {
                return filter;
            }
            ++n2;
        }
        return null;
    }

    protected void okPressed() {
        this.viewer.removeAllFilters();
        for (Text textField : this.textFields) {
            if (textField.getText().isEmpty()) continue;
            textField.setText(textField.getText().toUpperCase());
            ArrayList<Integer> filteredColumns = new ArrayList<Integer>();
            filteredColumns.add((Integer)textField.getData(DATACOL));
            MATTableFilter filter = this.viewer.addColumnFilter(filteredColumns, textField.getText(), false, false);
            if (filter == null || filter.isValid()) continue;
            this.viewer.removeFilter(filter);
            if (filter.getoperatorType() == 0) continue;
            return;
        }
        this.close();
    }

    @Override
    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format("%s", this.title));
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    public void handleEvent(Event event) {
        if (event.type == 22) {
            Button ok = this.getButton(0);
            ok.setEnabled(false);
            this.getShell().setDefaultButton(ok);
        } else if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }
}

