/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.handlers.RefreshHandler;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.tuntables.ScheduleRowModel;
import com.ca.mat.utils.TextUtil;
import com.ca.mat.xml.XMLRequest;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class DefineScheduleDialog
extends TestingToolsDialog
implements ModifyListener,
SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2012 CA";
    public static final int MODE_NEW = 0;
    public static final int MODE_EDIT = 1;
    public static final int MODE_COPY = 2;
    private static final Pattern memberPattern = Pattern.compile("^[A-Z$#@][0-9A-Z#@]*");
    private static final Pattern jobPattern = Pattern.compile("^[0-9A-Z#@*%$?]+");
    private static final Pattern durationPattern = Pattern.compile("^[0]*[1-9][0-9]*[SM]$");
    private String title;
    private boolean editMode = false;
    private boolean copyMode = false;
    private boolean valid;
    private boolean changed;
    private boolean modifyingFields = false;
    private List<String> errorMessages = new ArrayList<String>();
    private ScheduleRowModel scheduleRow;
    private Composite parentComposite;
    private Composite superComposite;
    Control debug;
    private Spinner daysField;
    private Text nameField;
    private Text descriptionField;
    private Text startDateField;
    private Text endDateField;
    private Button fullWeekField;
    private Button weekDaysField;
    private Button weekEndsField;
    private Button weekSpecificField;
    private Button weekMondayField;
    private Button weekTuesdayField;
    private Button weekWednesdayField;
    private Button weekThursdayField;
    private Button weekFridayField;
    private Button weekSaturdayField;
    private Button weekSundayField;
    private Button time1Field;
    private Button time2Field;
    private Button time3Field;
    private Button time4Field;
    private Text startTime1HoursField;
    private Text startTime1MinutesField;
    private Text endTime1HoursField;
    private Text endTime1MinutesField;
    private Text startTime2HoursField;
    private Text startTime2MinutesField;
    private Text endTime2HoursField;
    private Text endTime2MinutesField;
    private Text startTime3HoursField;
    private Text startTime3MinutesField;
    private Text endTime3HoursField;
    private Text endTime3MinutesField;
    private Text startTime4HoursField;
    private Text startTime4MinutesField;
    private Text endTime4HoursField;
    private Text endTime4MinutesField;
    private DateTime calendarStart;
    private DateTime calendarEnd;

    public DefineScheduleDialog(Shell parent) {
        this(parent, ScheduleRowModel.getDefaultSchedule(parent.getDisplay()), 0);
    }

    public DefineScheduleDialog(Shell parent, ScheduleRowModel row, int mode) {
        super(parent);
        this.scheduleRow = row;
        switch (mode) {
            case 0: {
                this.scheduleRow = ScheduleRowModel.getDefaultSchedule(Display.getCurrent());
                this.title = "Add Schedule";
                this.editMode = false;
                this.copyMode = false;
                break;
            }
            case 1: {
                this.title = "Edit Schedule";
                this.editMode = true;
                this.copyMode = false;
                break;
            }
            case 2: {
                this.title = "Copy Schedule";
                this.editMode = false;
                this.copyMode = true;
            }
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.parentComposite = parent;
        this.superComposite = (Composite)super.createDialogArea(parent);
        this.superComposite.setLayout((Layout)new GridLayout(3, false));
        Composite headerGroup = this.createComposite(this.superComposite, true, 3, false, false);
        Label nameLabel = this.createLabel(headerGroup, "Name", (Control)headerGroup, 10, (Control)headerGroup, 20, 8, null, "left");
        this.nameField = this.createField(headerGroup, "", (Control)nameLabel, 10, null, 20, 8, 8);
        if (this.editMode) {
            this.nameField.setText(this.scheduleRow.getName());
        } else {
            this.nameField.setText("");
        }
        this.nameField.setEnabled(!this.editMode);
        Label descriptionLabel = this.createLabel(headerGroup, "Description", (Control)headerGroup, 10, (Control)nameLabel, 20, 8, null, "left");
        this.descriptionField = this.createField(headerGroup, this.scheduleRow.getDescription(), (Control)descriptionLabel, 10, null, 20, 24, 24);
        this.createSeparator(headerGroup, "", (Control)headerGroup, 10, (Control)descriptionLabel, 10);
        Composite dateGroup1 = this.createComposite(this.superComposite, true, 1, true, false);
        Label dateRangeLabel = this.createLabel(dateGroup1, "Date range: ", (Control)dateGroup1, 10, (Control)dateGroup1, 20, 7, null, "left");
        Label startDateLabel = this.createLabel(dateGroup1, "Starting on", (Control)dateGroup1, 10, (Control)dateRangeLabel, 20, 7, null, "left");
        this.startDateField = this.createField(dateGroup1, "", (Control)startDateLabel, 19, null, 20, 8, 10);
        this.createLabel(dateGroup1, "at 12:00 AM", (Control)this.startDateField, 10, null, 20, 10, null, "left");
        this.calendarStart = this.createCalendar(dateGroup1, "", null, 10, (Control)startDateLabel, 20, (Control)startDateLabel);
        this.createSeparator(dateGroup1, "", (Control)dateGroup1, 10, (Control)this.calendarStart, 0);
        Composite dateGroup2 = this.createComposite(this.superComposite, true, 2, true, false);
        Label separator1 = this.createSeparator(dateGroup2, "", (Control)dateGroup2, 10, (Control)dateGroup2, 20);
        Label endDateLabel = this.createLabel(dateGroup2, "Ending on", (Control)dateGroup2, 10, (Control)separator1, 20, 7, null, "left");
        this.endDateField = this.createField(dateGroup2, "", (Control)endDateLabel, 19, null, 20, 8, 10);
        Label endDateLabelTime = this.createLabel(dateGroup2, "at 12:00 AM", (Control)this.endDateField, 10, null, 20, 10, null, "left");
        this.calendarEnd = this.createCalendar(dateGroup2, this.scheduleRow.getEndDate(), null, 10, (Control)endDateLabel, 20, (Control)endDateLabel);
        Label separator2 = this.createSeparator(dateGroup2, " ", (Control)endDateLabelTime, 20, (Control)endDateLabelTime, 0);
        Label daysLabel2a = this.createLabel(dateGroup2, "Monitor request valid for:", (Control)endDateLabelTime, 15, (Control)separator2, 10, 20, null, "Left");
        this.daysField = this.createSpinner(dateGroup2, 0, null, 10, (Control)daysLabel2a, 20, 0, 999, 1, 3, (Control)daysLabel2a);
        this.createLabel(dateGroup2, "day(s)", (Control)this.daysField, 10, null, 20, 4, null, "left");
        this.startDateField.setText(this.scheduleRow.getStartDate());
        Integer[] startDateIntegers = this.parseDateStringToIntegers(this.scheduleRow.getStartDate());
        this.calendarStart.setDate(startDateIntegers[0].intValue(), startDateIntegers[1] - 1, startDateIntegers[2].intValue());
        if (this.scheduleRow.getEndDate().equals("")) {
            this.daysField.setSelection(this.scheduleRow.getDays());
            this.endDateField.setText(this.calculateEndDate(this.scheduleRow.getStartDate(), this.scheduleRow.getDays()));
        } else {
            this.endDateField.setText(this.scheduleRow.getEndDate());
            this.daysField.setSelection(this.calculateDays(this.scheduleRow.getStartDate(), this.scheduleRow.getEndDate()).intValue());
        }
        Integer[] endDateIntegers = this.parseDateStringToIntegers(this.endDateField.getText());
        this.calendarEnd.setDate(endDateIntegers[0].intValue(), endDateIntegers[1] - 1, endDateIntegers[2].intValue());
        this.startDateField.addModifyListener((ModifyListener)this);
        this.calendarStart.addSelectionListener((SelectionListener)this);
        this.endDateField.addModifyListener((ModifyListener)this);
        this.calendarEnd.addSelectionListener((SelectionListener)this);
        this.daysField.addModifyListener((ModifyListener)this);
        Composite timeGroup = this.createComposite(this.superComposite, true, 1, false, false);
        Label timeGroupTitle = this.createLabel(timeGroup, "Time ranges (hh:mm 24 hour clock): ", (Control)timeGroup, 10, (Control)timeGroup, 20, 26, null, "left");
        Label timeStartLabel = this.createLabel(timeGroup, "Start time", (Control)timeGroup, 40, (Control)timeGroupTitle, 20, 8, null, "left");
        Label timeEndLabel = this.createLabel(timeGroup, "End time", (Control)timeStartLabel, 30, null, 20, 14, null, "left");
        this.startTime1HoursField = this.createField(timeGroup, this.scheduleRow.getStartTimeHours1(), null, 10, (Control)timeStartLabel, 20, 2, 2, (Control)timeStartLabel);
        Label startTime1Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.startTime1HoursField, null, 1, null, "center");
        this.startTime1MinutesField = this.createField(timeGroup, this.scheduleRow.getStartTimeMins1(), (Control)startTime1Sep, 1, null, 20, 2, 2);
        this.endTime1HoursField = this.createField(timeGroup, this.scheduleRow.getEndTimeHours1(), null, 10, (Control)timeEndLabel, 20, 2, 2, (Control)timeEndLabel);
        Label endTime1Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.endTime1HoursField, null, 1, null, "center");
        this.endTime1MinutesField = this.createField(timeGroup, this.scheduleRow.getEndTimeMins1(), (Control)endTime1Sep, 1, null, 20, 2, 2);
        this.createPreceedingLabel(timeGroup, "1", (Control)timeGroup, 10, (Control)this.startTime1HoursField, 0, "left");
        this.startTime2HoursField = this.createField(timeGroup, this.scheduleRow.getStartTimeHours2(), null, 10, (Control)this.startTime1HoursField, 10, 2, 2, (Control)this.startTime1HoursField);
        Label startTime2Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.startTime2HoursField, null, 1, null, "center");
        this.startTime2MinutesField = this.createField(timeGroup, this.scheduleRow.getStartTimeMins2(), (Control)startTime2Sep, 1, null, 10, 2, 2);
        this.endTime2HoursField = this.createField(timeGroup, this.scheduleRow.getEndTimeHours2(), null, 10, (Control)this.endTime1HoursField, 10, 2, 2, (Control)this.endTime1HoursField);
        Label endTime2Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.endTime2HoursField, null, 1, null, "center");
        this.endTime2MinutesField = this.createField(timeGroup, this.scheduleRow.getEndTimeMins2(), (Control)endTime2Sep, 1, null, 10, 2, 2);
        this.createPreceedingLabel(timeGroup, "2", (Control)timeGroup, 10, (Control)this.startTime2HoursField, 0, "left");
        this.startTime3HoursField = this.createField(timeGroup, this.scheduleRow.getStartTimeHours3(), null, 10, (Control)this.startTime2HoursField, 10, 2, 2, (Control)this.startTime2HoursField);
        Label startTime3Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.startTime3HoursField, null, 1, null, "center");
        this.startTime3MinutesField = this.createField(timeGroup, this.scheduleRow.getStartTimeMins3(), (Control)startTime3Sep, 1, null, 10, 2, 2);
        this.endTime3HoursField = this.createField(timeGroup, this.scheduleRow.getEndTimeHours3(), null, 10, (Control)this.endTime2HoursField, 10, 2, 2, (Control)this.endTime2HoursField);
        Label endTime3Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.endTime3HoursField, null, 1, null, "center");
        this.endTime3MinutesField = this.createField(timeGroup, this.scheduleRow.getEndTimeMins3(), (Control)endTime3Sep, 1, null, 10, 2, 2);
        this.createPreceedingLabel(timeGroup, "3", (Control)timeGroup, 10, (Control)this.startTime3HoursField, 0, "left");
        this.startTime4HoursField = this.createField(timeGroup, this.scheduleRow.getStartTimeHours4(), null, 10, (Control)this.startTime3HoursField, 10, 2, 2, (Control)this.startTime3HoursField);
        Label startTime4Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.startTime4HoursField, null, 1, null, "center");
        this.startTime4MinutesField = this.createField(timeGroup, this.scheduleRow.getStartTimeMins4(), (Control)startTime4Sep, 1, null, 10, 2, 2);
        this.endTime4HoursField = this.createField(timeGroup, this.scheduleRow.getEndTimeHours4(), null, 10, (Control)this.endTime3HoursField, 10, 2, 2, (Control)this.endTime3HoursField);
        Label endTime4Sep = this.createNarrowLabel(timeGroup, ":", (Control)this.endTime4HoursField, null, 1, null, "center");
        this.endTime4MinutesField = this.createField(timeGroup, this.scheduleRow.getEndTimeMins4(), (Control)endTime4Sep, 1, null, 10, 2, 2);
        Label timeNumber4 = this.createPreceedingLabel(timeGroup, "4", (Control)timeGroup, 10, (Control)this.startTime4HoursField, 0, "left");
        this.createSeparator(timeGroup, " ", (Control)timeGroup, 10, (Control)timeNumber4, 0);
        Composite daysGroup = this.createComposite(this.superComposite, true, 2, false, false);
        Label daysGroupTitle = this.createLabel(daysGroup, "Day of week settings: ", (Control)daysGroup, 10, (Control)daysGroup, 20, 20, null, "left");
        this.fullWeekField = this.createRadioButton(daysGroup, " Full week (Sun-Sat)", this.scheduleRow.isFullWeek(), (Control)daysGroup, 10, (Control)daysGroupTitle, 16, 24);
        this.weekDaysField = this.createRadioButton(daysGroup, " Weekdays only", this.scheduleRow.isWeekDays(), (Control)daysGroup, 10, (Control)this.fullWeekField, 8, 24);
        this.weekEndsField = this.createRadioButton(daysGroup, " Weekends only", this.scheduleRow.isWeekEnds(), (Control)daysGroup, 10, (Control)this.weekDaysField, 8, 24);
        this.weekSpecificField = this.createRadioButton(daysGroup, " Specific days...", this.scheduleRow.isWeekSpecific(), (Control)daysGroup, 9, (Control)this.weekEndsField, 8, 24);
        this.createSeparator(daysGroup, "", (Control)daysGroup, 10, (Control)this.weekSpecificField, 4);
        SelectionListener radioSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                boolean specificDaysSelected = DefineScheduleDialog.this.weekSpecificField.getSelection();
                if (specificDaysSelected) {
                    DefineScheduleDialog.this.weekMondayField.setEnabled(true);
                    DefineScheduleDialog.this.weekTuesdayField.setEnabled(true);
                    DefineScheduleDialog.this.weekWednesdayField.setEnabled(true);
                    DefineScheduleDialog.this.weekThursdayField.setEnabled(true);
                    DefineScheduleDialog.this.weekFridayField.setEnabled(true);
                    DefineScheduleDialog.this.weekSaturdayField.setEnabled(true);
                    DefineScheduleDialog.this.weekSundayField.setEnabled(true);
                } else {
                    DefineScheduleDialog.this.weekMondayField.setEnabled(false);
                    DefineScheduleDialog.this.weekTuesdayField.setEnabled(false);
                    DefineScheduleDialog.this.weekWednesdayField.setEnabled(false);
                    DefineScheduleDialog.this.weekThursdayField.setEnabled(false);
                    DefineScheduleDialog.this.weekFridayField.setEnabled(false);
                    DefineScheduleDialog.this.weekSaturdayField.setEnabled(false);
                    DefineScheduleDialog.this.weekSundayField.setEnabled(false);
                }
            }
        };
        this.fullWeekField.addSelectionListener(radioSelectionListener);
        this.weekDaysField.addSelectionListener(radioSelectionListener);
        this.weekEndsField.addSelectionListener(radioSelectionListener);
        this.weekSpecificField.addSelectionListener(radioSelectionListener);
        this.weekMondayField = this.createCheckbox(daysGroup, "Monday", this.scheduleRow.isWeekMonday(), (Control)this.fullWeekField, 10, null, 16, 16);
        this.weekTuesdayField = this.createCheckbox(daysGroup, "Tuesday", this.scheduleRow.isWeekTuesday(), (Control)this.weekDaysField, 10, (Control)this.weekMondayField, 8, 16);
        this.weekWednesdayField = this.createCheckbox(daysGroup, "Wednesday", this.scheduleRow.isWeekWednesday(), (Control)this.weekEndsField, 10, (Control)this.weekTuesdayField, 8, 16);
        this.weekThursdayField = this.createCheckbox(daysGroup, "Thursday", this.scheduleRow.isWeekThursday(), (Control)this.weekSpecificField, 10, (Control)this.weekWednesdayField, 8, 16);
        this.weekFridayField = this.createCheckbox(daysGroup, "Friday", this.scheduleRow.isWeekFriday(), (Control)this.weekMondayField, 10, null, 16, 12);
        this.weekSaturdayField = this.createCheckbox(daysGroup, "Saturday", this.scheduleRow.isWeekSaturday(), (Control)this.weekTuesdayField, 10, (Control)this.weekFridayField, 8, 12);
        this.weekSundayField = this.createCheckbox(daysGroup, "Sunday", this.scheduleRow.isWeekSunday(), (Control)this.weekWednesdayField, 10, (Control)this.weekSaturdayField, 8, 12);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.monitorschedulefields";
        if (!this.CONTEXT_HELP_ID.isEmpty()) {
            if (Activator.plugin.hasEclipseFragment()) {
                this.setHelpAvailable(true);
            } else {
                Composite helpBar = this.createHelpToolbar(headerGroup);
                FormData fData = new FormData();
                fData.right = new FormAttachment(1, 1, 0);
                helpBar.setLayoutData((Object)fData);
                headerGroup.layout();
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.superComposite, this.CONTEXT_HELP_ID);
        } else {
            this.setHelpAvailable(false);
        }
        this.superComposite.layout();
        return this.superComposite;
    }

    private void setLayoutInFrontOf(Control object, Control inFrontOf, int inFrontOfWidth) {
        FormData fData = new FormData();
        fData.right = new FormAttachment(inFrontOf, 10, 131072);
        object.setLayoutData((Object)fData);
    }

    private Composite createComposite(Composite composite, boolean visible, int cells, boolean horizontalSpace, boolean verticalSpace) {
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new FormLayout());
        GridData gData = new GridData(4, 4, horizontalSpace, verticalSpace);
        gData.horizontalSpan = cells;
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    private Group createGroup(Composite composite, boolean visible, int cells, String groupTitle, boolean horizontalSpace, boolean verticalSpace) {
        Group group = new Group(composite, 0);
        group.setText(groupTitle);
        group.setLayout((Layout)new FormLayout());
        GridData gData = new GridData(4, 4, horizontalSpace, verticalSpace);
        gData.horizontalSpan = cells;
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    private Label createLabel(Composite composite, String title, Control nextTo, int nextToWidth, Control under, int underWidth, int width, Control directlyUnder, String alignment) {
        return this.createLabel(composite, title, nextTo, nextToWidth, under, underWidth, width, directlyUnder, alignment, null);
    }

    private Button createClearButton(Composite composite, String toolTipText, Control nextTo, int nextToWidth, Control under, int underWidth, Control directlyUnder) {
        assert (nextTo == null || directlyUnder == null);
        Button button = new Button(composite, 8);
        button.setImage(DefineScheduleDialog.getDefaultImage());
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        button.setLayoutData((Object)fData);
        return button;
    }

    private Label createLabel(Composite composite, String title, Control nextTo, int nextToWidth, Control under, int underWidth, int width, Control directlyUnder, String alignment, Control inFrontOf) {
        assert (nextTo == null || directlyUnder == null);
        assert (nextTo == null || inFrontOf == null);
        Label label = new Label(composite, 0);
        label.setText(title);
        if (alignment.toLowerCase().equals("right")) {
            label.setAlignment(131072);
        } else if (alignment.toLowerCase().equals("left")) {
            label.setAlignment(16384);
        } else {
            label.setAlignment(0x1000000);
        }
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width) + 12;
        label.setLayoutData((Object)fData);
        return label;
    }

    private Label createPreceedingLabel(Composite composite, String title, Control nextTo, int nextToWidth, Control bottom, int bottomWidth, String alignment) {
        Label label = new Label(composite, 0);
        label.setText(title);
        if (alignment.toLowerCase().equals("right")) {
            label.setAlignment(131072);
        } else if (alignment.toLowerCase().equals("left")) {
            label.setAlignment(16384);
        } else {
            label.setAlignment(0x1000000);
        }
        FormData fData = new FormData();
        fData.bottom = new FormAttachment(bottom, bottomWidth, 1024);
        fData.left = new FormAttachment(nextTo, nextToWidth, 16384);
        fData.width = TextUtil.calculateWidth((Control)composite, 1) + 12;
        fData.height = 17;
        label.setLayoutData((Object)fData);
        return label;
    }

    private Label createNarrowLabel(Composite composite, String title, Control nextTo, Control under, int width, Control directlyUnder, String alignment) {
        assert (nextTo == null || directlyUnder == null);
        Label label = new Label(composite, 0);
        label.setText(title);
        if (alignment.toLowerCase().equals("right")) {
            label.setAlignment(131072);
        } else if (alignment.toLowerCase().equals("left")) {
            label.setAlignment(16384);
        } else {
            label.setAlignment(0x1000000);
        }
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 0);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        fData.height = 17;
        label.setLayoutData((Object)fData);
        return label;
    }

    private Text createField(Composite composite, String initialValueStr, Control nextTo, int nextToWidth, Control under, int underWidth, int width, int limit) {
        return this.createField(composite, initialValueStr, nextTo, nextToWidth, under, underWidth, width, limit, null);
    }

    private Text createField(Composite composite, String initialValue, Control nextTo, int nextToWidth, Control under, int underWidth, int width, int limit, Control directlyUnder) {
        assert (nextTo == null || directlyUnder == null);
        Text field = new Text(composite, 2052);
        field.setTextLimit(limit);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        field.setLayoutData((Object)fData);
        if (initialValue != null) {
            field.setText(initialValue);
        }
        return field;
    }

    private DateTime createCalendar(Composite composite, String dateStr, Control nextTo, int nextToWidth, Control under, int underWidth, Control directlyUnder) {
        assert (nextTo == null || directlyUnder == null);
        DateTime calendar = new DateTime(composite, 3072);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        calendar.setLayoutData((Object)fData);
        if (dateStr != null && !dateStr.trim().equals("")) {
            try {
                String[] dateArr = dateStr.split("/");
                Integer.valueOf(dateArr[0]).intValue();
                int cfr_ignored_0 = Integer.valueOf(dateArr[1]) - 1;
                Integer.valueOf(dateArr[2]).intValue();
            }
            catch (Exception exception) {
                return calendar;
            }
        }
        return calendar;
    }

    private DateTime createTimer(Composite composite, int hours, int minutes, Control nextTo, Control under, Control directlyUnder) {
        assert (nextTo == null || directlyUnder == null);
        DateTime time = new DateTime(composite, 65536);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        time.setLayoutData((Object)fData);
        time.setTime(hours, minutes, 0);
        return time;
    }

    private Spinner createSpinner(Composite composite, int initialValue, Control nextTo, int nextToWidth, Control under, int underWidth, int min, int max, int inc, int charLimit, Control directlyUnder) {
        assert (nextTo == null || directlyUnder == null);
        Spinner field = new Spinner(composite, 2112);
        field.setTextLimit(charLimit);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        if (directlyUnder != null) {
            fData.left = new FormAttachment(directlyUnder, 0, 16384);
        }
        field.setLayoutData((Object)fData);
        field.setMinimum(min);
        field.setMaximum(max);
        field.setIncrement(inc);
        field.setSelection(initialValue);
        return field;
    }

    private Label createSeparator(Composite composite, String title, Control nextTo, int nextToWidth, Control under, int underWidth) {
        Label label = new Label(composite, 0);
        label.setText(title);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        label.setLayoutData((Object)fData);
        return label;
    }

    private Button createCheckbox(Composite composite, String title, boolean initialValue, Control nextTo, int nextToWidth, Control under, int underWidth, int width) {
        return this.createCheckbox(composite, title, initialValue, nextTo, nextToWidth, under, underWidth, width, null);
    }

    private Button createCheckbox(Composite composite, String title, boolean initialValue, Control nextTo, int nextToWidth, Control under, int underWidth, int width, Control inFrontOf) {
        Button field = new Button(composite, 32);
        field.setText(title);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        field.setLayoutData((Object)fData);
        field.setSelection(initialValue);
        boolean specificDaysSelected = this.weekSpecificField.getSelection();
        if (specificDaysSelected) {
            field.setEnabled(true);
        } else {
            field.setEnabled(false);
        }
        return field;
    }

    private Button createRadioButton(Composite composite, String title, boolean initialValue, Control nextTo, int nextToWidth, Control under, int underWidth, int width) {
        return this.createRadioButton(composite, title, initialValue, nextTo, nextToWidth, under, underWidth, width, null);
    }

    private Button createRadioButton(Composite composite, String title, boolean initialValue, Control nextTo, int nextToWidth, Control under, int underWidth, int width, Control inFrontOf) {
        Button button = new Button(composite, 16);
        button.setText(title);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, nextToWidth);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, underWidth);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        button.setLayoutData((Object)fData);
        button.setSelection(initialValue);
        return button;
    }

    @Override
    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.copyMode) {
            this.title = String.valueOf(this.title) + " '" + this.scheduleRow.getName() + "'";
        }
        newShell.setText(this.title);
    }

    protected void okPressed() {
        boolean sorted;
        ScheduleRowModel.getDefaultSchedule(this.getShell().getDisplay());
        HashMap<String, Object> parms = new HashMap<String, Object>();
        this.valid = true;
        this.changed = false;
        this.errorMessages.clear();
        if (this.checkSchedule(this.nameField)) {
            this.appendArg(parms, this.nameField, "NAME", this.scheduleRow.getName(), true);
        }
        this.appendArg(parms, this.descriptionField, "DESCRIPTION", this.scheduleRow.getDescription(), false);
        if (this.checkTextPresence(this.startDateField, "Start Date") && this.checkDateRange(this.startDateField, this.endDateField, this.daysField)) {
            this.appendArg(parms, this.startDateField, "STARTDATE", this.scheduleRow.getStartDate(), true);
            if (!this.scheduleRow.getEndDate().equals("")) {
                this.appendArg(parms, this.endDateField, "ENDDATE", this.scheduleRow.getEndDate(), true);
            } else if (this.calculateDays(this.startDateField.getText(), this.endDateField.getText()) > 999) {
                this.appendArg(parms, this.endDateField, "ENDDATE", this.scheduleRow.getEndDate(), true);
            } else {
                this.appendArg(parms, this.daysField, "DAYS", this.scheduleRow.getDays());
            }
        }
        if (this.checkTime(this.startTime1HoursField, this.startTime1MinutesField, this.endTime1HoursField, this.endTime1MinutesField, "Time Range 1")) {
            this.appendArg(parms, this.startTime1HoursField, this.startTime1MinutesField, "STARTTIME1", this.scheduleRow.getStartTimeHours1(), this.scheduleRow.getStartTimeMins1());
            this.appendArg(parms, this.endTime1HoursField, this.endTime1MinutesField, "ENDTIME1", this.scheduleRow.getEndTimeHours1(), this.scheduleRow.getEndTimeMins1());
        }
        if (this.checkTime(this.startTime2HoursField, this.startTime2MinutesField, this.endTime2HoursField, this.endTime2MinutesField, "Time Range 2")) {
            this.appendArg(parms, this.startTime2HoursField, this.startTime2MinutesField, "STARTTIME2", this.scheduleRow.getStartTimeHours2(), this.scheduleRow.getStartTimeMins2());
            this.appendArg(parms, this.endTime2HoursField, this.endTime2MinutesField, "ENDTIME2", this.scheduleRow.getEndTimeHours2(), this.scheduleRow.getEndTimeMins2());
        }
        if (this.checkTime(this.startTime3HoursField, this.startTime3MinutesField, this.endTime3HoursField, this.endTime3MinutesField, "Time Range 3")) {
            this.appendArg(parms, this.startTime3HoursField, this.startTime3MinutesField, "STARTTIME3", this.scheduleRow.getStartTimeHours3(), this.scheduleRow.getStartTimeMins3());
            this.appendArg(parms, this.endTime3HoursField, this.endTime3MinutesField, "ENDTIME3", this.scheduleRow.getEndTimeHours3(), this.scheduleRow.getEndTimeMins3());
        }
        if (this.checkTime(this.startTime4HoursField, this.startTime4MinutesField, this.endTime4HoursField, this.endTime4MinutesField, "Time Range 4")) {
            this.appendArg(parms, this.startTime4HoursField, this.startTime4MinutesField, "STARTTIME4", this.scheduleRow.getStartTimeHours4(), this.scheduleRow.getStartTimeMins4());
            this.appendArg(parms, this.endTime4HoursField, this.endTime4MinutesField, "ENDTIME4", this.scheduleRow.getEndTimeHours4(), this.scheduleRow.getEndTimeMins4());
        }
        if (this.valid && (sorted = this.sortTimes(this.startTime1HoursField, this.startTime1MinutesField, this.endTime1HoursField, this.endTime1MinutesField, this.startTime2HoursField, this.startTime2MinutesField, this.endTime2HoursField, this.endTime2MinutesField, this.startTime3HoursField, this.startTime3MinutesField, this.endTime3HoursField, this.endTime3MinutesField, this.startTime4HoursField, this.startTime4MinutesField, this.endTime4HoursField, this.endTime4MinutesField))) {
            this.appendArg(parms, this.startTime1HoursField, this.startTime1MinutesField, "STARTTIME1", this.scheduleRow.getStartTimeHours1(), this.scheduleRow.getStartTimeMins1());
            this.appendArg(parms, this.endTime1HoursField, this.endTime1MinutesField, "ENDTIME1", this.scheduleRow.getEndTimeHours1(), this.scheduleRow.getEndTimeMins1());
            this.appendArg(parms, this.startTime2HoursField, this.startTime2MinutesField, "STARTTIME2", this.scheduleRow.getStartTimeHours2(), this.scheduleRow.getStartTimeMins2());
            this.appendArg(parms, this.endTime2HoursField, this.endTime2MinutesField, "ENDTIME2", this.scheduleRow.getEndTimeHours2(), this.scheduleRow.getEndTimeMins2());
            this.appendArg(parms, this.startTime3HoursField, this.startTime3MinutesField, "STARTTIME3", this.scheduleRow.getStartTimeHours3(), this.scheduleRow.getStartTimeMins3());
            this.appendArg(parms, this.endTime3HoursField, this.endTime3MinutesField, "ENDTIME3", this.scheduleRow.getEndTimeHours3(), this.scheduleRow.getEndTimeMins3());
            this.appendArg(parms, this.startTime4HoursField, this.startTime4MinutesField, "STARTTIME4", this.scheduleRow.getStartTimeHours4(), this.scheduleRow.getStartTimeMins4());
            this.appendArg(parms, this.endTime4HoursField, this.endTime4MinutesField, "ENDTIME4", this.scheduleRow.getEndTimeHours4(), this.scheduleRow.getEndTimeMins4());
        }
        if (this.fullWeekField.getSelection()) {
            parms.put("WEEKDAYS", "Y");
            parms.put("WEEKENDS", "Y");
            if (!this.scheduleRow.isFullWeek()) {
                this.changed = true;
            }
        } else {
            this.appendArg(parms, this.weekDaysField, "WEEKDAYS", "Y", "N", this.scheduleRow.isWeekDays());
            this.appendArg(parms, this.weekEndsField, "WEEKENDS", "Y", "N", this.scheduleRow.isWeekEnds());
        }
        this.checkSpecificDays();
        this.appendArg(parms, this.weekSpecificField, "SPECIFICDAYS", "Y", "N", this.scheduleRow.isWeekSpecific());
        this.appendArg(parms, this.weekMondayField, "MONDAY", "Y", "N", this.scheduleRow.isWeekMonday());
        this.appendArg(parms, this.weekTuesdayField, "TUESDAY", "Y", "N", this.scheduleRow.isWeekTuesday());
        this.appendArg(parms, this.weekWednesdayField, "WEDNESDAY", "Y", "N", this.scheduleRow.isWeekWednesday());
        this.appendArg(parms, this.weekThursdayField, "THURSDAY", "Y", "N", this.scheduleRow.isWeekThursday());
        this.appendArg(parms, this.weekFridayField, "FRIDAY", "Y", "N", this.scheduleRow.isWeekFriday());
        this.appendArg(parms, this.weekSaturdayField, "SATURDAY", "Y", "N", this.scheduleRow.isWeekSaturday());
        this.appendArg(parms, this.weekSundayField, "SUNDAY", "Y", "N", this.scheduleRow.isWeekSunday());
        if (!this.valid) {
            if (this.errorMessages.size() > 0) {
                String message = "";
                for (String line : this.errorMessages) {
                    message = String.valueOf(message) + line + "\n\n";
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid input", (String)message);
            }
            return;
        }
        if (this.changed) {
            ServerCallback callback = new ServerCallback(){

                @Override
                public void processReply(XMLRequest reply, MATServer server) {
                    RefreshHandler refresh = new RefreshHandler();
                    refresh.refreshServers(server.getDisplay());
                }

                @Override
                public void cancel(XMLRequest reply, MATServer server) {
                }

                @Override
                public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                    return false;
                }
            };
            if (this.editMode) {
                Singletons.getServerProxy(this.getShell().getDisplay()).editSchedule(this.nameField.getText(), parms, true, callback);
            } else {
                Singletons.getServerProxy(this.getShell().getDisplay()).defineSchedule(this.nameField.getText(), parms, true, callback);
            }
        }
        this.close();
    }

    private void appendArg(Map<String, Object> parms, Text field, String parmname, String originalValue, boolean uppercase) {
        if (field.getText() != null) {
            if (uppercase) {
                field.setText(field.getText().toUpperCase());
            }
            if (!field.getText().equals(originalValue)) {
                this.changed = true;
            }
            parms.put(parmname, field.getText());
        }
    }

    private void appendArg(Map<String, Object> parms, Spinner field, String parmname, int originalValue) {
        if (field.getText() != null) {
            if (field.getSelection() != originalValue) {
                this.changed = true;
            }
            parms.put(parmname, field.getText());
        }
    }

    private void appendArg(Map<String, Object> parms, Text field1, Text field2, String parmname, String originalValue1, String originalValue2) {
        if (field1.getText() != null && field2.getText() != null) {
            if (!field1.getText().equals(originalValue1)) {
                this.changed = true;
            }
            if (!field2.getText().equals(originalValue2)) {
                this.changed = true;
            }
            parms.put(parmname, String.valueOf(field1.getText()) + field2.getText());
        }
    }

    private void appendArg(Map<String, Object> parms, Button field, String parmname, String yesStr, String noStr, boolean originalValue) {
        if (field.getText() != null) {
            parms.put(parmname, field.getSelection() ? yesStr : noStr);
            if (field.getSelection() != originalValue) {
                this.changed = true;
            }
        }
    }

    private boolean checkTextPresence(Text field, String name) {
        if (field.getText() == null || field.getText().isEmpty()) {
            this.valid = false;
            this.errorMessages.add(String.valueOf(name) + " must be specified for every schedule.");
            return false;
        }
        return true;
    }

    private boolean updateDate(Text dateField) {
        block7: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            String dateTextOrig = dateField.getText();
            try {
                String[] parts = dateTextOrig.split("/");
                if (parts.length == 3) {
                    while (parts[0].length() < 4) {
                        parts[0] = "0" + parts[0];
                    }
                    if (parts[1].length() == 1) {
                        parts[1] = "0" + parts[1];
                    }
                    if (parts[2].length() == 1) {
                        parts[2] = "0" + parts[2];
                    }
                    dateTextOrig = String.valueOf(parts[0]) + "/" + parts[1] + "/" + parts[2];
                    dateField.setText(dateTextOrig);
                    Date date = dateFormat.parse(dateTextOrig);
                    String dateTextNew = dateFormat.format(date);
                    if (!dateTextOrig.equals(dateTextNew)) {
                        return false;
                    }
                    break block7;
                }
                return false;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkDateRange(Text startDateField, Text endDateField, Spinner daysSpinner) {
        block10: {
            if (!this.updateDate(startDateField)) {
                this.valid = false;
                this.errorMessages.add("Start Date not a valid date - Start date needs to be a date in format yyyy/mm/dd.");
                return false;
            }
            if (!this.updateDate(endDateField)) {
                this.valid = false;
                this.errorMessages.add("End Date not a valid date - End date needs to be a date in format yyyy/mm/dd.");
                return false;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date startDate = dateFormat.parse(startDateField.getText());
            if (endDateField.getText() == null || endDateField.getText().isEmpty()) break block10;
            try {
                boolean confirm;
                Date endDate = dateFormat.parse(endDateField.getText());
                if (startDate.compareTo(endDate) > 0) {
                    this.valid = false;
                    this.errorMessages.add("Invalid Date Range - Start date is later than end date.");
                    return false;
                }
                if (startDate.compareTo(endDate) == 0) {
                    this.valid = false;
                    this.errorMessages.add("Invalid Date Range - Start date is equal to end date.");
                    return false;
                }
                if (new Date().compareTo(endDate) > 0 && !(confirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Invalid Date Range", (String)"The specified date range has passed. The monitor will not start using this schedule. Save schedule anyway?"))) {
                    this.valid = false;
                    return false;
                }
            }
            catch (ParseException parseException) {
                try {
                    this.valid = false;
                    this.errorMessages.add("End Date not a valid date - End date needs to be a date in format yyyy/mm/dd.");
                    return false;
                }
                catch (ParseException parseException2) {
                    this.valid = false;
                    this.errorMessages.add("Start Date not a valid date - Start date needs to be a date in format yyyy/mm/dd.");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSchedule(Text schedTextField) {
        String scheduleName = schedTextField.getText().trim().toUpperCase();
        if (scheduleName == null || scheduleName.isEmpty()) {
            this.valid = false;
            this.errorMessages.add("Schedule name cannot be empty.");
            return false;
        }
        if (!this.editMode) {
            MATTableRow[] mATTableRowArray = Singletons.getMonitorManager().getMonitorSchedulesTable().getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                ScheduleRowModel schedule = (ScheduleRowModel)row;
                if (schedule.getName().equals(scheduleName)) {
                    this.valid = false;
                    this.errorMessages.add("Schedule " + scheduleName + " already exists.");
                    return false;
                }
                ++n2;
            }
        }
        return this.checkMemberName(schedTextField.getText(), "schedule name");
    }

    private boolean checkMemberName(String value, String name) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        Matcher m = memberPattern.matcher(value = value.trim().toUpperCase());
        if (!m.matches()) {
            this.valid = false;
            this.errorMessages.add("Invalid " + name + " - " + "The " + name + " must follow the rules for job/member names: from one to eight alphanumeric and/or national characters (A-Z, 0-9, #, $, @).  The first character must be alphabetic or national (A-Z, #, $, @).");
            return false;
        }
        return true;
    }

    private boolean checkTime(Text hoursField, Text minutesField, Text hoursField2, Text minutesField2, String name) {
        int hh;
        String hours;
        block19: {
            int mm;
            String minutes;
            block18: {
                int fieldsFilled = 0;
                if (hoursField.getText() != null && !hoursField.getText().isEmpty()) {
                    ++fieldsFilled;
                }
                if (minutesField.getText() != null && !minutesField.getText().isEmpty()) {
                    ++fieldsFilled;
                }
                if (hoursField2.getText() != null && !hoursField2.getText().isEmpty()) {
                    ++fieldsFilled;
                }
                if (minutesField2.getText() != null && !minutesField2.getText().isEmpty()) {
                    ++fieldsFilled;
                }
                if (fieldsFilled == 0) {
                    return true;
                }
                if (fieldsFilled < 4) {
                    this.valid = false;
                    this.errorMessages.add("Invalid " + name + " - " + name + " is incomplete.");
                    return false;
                }
                try {
                    minutes = minutesField.getText().trim();
                    mm = Integer.valueOf(minutes);
                    if (minutes.length() < 2) {
                        minutesField.setText("0" + minutes);
                    }
                    if (mm >= 0 && mm <= 59) break block18;
                    this.valid = false;
                    this.errorMessages.add("Invalid " + name + " - " + name + " start must be between 0:00 and 23:59.");
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    this.valid = false;
                    this.errorMessages.add("Invalid " + name + " - " + name + " start must be between 0:00 and 23:59.");
                    return false;
                }
            }
            hours = hoursField.getText().trim();
            hh = Integer.valueOf(hours);
            if (hours.length() < 2) {
                hoursField.setText("0" + hours);
            }
            if (hh < 0 || hh > 23) {
                this.valid = false;
                this.errorMessages.add("Invalid " + name + " - " + name + " start must be between 0:00 and 23:59.");
                return false;
            }
            try {
                minutes = minutesField2.getText().trim();
                mm = Integer.valueOf(minutes);
                if (minutes.length() < 2) {
                    minutesField2.setText("0" + minutes);
                }
                if (mm >= 0 && mm <= 59) break block19;
                this.valid = false;
                this.errorMessages.add("Invalid " + name + " - " + name + " end must be between 0:00 and 23:59.");
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                this.valid = false;
                this.errorMessages.add("Invalid " + name + " - " + name + " end must be between 0:00 and 23:59.");
                return false;
            }
        }
        hours = hoursField2.getText().trim();
        hh = Integer.valueOf(hours);
        if (hours.length() < 2) {
            hoursField2.setText("0" + hours);
        }
        if (hh < 0 || hh > 23) {
            this.valid = false;
            this.errorMessages.add("Invalid " + name + " - " + name + " end must be between 0:00 and 23:59.");
            return false;
        }
        return true;
    }

    public boolean sortTimes(Text startH1, Text startM1, Text endH1, Text endM1, Text startH2, Text startM2, Text endH2, Text endM2, Text startH3, Text startM3, Text endH3, Text endM3, Text startH4, Text startM4, Text endH4, Text endM4) {
        boolean sorted = false;
        if (!(startH1.getText().equals("") || startH2.getText().equals("") || startH3.getText().equals("") || startH4.getText().equals(""))) {
            return sorted;
        }
        if (startH1.getText().equals("") && startH2.getText().equals("") && startH3.getText().equals("") && startH4.getText().equals("")) {
            return sorted;
        }
        int i = 0;
        while (i < 4) {
            if (startH1.getText().equals("") && !startH2.getText().equals("")) {
                startH1.setText(startH2.getText());
                startM1.setText(startM2.getText());
                endH1.setText(endH2.getText());
                endM1.setText(endM2.getText());
                startH2.setText("");
                startM2.setText("");
                endH2.setText("");
                endM2.setText("");
                sorted = true;
            }
            if (startH2.getText().equals("") && !startH3.getText().equals("")) {
                startH2.setText(startH3.getText());
                startM2.setText(startM3.getText());
                endH2.setText(endH3.getText());
                endM2.setText(endM3.getText());
                startH3.setText("");
                startM3.setText("");
                endH3.setText("");
                endM3.setText("");
                sorted = true;
            }
            if (startH3.getText().equals("") && !startH4.getText().equals("")) {
                startH3.setText(startH4.getText());
                startM3.setText(startM4.getText());
                endH3.setText(endH4.getText());
                endM3.setText(endM4.getText());
                startH4.setText("");
                startM4.setText("");
                endH4.setText("");
                endM4.setText("");
                sorted = true;
            }
            ++i;
        }
        return sorted;
    }

    public boolean checkSpecificDays() {
        if (!this.weekSpecificField.getSelection()) {
            return true;
        }
        if (!(this.weekMondayField.getSelection() || this.weekTuesdayField.getSelection() || this.weekWednesdayField.getSelection() || this.weekThursdayField.getSelection() || this.weekFridayField.getSelection() || this.weekSaturdayField.getSelection() || this.weekSundayField.getSelection())) {
            this.valid = false;
            this.errorMessages.add("You need to select at least 1 day of the week when 'Specific Days' is selected.");
            return false;
        }
        return true;
    }

    private Integer calculateDays(String startDateStr, String endDateStr) {
        Integer[] startDateIntegers = this.parseDateStringToIntegers(startDateStr);
        if (startDateIntegers == null) {
            return 0;
        }
        Integer[] endDateIntegers = this.parseDateStringToIntegers(endDateStr);
        if (endDateIntegers == null) {
            return 0;
        }
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.set(startDateIntegers[0], startDateIntegers[1] - 1, startDateIntegers[2], 12, 0, 0);
        end.set(endDateIntegers[0], endDateIntegers[1] - 1, endDateIntegers[2], 12, 0, 0);
        float mSecondsPerDay = 8.64E7f;
        Date startDate = start.getTime();
        Date endDate = end.getTime();
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        float diffTime = endTime - startTime;
        float diffDays = diffTime / mSecondsPerDay;
        int diffDaysInteger = Math.round(diffDays);
        diffDaysInteger = Math.max(diffDaysInteger, 0);
        DateFormat.getDateInstance();
        return diffDaysInteger;
    }

    private String calculateEndDate(String startDateStr, String daysStr) {
        Integer days = Integer.valueOf(daysStr);
        return this.calculateEndDate(startDateStr, days);
    }

    private String calculateEndDate(String startDateStr, Integer daysStr) {
        long daysLong;
        String endDateStr = "";
        Integer days = null;
        Integer[] startDateIntegers = this.parseDateStringToIntegers(startDateStr);
        if (startDateIntegers == null) {
            return "";
        }
        try {
            days = (int)daysStr;
            daysLong = days.longValue();
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(startDateIntegers[0], startDateIntegers[1] - 1, startDateIntegers[2], 12, 0, 0);
        Date startDate = startCalendar.getTime();
        long startTime = startDate.getTime();
        long diffTime = daysLong * 86400000L;
        long endTime = startTime + diffTime;
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTimeInMillis(endTime);
        Date endDate = endCalendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        endDateStr = dateFormat.format(endDate);
        return endDateStr;
    }

    private Integer[] parseDateStringToIntegers(String dateStr) {
        Integer[] date = new Integer[3];
        if (dateStr == null) {
            return null;
        }
        String[] parts = dateStr.split("/");
        if (parts.length == 3) {
            int i = 0;
            while (i < 3) {
                try {
                    Integer intValue;
                    date[i] = intValue = Integer.valueOf(parts[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                ++i;
            }
            return date;
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        String endDateStr2;
        Integer[] endDateIntegers;
        Integer daysStr2;
        Integer[] startDateIntegers;
        this.startDateField.getText();
        this.endDateField.getText();
        this.daysField.getText();
        if (this.modifyingFields) {
            return;
        }
        this.modifyingFields = true;
        String startDateStr = this.startDateField.getText();
        String endDateStr = this.endDateField.getText();
        String daysStr = this.daysField.getText();
        if (e.getSource() == this.startDateField && (startDateIntegers = this.parseDateStringToIntegers(startDateStr)) != null) {
            this.calendarStart.setDate(startDateIntegers[0].intValue(), startDateIntegers[1] - 1, startDateIntegers[2].intValue());
            daysStr2 = this.calculateDays(startDateStr, endDateStr);
            if (!daysStr.equals(daysStr2.toString())) {
                this.daysField.setSelection(daysStr2.intValue());
            }
        }
        if (e.getSource() == this.endDateField && (endDateIntegers = this.parseDateStringToIntegers(endDateStr)) != null) {
            this.calendarEnd.setDate(endDateIntegers[0].intValue(), endDateIntegers[1] - 1, endDateIntegers[2].intValue());
            daysStr2 = this.calculateDays(startDateStr, endDateStr);
            if (!daysStr.equals(daysStr2.toString())) {
                this.daysField.setSelection(daysStr2.intValue());
            }
        }
        if (e.getSource() == this.daysField && !endDateStr.equals((endDateStr2 = this.calculateEndDate(startDateStr, daysStr)).toString())) {
            this.endDateField.setText(endDateStr2);
            Integer[] endDateIntegers2 = this.parseDateStringToIntegers(endDateStr2);
            if (endDateIntegers2 != null) {
                this.calendarEnd.setDate(endDateIntegers2[0].intValue(), endDateIntegers2[1] - 1, endDateIntegers2[2].intValue());
            }
        }
        this.modifyingFields = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String dateStr;
        if (e.getSource() == this.calendarStart) {
            dateStr = String.format("%04d/%02d/%02d", this.calendarStart.getYear(), this.calendarStart.getMonth() + 1, this.calendarStart.getDay());
            this.startDateField.setText(dateStr);
        }
        if (e.getSource() == this.calendarEnd) {
            dateStr = String.format("%04d/%02d/%02d", this.calendarEnd.getYear(), this.calendarEnd.getMonth() + 1, this.calendarEnd.getDay());
            this.endDateField.setText(dateStr);
        }
    }
}

