/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.utils.VerifyDigit;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class CustomizeDialog
extends TestingToolsDialog
implements Listener {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private IMATTableViewer viewer;
    private Button[] checkboxes;
    private Composite composite;
    private ScrolledComposite composite2;
    private List<Text> textFields = new ArrayList<Text>();
    private ViewerFilter[] filters;
    private Text testField;
    private static boolean descending;
    private static boolean ascending;
    private int sortDirection;
    private static int sortOrder;
    private int[] order;
    private String[] columns;
    private int column;
    private int columnCount;
    private boolean sortedColumns = false;
    int index;
    private Label sort;
    private Button ascendingButton;
    private Button descendingButton;
    private int dialogWidth;
    private int fieldHeight;
    private int newWidth;
    private int defaultWidth;
    Logger log;
    Level baseLevel;
    private String title;

    public CustomizeDialog(Shell parent, IMATTableViewer viewer) {
        super(parent);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.showhidedialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.title = "Table Customization";
        this.viewer = viewer;
    }

    public CustomizeDialog(IShellProvider parentShell) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.showhidedialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.title = "Table Customization";
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        int sortColumn;
        this.columnCount = this.viewer.getColumnCount();
        final int[] columnOrder = this.viewer.getColumnOrder();
        new ArrayList(this.columnCount);
        this.checkboxes = new Button[this.columnCount];
        int width = 1;
        if (this.columnCount > 70) {
            width = (this.columnCount + 34) / 35;
        } else if (this.columnCount > 30) {
            width = (this.columnCount + 14) / 15;
        } else if (this.columnCount > 10) {
            width = (this.columnCount + 9) / 10;
        }
        int height = this.columnCount / width;
        if (height * width < this.columnCount) {
            ++height;
        }
        this.fieldHeight = height + 2;
        this.dialogWidth = width;
        Composite superComposite = (Composite)super.createDialogArea(parent);
        this.composite = new Composite(superComposite, 4);
        this.composite.setLayout((Layout)new GridLayout(4, false));
        this.composite2 = new ScrolledComposite(superComposite, 768);
        this.composite2.setExpandVertical(true);
        this.composite2.setExpandHorizontal(true);
        this.composite2.setMinSize(new Point(1, 1));
        final Composite firstGroup = this.createGroup(true, width);
        final Composite secondGroup = this.createGroup(false, width);
        final Composite buttonGroup = this.createButtonGroup(false, width);
        final Composite thirdGroup = this.create2Group(false);
        final Composite forthGroup = this.create3Group(false, width);
        Button menuButton1 = new Button(this.composite, 0);
        menuButton1.setText("Show columns");
        menuButton1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeDialog.this.composite2.setContent((Control)firstGroup);
                CustomizeDialog.this.showGroup(firstGroup);
                CustomizeDialog.this.hideGroup(secondGroup);
                CustomizeDialog.this.hideGroup(buttonGroup);
                CustomizeDialog.this.hideGroup(thirdGroup);
                CustomizeDialog.this.hideGroup(forthGroup);
                CustomizeDialog.this.ascendingButton.setVisible(false);
                CustomizeDialog.this.descendingButton.setVisible(false);
                CustomizeDialog.this.sort.setVisible(false);
                firstGroup.setSize(firstGroup.computeSize(-1, -1));
                CustomizeDialog.this.getShell().pack();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button menuButton2 = new Button(this.composite, 0);
        menuButton2.setText("Column size");
        menuButton2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeDialog.this.composite2.setContent((Control)secondGroup);
                CustomizeDialog.this.hideGroup(firstGroup);
                CustomizeDialog.this.showGroup(secondGroup);
                CustomizeDialog.this.hideGroup(thirdGroup);
                CustomizeDialog.this.hideGroup(buttonGroup);
                CustomizeDialog.this.hideGroup(forthGroup);
                CustomizeDialog.this.ascendingButton.setVisible(false);
                CustomizeDialog.this.descendingButton.setVisible(false);
                CustomizeDialog.this.sort.setVisible(false);
                secondGroup.setSize(secondGroup.computeSize(-1, -1));
                CustomizeDialog.this.getShell().pack();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button menuButton3 = new Button(this.composite, 0);
        menuButton3.setText("Column order");
        menuButton3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeDialog.this.composite2.setContent((Control)thirdGroup);
                CustomizeDialog.this.hideGroup(firstGroup);
                CustomizeDialog.this.hideGroup(secondGroup);
                CustomizeDialog.this.hideGroup(buttonGroup);
                CustomizeDialog.this.hideGroup(forthGroup);
                CustomizeDialog.this.showGroup(thirdGroup);
                CustomizeDialog.this.sort.setVisible(false);
                CustomizeDialog.this.ascendingButton.setVisible(false);
                CustomizeDialog.this.descendingButton.setVisible(false);
                thirdGroup.setSize(thirdGroup.computeSize(500, 400));
                CustomizeDialog.this.getShell().pack();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button menuButton4 = new Button(this.composite, 0);
        menuButton4.setText("Column sort");
        menuButton4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeDialog.this.composite2.setContent((Control)buttonGroup);
                CustomizeDialog.this.showGroup(forthGroup);
                CustomizeDialog.this.showGroup(buttonGroup);
                CustomizeDialog.this.hideGroup(secondGroup);
                CustomizeDialog.this.hideGroup(firstGroup);
                CustomizeDialog.this.hideGroup(thirdGroup);
                CustomizeDialog.this.ascendingButton.setVisible(true);
                CustomizeDialog.this.descendingButton.setVisible(true);
                CustomizeDialog.this.sort.setVisible(true);
                buttonGroup.setSize(99, 99);
                CustomizeDialog.this.getShell().pack();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ascendingButton = this.createRadioButton(this.composite, "ascending");
        this.descendingButton = this.createRadioButton(this.composite, "descending");
        sortOrder = this.viewer.getSortDirection();
        if (sortOrder == 0) {
            ascending = true;
            this.viewer.setSortDirection(128, true);
            this.ascendingButton.setSelection(true);
            this.descendingButton.setSelection(false);
        }
        if (sortOrder == 128) {
            ascending = true;
            this.viewer.setSortDirection(128, true);
            this.ascendingButton.setSelection(true);
            this.descendingButton.setSelection(false);
        }
        if (sortOrder == 1024) {
            descending = true;
            this.viewer.setSortDirection(1024, true);
            this.descendingButton.setSelection(true);
            this.ascendingButton.setSelection(false);
        }
        int col = 0;
        while (col < this.columnCount) {
            Button check;
            this.checkboxes[col] = check = new Button(firstGroup, 32);
            String name = this.viewer.getColumnName(columnOrder[col]).trim();
            boolean customizable = this.viewer.getColumnCustomizable(columnOrder[col]);
            if (name.isEmpty()) {
                name = "* No Label *";
            }
            check.setText(name);
            check.setSelection(this.viewer.getColumnVisibile(columnOrder[col]));
            check.setEnabled(customizable);
            if (this.viewer.getColumnEmpty(columnOrder[col])) {
                check.setEnabled(false);
                check.setSelection(false);
            } else {
                Label filler = new Label(firstGroup, 0);
                filler.setText("");
            }
            ++col;
        }
        int col2 = 0;
        while (col2 < this.columnCount) {
            String name = this.viewer.getColumnName(columnOrder[col2]).trim();
            this.newWidth = this.viewer.getColumnWidth(columnOrder[col2]);
            this.defaultWidth = this.viewer.getDefaultColumnWidth(columnOrder[col2]);
            if (name.isEmpty()) {
                name = "* No Label *";
            }
            this.createLabel(secondGroup, name);
            Text textField = this.createField(secondGroup);
            textField.setTextLimit(8);
            textField.addVerifyListener((VerifyListener)new VerifyDigit(false));
            if (this.newWidth == 0) {
                textField.setText(Integer.toString(this.defaultWidth));
                this.newWidth = this.defaultWidth;
            } else {
                textField.setText(Integer.toString(this.newWidth));
            }
            textField.addListener(24, (Listener)this);
            this.textFields.add(textField);
            this.textFields.get(col2).addListener(24, (Listener)this);
            ++col2;
        }
        this.composite2.setContent((Control)firstGroup);
        int listHeight = this.fieldHeight * 16;
        final org.eclipse.swt.widgets.List listOfFields = this.createListOfFields(thirdGroup, (Control)thirdGroup, (Control)thirdGroup, this.columnCount);
        final Button buttonUp = this.createButton(thirdGroup, " Up ", (Control)listOfFields, (Control)thirdGroup, listHeight);
        final Button buttonDown = this.createButton(thirdGroup, "Down", (Control)listOfFields, (Control)thirdGroup, listHeight);
        int col22 = 0;
        while (col22 < this.columnCount) {
            String name = this.viewer.getColumnName(columnOrder[col22]).trim();
            listOfFields.add(name);
            ++col22;
        }
        listOfFields.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (listOfFields.getSelectionIndex() != 0) {
                    buttonUp.setEnabled(true);
                } else {
                    buttonUp.setEnabled(false);
                }
                if (listOfFields.getSelectionIndex() != CustomizeDialog.this.viewer.getTable().getColumnCount() - 1) {
                    buttonDown.setEnabled(true);
                } else {
                    buttonDown.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.order = this.viewer.getTable().getColumnOrder();
        buttonUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int temporary = 0;
                int index = listOfFields.getSelectionIndex();
                CustomizeDialog.this.viewer.getColumnName(index);
                CustomizeDialog.this.sortedColumns = true;
                String item = listOfFields.getItem(index);
                listOfFields.setItem(index, listOfFields.getItem(index - 1));
                listOfFields.setItem(index - 1, item);
                listOfFields.setSelection(index - 1);
                buttonDown.setEnabled(true);
                if (listOfFields.getSelectionIndex() == 0) {
                    buttonUp.setEnabled(false);
                }
                temporary = CustomizeDialog.this.order[index - 1];
                ((CustomizeDialog)CustomizeDialog.this).order[index - 1] = CustomizeDialog.this.order[index];
                ((CustomizeDialog)CustomizeDialog.this).order[index] = temporary;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        buttonDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int temporary = 0;
                CustomizeDialog.this.sortedColumns = true;
                int index = listOfFields.getSelectionIndex();
                CustomizeDialog.this.viewer.getColumnName(index);
                if (index < CustomizeDialog.this.viewer.getColumnCount() - 1) {
                    String item = listOfFields.getItem(index);
                    listOfFields.setItem(index, listOfFields.getItem(index + 1));
                    listOfFields.setItem(index + 1, item);
                    listOfFields.setSelection(index + 1);
                    buttonUp.setEnabled(true);
                    if (listOfFields.getSelectionIndex() == CustomizeDialog.this.viewer.getTable().getColumnCount() - 1) {
                        buttonDown.setEnabled(false);
                    }
                    temporary = CustomizeDialog.this.order[index];
                    ((CustomizeDialog)CustomizeDialog.this).order[index] = CustomizeDialog.this.order[index + 1];
                    ((CustomizeDialog)CustomizeDialog.this).order[index + 1] = temporary;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(this.composite, "");
        this.createLabel(this.composite, "");
        this.sort = this.createLabel(this.composite, "Sorted by:");
        this.sort.setVisible(false);
        this.ascendingButton.setVisible(false);
        this.descendingButton.setVisible(false);
        if (this.viewer.getSortDirection() == 128) {
            this.ascendingButton.setSelection(true);
        } else if (this.viewer.getSortDirection() == 1024) {
            this.descendingButton.setSelection(true);
        }
        this.descendingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomizeDialog.this.descendingButton.getSelection()) {
                    CustomizeDialog.this.ascendingButton.setSelection(false);
                    CustomizeDialog.this.descendingButton.setSelection(true);
                    descending = true;
                    ascending = false;
                    CustomizeDialog.this.sortDirection = 1024;
                    sortOrder = 1024;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ascendingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomizeDialog.this.ascendingButton.getSelection()) {
                    CustomizeDialog.this.ascendingButton.setSelection(true);
                    CustomizeDialog.this.descendingButton.setSelection(false);
                    ascending = true;
                    descending = false;
                    CustomizeDialog.this.sortDirection = 128;
                    sortOrder = 128;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columns = new String[this.viewer.getColumnCount()];
        this.column = sortColumn = this.viewer.getSortColumn();
        int col23 = 0;
        while (col23 < this.columnCount) {
            String name = this.viewer.getColumnName(columnOrder[col23]).trim();
            if (name.isEmpty()) {
                name = "* No Label *";
            }
            this.viewer.setDefaultSortDirection(this.viewer.getSortDirection());
            final Button radioButton = this.createRadioButton(buttonGroup, name);
            if (columnOrder[col23] == this.column) {
                radioButton.setSelection(true);
            }
            radioButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String sort = radioButton.getText();
                    int i = 0;
                    while (i < CustomizeDialog.this.viewer.getColumnCount()) {
                        ((CustomizeDialog)CustomizeDialog.this).columns[i] = CustomizeDialog.this.viewer.getColumnName(columnOrder[i]).trim();
                        if (CustomizeDialog.this.columns[i].equalsIgnoreCase(sort)) {
                            CustomizeDialog.this.column = columnOrder[i];
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++col23;
        }
        return superComposite;
    }

    protected void okPressed() {
        int ix = 0;
        while (ix < this.viewer.getColumnCount()) {
            if (!(this.textFields.get(ix).getText().isEmpty() || Integer.parseInt(this.textFields.get(ix).getText()) > 0 && Integer.parseInt(this.textFields.get(ix).getText()) <= 999)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid Input", (String)"Column width must be a number between 1 and 999");
                return;
            }
            ++ix;
        }
        int[] columnOrder = this.viewer.getColumnOrder();
        int maxcolumns = this.viewer.getTable().getColumnCount();
        int i = 0;
        while (i < this.checkboxes.length && i < maxcolumns) {
            Button checkbox = this.checkboxes[i];
            boolean visible = checkbox.getSelection();
            if (checkbox.isEnabled() && this.viewer.getColumnVisibile(columnOrder[i]) != visible) {
                this.viewer.setColumnVisible(columnOrder[i], visible);
            }
            ++i;
        }
        int ix2 = 0;
        while (ix2 < this.viewer.getColumnCount()) {
            String text = this.textFields.get(ix2).getText();
            if (text != null && !text.isEmpty()) {
                int newWidth = Integer.parseInt(text);
                int oldWidth = this.viewer.getColumnWidth(columnOrder[ix2]);
                if (oldWidth != 0 && oldWidth != newWidth) {
                    this.viewer.setColumnWidth(columnOrder[ix2], newWidth);
                }
            }
            ++ix2;
        }
        if (this.sortedColumns) {
            this.viewer.getTable().setColumnOrder(this.order);
        }
        if (ascending && this.viewer.getSortDirection() == 1024) {
            this.viewer.setSortDirection(128, true);
            this.ascendingButton.setSelection(true);
            this.descendingButton.setSelection(false);
        } else if (!ascending && this.viewer.getSortDirection() == 128) {
            this.viewer.setSortDirection(1024, true);
            this.ascendingButton.setSelection(false);
            this.descendingButton.setSelection(true);
        }
        if (this.viewer.getSortColumn() != this.column) {
            this.viewer.setSortColumn(this.column, true);
        }
        this.close();
    }

    @Override
    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format("%s", this.title));
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    private Button createRadioButton(Composite composite, String name) {
        Button button = new Button(composite, 16);
        button.setText(name);
        return button;
    }

    private Button createButton(Composite composite, String name, Control nextTo, Control under, int listHeight) {
        Button button = new Button(composite, 0);
        button.setText(name);
        button.setEnabled(false);
        int height = 35;
        FormData fData = new FormData();
        fData.width = 50;
        fData.height = 25;
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = name == " Up " ? new FormAttachment(under, height - 10) : new FormAttachment(under, height + 15);
        }
        button.setLayoutData((Object)fData);
        return button;
    }

    private org.eclipse.swt.widgets.List createListOfFields(Composite composite, Control nextTo, Control under, int col) {
        org.eclipse.swt.widgets.List newList = new org.eclipse.swt.widgets.List(composite, 2560);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        fData.height = 100;
        newList.setLayoutData((Object)fData);
        return newList;
    }

    private String setMnemonic(ArrayList<Character> mnemonics, String name, boolean customizable) {
        if (name.isEmpty()) {
            return name;
        }
        name = name.replace("&", "&&");
        if (!customizable) {
            return name;
        }
        StringBuilder string = new StringBuilder(name);
        int ix = 0;
        while (ix < string.length()) {
            int found;
            char item = string.charAt(ix);
            if (item != '&' && (found = mnemonics.indexOf(Character.valueOf(item))) == -1) {
                mnemonics.add(Character.valueOf(item));
                string.insert(ix, "&");
                return string.toString();
            }
            ++ix;
        }
        return name;
    }

    private Text createField(Composite composite) {
        Text field = new Text(composite, 2052);
        GridData gData = new GridData();
        gData.widthHint = 50;
        field.setLayoutData((Object)gData);
        return field;
    }

    private Label createLabel(Composite composite, String title) {
        Label label = new Label(composite, 0);
        label.setText(title);
        return label;
    }

    private void showGroup(Composite group) {
        if (!group.isVisible()) {
            group.setVisible(true);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = false;
            group.setLayoutData((Object)gData);
            this.composite.layout();
            this.composite.getParent().layout();
        }
    }

    private void hideGroup(Composite group) {
        if (group.isVisible()) {
            group.setVisible(false);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = true;
            group.setLayoutData((Object)gData);
            this.composite.layout();
            this.composite.getParent().layout();
        }
    }

    private Composite create2Group(boolean visible) {
        Composite group = new Composite((Composite)this.composite2, 0);
        group.setLayout((Layout)new FormLayout());
        GridData gData = new GridData(0, 0, false, false);
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    private Composite createGroup(boolean visible, int width) {
        Composite group = new Composite((Composite)this.composite2, 4);
        GridLayout groupLayout = new GridLayout(4 * width, false);
        group.setLayout((Layout)groupLayout);
        GridData gData = new GridData(4, 4, true, true);
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    private Composite createButtonGroup(boolean visible, int width) {
        Composite group = new Composite((Composite)this.composite2, 4);
        GridLayout groupLayout = new GridLayout(2 * width, false);
        group.setLayout((Layout)groupLayout);
        GridData gData = new GridData(4, 4, true, true);
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    private Composite create3Group(boolean visible, int width) {
        Composite group = new Composite((Composite)this.composite2, 4);
        GridLayout groupLayout = new GridLayout(width, false);
        group.setLayout((Layout)groupLayout);
        GridData gData = new GridData(4, 4, true, true);
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    public void handleEvent(Event event) {
    }
}

