/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.MATException;
import com.ca.mat.Messages;
import com.ca.mat.connect.AnalysisServerCallback;
import com.ca.mat.connect.AnalysisServerJob;
import com.ca.mat.connect.IServerList;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.MonitorProfileServerCallback;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerJob;
import com.ca.mat.connect.ServerStatusJob;
import com.ca.mat.dialogs.MATErrorDialog;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.AnalysisView;
import com.ca.mat.views.MonitorHistoryView;
import com.ca.mat.xml.XMLRequest;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerProxy {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private MATServer server;
    private Map<MATServer, List<StandbyDialog>> dependentDialogs = new HashMap<MATServer, List<StandbyDialog>>();
    public static final int ITEM_TYPE_MONITOR = 1;
    public static final int ITEM_TYPE_MONITOR_RUN = 2;
    public static final int ITEM_TYPE_MTT = 3;
    public static final int ITEM_TYPE_TUNPROF = 4;
    public static final int ITEM_TYPE_TUNLISTS = 5;
    public static final int ITEM_TYPE_TUNSSP = 6;
    public static final int ITEM_TYPE_TUNSCHIX = 7;
    public static final int ITEM_TYPE_COMBINED = 8;
    public static final int SCALE_USER = 1;
    public static final int SCALE_GLOBAL = 2;
    public static final int SCALE_ALL = 3;
    public static final String COMMAND_ANALYSIS = "analysis";
    public static final String COMMAND_LISTING = "listing";
    public static final String COMMAND_GET = "get";
    public static final String COMMAND_INVOKE = "invoke";
    public static final String COMMAND_DELETE_HISTORY = "deletehistory";
    public static final String COMMAND_STOP = "stop";
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_DELETE_MONITOR = "delete";
    public static final String COMMAND_DEFINE_MONITOR = "define";
    public static final String COMMAND_EDIT_MONITOR = "edit";
    public static final String COMMAND_EDIT_SCHEDULE = "editschedule";
    public static final String COMMAND_DEFINE_SCHEDULE = "defineschedule";
    public static final String COMMAND_DELETE_SCHEDULE = "deleteschedule";
    WeakReference<Display> displayWeakRef = new WeakReference<Display>(Display.getCurrent());

    public ServerJob analyzeSingle(String monitorDSN, int analysisType, AnalysisServerCallback callback, Integer cachedHashCode) {
        if (this.server != null) {
            Singletons.getAnalysisManager((Display)this.displayWeakRef.get()).analysisRequested(monitorDSN, analysisType);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("DSN", monitorDSN);
            map.put("attachment", true);
            map.put("multi", true);
            switch (analysisType) {
                case 1: {
                    map.put("type", "ALL");
                    break;
                }
                case 0: {
                    map.put("type", "NORMAL");
                    break;
                }
                case 2: {
                    map.put("type", "ACTIVE");
                    break;
                }
                case 3: {
                    map.put("type", "WAIT");
                }
            }
            if (cachedHashCode != null) {
                map.put("hash", cachedHashCode);
            }
            String jobname = this.generateJobname(this.server, "analyze", monitorDSN);
            AnalysisServerJob job = new AnalysisServerJob(jobname, this.server, map, callback, monitorDSN, analysisType, (Display)this.displayWeakRef.get());
            job.schedule();
            Singletons.getAnalysisManager((Display)this.displayWeakRef.get()).registerJob(monitorDSN, analysisType, job);
            return job;
        }
        return null;
    }

    public void list(int itemType, int scale, ServerCallback callback, boolean systemJob) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("attachment", true);
            map.put("multi", true);
            if (1 == itemType) {
                map.put("type", "tunmon");
            } else if (4 == itemType) {
                map.put("type", "tunprof");
            } else if (5 == itemType) {
                map.put("type", "tunlists");
            } else if (8 == itemType) {
                map.put("type", "tunmontunprof");
            } else if (3 == itemType) {
                map.put("type", "tunmtt");
            } else if (6 == itemType) {
                map.put("type", "tunssp");
            } else if (7 == itemType) {
                map.put("type", "tunschix");
            } else {
                throw new InvalidParameterException("invalid item type: " + itemType);
            }
            map.put("scale", scale);
            ServerJob typeJob = new ServerJob("", this.server, COMMAND_GET, map, callback, (Display)this.displayWeakRef.get());
            typeJob.setSystem(systemJob);
            typeJob.schedule();
        }
    }

    public void listListing(String csect, int scale, ServerCallback callback, boolean systemJob, boolean synchronous) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("attachment", true);
            map.put("multi", true);
            map.put("type", COMMAND_LISTING);
            map.put("csect", csect);
            map.put("scale", scale);
            ServerJob typeJob = new ServerJob("", this.server, COMMAND_GET, map, callback, (Display)this.displayWeakRef.get());
            typeJob.setSystem(systemJob);
            if (synchronous) {
                typeJob.run(null);
            } else {
                typeJob.schedule();
            }
        }
    }

    public void listHistory(String profile, int scale, ServerCallback callback, boolean systemJob) {
        if (this.server != null && this.isConnected(this.server)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("attachment", true);
            map.put("multi", true);
            map.put("type", "tunhist");
            map.put("scale", scale);
            map.put("profile", profile);
            ServerJob typeJob = new ServerJob("", this.server, COMMAND_GET, map, callback, (Display)this.displayWeakRef.get());
            typeJob.setSystem(systemJob);
            typeJob.schedule();
        }
    }

    public void invoke(String profile, boolean global) {
        Display display = (Display)this.displayWeakRef.get();
        String command = COMMAND_INVOKE;
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("profile", profile);
            map.put("global", global);
            map.put("attachment", false);
            MonitorManager monitorManager = Singletons.getMonitorManager(display);
            map.put("mondsn", monitorManager.profileData(profile).getDsn());
            map.put("targsys1", monitorManager.profileData(profile).getTargsys1());
            map.put("targsys2", monitorManager.profileData(profile).getTargsys2());
            map.put("targsys3", monitorManager.profileData(profile).getTargsys3());
            map.put("targsys4", monitorManager.profileData(profile).getTargsys4());
            String jobname = this.generateJobname(this.server, String.format("monitor %s", command), null);
            ServerJob job = new ServerJob(jobname, this.server, command, map, null, display);
            job.schedule();
        }
    }

    public void stop(String profile, boolean global) {
        Display display = (Display)this.displayWeakRef.get();
        String command = COMMAND_STOP;
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("profile", profile);
            map.put("global", global);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("monitor %s", command), null);
            ServerJob job = new ServerJob(jobname, this.server, command, map, null, display);
            job.schedule();
        }
    }

    public void delete(String profile, boolean global, boolean incldatasets) {
        Display display = (Display)this.displayWeakRef.get();
        String command = COMMAND_DELETE_MONITOR;
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("profile", profile);
            map.put("global", global);
            map.put("attachment", false);
            if (incldatasets) {
                map.put("incldatasets", "YES");
            } else {
                map.put("incldatasets", "NO");
            }
            String jobname = this.generateJobname(this.server, String.format("monitor %s", command), null);
            ServerJob job = new ServerJob(jobname, this.server, command, map, null, display);
            job.schedule();
        }
    }

    public void deleteHistory(String profile, boolean global, String dsn, int run, String invdate, String invtime, String strdate, String strtime) {
        String command = COMMAND_DELETE_HISTORY;
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("profile", profile);
            map.put("global", global);
            map.put("attachment", false);
            map.put("mondsn", dsn);
            map.put("run", run);
            map.put("invdate", invdate);
            map.put("invtime", invtime);
            map.put("strdate", strdate);
            map.put("strtime", strtime);
            String jobname = this.generateJobname(this.server, String.format("monitor %s", command), null);
            ServerJob job = new ServerJob(jobname, this.server, command, map, null, (Display)this.displayWeakRef.get());
            job.schedule();
        }
    }

    public void deleteSchedule(String scheduleName, boolean global, boolean reply) {
        Display display = (Display)this.displayWeakRef.get();
        String command = COMMAND_DELETE_SCHEDULE;
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("scheduleName", scheduleName);
            map.put("global", global);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("schedule %s", command), null);
            ServerJob job = new ServerJob(jobname, this.server, command, map, null, display);
            job.schedule();
        }
    }

    public void defineProfile(String profile, Map<String, Object> parameters, boolean global, ServerCallback callback) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(parameters);
            map.put("profile", profile);
            map.put("global", global);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("monitor %s", "definition"), null);
            ServerJob job = new ServerJob(jobname, this.server, COMMAND_DEFINE_MONITOR, map, callback, (Display)this.displayWeakRef.get());
            job.schedule();
        }
    }

    public void editProfile(String profile, Map<String, Object> parameters, boolean global, ServerCallback callback) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(parameters);
            map.put("profile", profile);
            map.put("global", global);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("monitor %s", "definition"), null);
            ServerJob job = new ServerJob(jobname, this.server, COMMAND_EDIT_MONITOR, map, callback, (Display)this.displayWeakRef.get());
            job.schedule();
        }
    }

    public void defineSchedule(String schedule, Map<String, Object> parameters, boolean global, ServerCallback callback) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(parameters);
            map.put("schedule", schedule);
            map.put("global", global);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("monitor %s", "definition"), null);
            ServerJob job = new ServerJob(jobname, this.server, COMMAND_DEFINE_SCHEDULE, map, callback, (Display)this.displayWeakRef.get());
            job.schedule();
        }
    }

    public void editSchedule(String schedule, Map<String, Object> parameters, boolean global, ServerCallback callback) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(parameters);
            map.put("schedule", schedule);
            map.put("global", global);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("monitor %s", "definition"), null);
            ServerJob job = new ServerJob(jobname, this.server, COMMAND_EDIT_SCHEDULE, map, callback, (Display)this.displayWeakRef.get());
            job.schedule();
        }
    }

    public Job downloadListing(String module, String csect, ServerCallback callback) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("module", module);
            map.put("csect", csect);
            map.put("attachment", false);
            map.put("multi", true);
            String jobname = "downloading listing for %s";
            ServerJob job = new ServerJob(jobname, this.server, COMMAND_LISTING, map, callback, (Display)this.displayWeakRef.get());
            job.schedule();
            return job;
        }
        return null;
    }

    public void registerListing(String module, String csect, String lang, String listingManager, String dsn, ServerCallback callback) {
        if (this.server != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mod", module);
            map.put("csect", csect);
            map.put("lang", lang);
            map.put("lmgr", listingManager);
            map.put("ldsn", dsn);
            map.put("attachment", false);
            String jobname = this.generateJobname(this.server, String.format("registering listing for %s", csect), null);
            ServerJob job = new ServerJob(jobname, this.server, COMMAND_REGISTER, map, callback, (Display)this.displayWeakRef.get());
            job.schedule();
        }
    }

    public boolean connect(MATServer serverToConnect) {
        boolean changingServer;
        boolean bl = changingServer = this.server != serverToConnect;
        if (this.server != null && changingServer) {
            String format;
            String msg;
            boolean confirm;
            boolean anyViewsOpen;
            boolean bl2 = anyViewsOpen = MonitorHistoryView.anyOpen() || AnalysisView.anyOpen() || AnalysisTabbedView.anyOpen();
            if (anyViewsOpen && !(confirm = MessageDialog.openConfirm(null, (String)"Related views will close", (String)(msg = String.format(format = "You have open views related to server %s. Changing the server will close these views. Do you want to proceed?", this.server.getName()))))) {
                return false;
            }
            this.disconnectAll();
        }
        this.server = serverToConnect;
        MATServer server = this.getConnectedServer();
        server.setStatusText(1, "Connecting..");
        MonitorProfileServerCallback callback = new MonitorProfileServerCallback();
        this.list(8, 2, callback, false);
        return true;
    }

    public void disconnect(final MATServer server) {
        if (server != null && this.server == server) {
            server.setStatusText(11, "Unknown");
            ServerStatusJob job = new ServerStatusJob(server, (Display)this.displayWeakRef.get());
            job.schedule();
            if (this.displayWeakRef.get() != null) {
                if (((Display)this.displayWeakRef.get()).isDisposed()) {
                    return;
                }
                ((Display)this.displayWeakRef.get()).syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Singletons.getListingManager((Display)ServerProxy.this.displayWeakRef.get()).clearCacheAll();
                        Singletons.getMonitorManager((Display)ServerProxy.this.displayWeakRef.get()).clearProfiles();
                        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage[] iWorkbenchPageArray = activeWindow.getPages();
                        int n = iWorkbenchPageArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IViewReference[] references;
                            IWorkbenchPage page = iWorkbenchPageArray[n2];
                            IViewReference[] iViewReferenceArray = references = page.getViewReferences();
                            int n3 = references.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IViewReference viewRef = iViewReferenceArray[n4];
                                String id = viewRef.getId();
                                if (id.equals("com.ca.mat.views.monitorhistoryview") || id.startsWith("com.ca.mat.views.monitorhistoryview:")) {
                                    try {
                                        page.hideView(viewRef);
                                    }
                                    catch (Exception exception) {}
                                }
                                if (id.equals("com.ca.mat.views.analysisview") || id.startsWith("com.ca.mat.views.analysisview:")) {
                                    try {
                                        page.hideView(viewRef);
                                    }
                                    catch (Exception exception) {}
                                }
                                if (id.equals("com.ca.mat.views.analysistabbedview") || id.startsWith("com.ca.mat.views.analysistabbedview:")) {
                                    try {
                                        page.hideView(viewRef);
                                    }
                                    catch (Exception exception) {}
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                        List dialogs = (List)ServerProxy.this.dependentDialogs.get(server);
                        if (dialogs != null) {
                            for (StandbyDialog dialog : dialogs) {
                                dialog.close();
                            }
                        }
                        if (ServerProxy.this.isConnected(server)) {
                            Job.getJobManager().cancel((Object)server);
                        }
                    }
                });
                this.server = null;
            }
        }
    }

    public void disconnectAll() {
        this.disconnect(this.server);
    }

    public MATServer getConnectedServer() {
        return this.server;
    }

    public boolean isConnected(MATServer server) {
        if (this.server == null) {
            return false;
        }
        return this.server.equals(server);
    }

    public void refreshServerStatus() {
        List<MATServer> servers = Singletons.getServerList((Display)this.displayWeakRef.get()).getServers();
        for (MATServer server : servers) {
            this.refreshServerStatus(server);
        }
    }

    public void refreshServerStatus(MATServer server) {
        IServerList serverList = Singletons.getServerList((Display)this.displayWeakRef.get());
        if (serverList != null) {
            ServerStatusJob job = new ServerStatusJob(server, (Display)this.displayWeakRef.get());
            job.setSystem(true);
            job.schedule();
        }
    }

    private String generateJobname(MATServer server, String command, String dsn) {
        String cmnd = String.format("Requesting %1$s", command).trim();
        String srvr = String.format("%1$s(%2$s:%3$d)", server.getName(), server.getHostname(), server.getPort());
        dsn = dsn != null && !dsn.isEmpty() ? String.valueOf(dsn) + " " : "";
        String jobname = String.format("%1$s %2$s%3$s", cmnd, dsn, srvr);
        return jobname;
    }

    public void requestFailed(final ServerCallback callback, final MATServer server, final XMLRequest reply, final String command, final MATException e, final boolean showError, Display display, final Map<String, Object> parameters) {
        final ArrayList detail = new ArrayList();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean errorHandled = callback != null ? callback.abort(reply, e, server) : false;
                MATException exception = e;
                if (!errorHandled && showError) {
                    ServerProxy proxy;
                    if (reply != null) {
                        String cause = reply.getReasonCode();
                        if (!cause.isEmpty()) {
                            StackTraceElement[] stack;
                            exception = new MATException(cause);
                            if (e != null && (stack = e.getStackTrace()).length > 0) {
                                exception.setStackTrace(stack);
                            }
                        }
                        NodeList list = reply.getLogs(null);
                        int i = 0;
                        while (i < list.getLength()) {
                            Element log = (Element)list.item(i);
                            detail.addAll(reply.logtoList(log));
                            ++i;
                        }
                        if (detail.isEmpty() && exception != null) {
                            detail.add(HexUtil.getErrorText(e));
                        }
                    }
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    String title = "Server error";
                    String message = String.format("Error connecting to server: %s", HexUtil.getErrorText(e));
                    if (command != null) {
                        if (command.equals(ServerProxy.COMMAND_REGISTER)) {
                            title = "Registration error";
                            message = String.format(Messages.serverCommandListingFailed, HexUtil.getErrorText(e));
                        } else if (command.equals(ServerProxy.COMMAND_INVOKE)) {
                            title = "Monitor management error";
                            message = String.format(Messages.serverCommandInvokeFailed, parameters.get("profile"));
                        } else if (command.equals(ServerProxy.COMMAND_STOP)) {
                            title = "Monitor management error";
                            message = String.format(Messages.serverCommandStopFailed, parameters.get("profile"));
                        } else if (command.equals(ServerProxy.COMMAND_DELETE_MONITOR)) {
                            title = "Monitor management error";
                            message = String.format(Messages.serverCommandDeleteFailed, parameters.get("profile"));
                        } else {
                            message = String.format(Messages.serverCommandFailed, command);
                        }
                    }
                    if ((proxy = Singletons.getServerProxy((Display)ServerProxy.this.displayWeakRef.get())).isConnected(server)) {
                        MATErrorDialog.openError(shell, title, message, exception, detail);
                        Logger log = Logging.getLogger(server.getDisplay());
                        LogRecord logrecord = new LogRecord(Level.WARNING, message);
                        logrecord.setParameters(detail.toArray());
                        logrecord.setThrown(e);
                        log.log(logrecord);
                    }
                }
            }
        });
    }

    public void cancelCallback(final ServerCallback callback, final MATServer server, final XMLRequest reply, String command, Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                callback.cancel(reply, server);
            }
        });
        Logger log = Logging.getLogger(server.getDisplay());
        log.log(Level.FINE, String.format(Messages.serverCommandCancelled, command));
    }

    public void addDependentDialog(MATServer server, StandbyDialog dialog) {
        if (server != null) {
            List<StandbyDialog> dialogs = this.dependentDialogs.get(server);
            if (dialogs == null) {
                this.dependentDialogs.put(server, new ArrayList());
                dialogs = this.dependentDialogs.get(server);
            }
            dialogs.add(dialog);
        }
    }

    public void removeDependentDialog(MATServer server, StandbyDialog dialog) {
        List<StandbyDialog> dialogs;
        if (server != null && (dialogs = this.dependentDialogs.get(server)) != null) {
            dialogs.remove((Object)dialog);
        }
    }
}

