/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.MATException;
import com.ca.mat.Messages;
import com.ca.mat.connect.MATLoginCancelledException;
import com.ca.mat.connect.MATSecurityException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.logging.Logging;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.xml.XMLDocument;
import com.ca.mat.xml.XMLRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicNameValuePair;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerConnect {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    protected static final String FILE_PREFIX = "com.ca.testingtools.";
    protected MATServer server = null;
    protected String service;
    private ContentEncodingHttpClient httpclient = null;
    private ClientConnectionManager mgr = null;
    private Logger log;

    public ServerConnect(MATServer server, String service) {
        this.server = server;
        this.service = service;
    }

    public void disconnect() {
        if (this.mgr != null) {
            this.mgr.shutdown();
            this.mgr = null;
        }
        this.httpclient = null;
    }

    public XMLRequest connect(String command, Map<String, Object> map, boolean doSignon) throws MATException {
        return this.connect(command, map, doSignon, false, null);
    }

    public XMLRequest connect(String command, Map<String, Object> map, boolean doSignon, XMLDocument xml) throws MATException {
        return this.connect(command, map, doSignon, false, xml);
    }

    protected XMLRequest connect(String command, Map<String, Object> map, boolean doSignon, boolean stayConnected) throws MATException {
        return this.connect(command, map, doSignon, stayConnected, null);
    }

    public XMLRequest connect(String command, Map<String, Object> map, boolean doSignon, boolean stayConnected, Object objecttosend) throws MATException {
        String query = null;
        Logger log = Logging.getLogger(this.server.getDisplay());
        try {
            XMLRequest xml;
            block39: {
                long start;
                if (this.service == null || this.service.length() == 0) {
                    throw new MATException("Missing service");
                }
                long reply = start = System.currentTimeMillis();
                long finished = start;
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(map.size() + 3);
                if (command != null && !command.isEmpty()) {
                    list.add(new BasicNameValuePair("cmnd", command));
                }
                if (doSignon) {
                    this.server.getLogonUser();
                    list.add(new BasicNameValuePair("user", this.server.getUser()));
                    list.add(new BasicNameValuePair("epassw", this.server.getEPassword()));
                }
                xml = null;
                Set<Map.Entry<String, Object>> set = map.entrySet();
                for (Map.Entry<String, Object> entry : set) {
                    String parm = entry.getKey();
                    Object object = entry.getValue();
                    Object[] objects = object instanceof Collection ? ((Collection)object).toArray() : (object instanceof Object[] ? (Object[])object : new Object[]{object});
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value = objectArray[n2];
                        if (value != null) {
                            list.add(new BasicNameValuePair(parm, String.valueOf(value)));
                        }
                        ++n2;
                    }
                }
                if (list.size() > 0) {
                    query = URLEncodedUtils.format(list, (String)"UTF-8");
                }
                URI uri = URIUtils.createURI((String)"http", (String)this.server.getHostname(), (int)this.server.getPort(), (String)this.service, (String)query, null);
                if (query == null) {
                    query = "No Query";
                }
                HttpGet httpRequest = objecttosend == null ? new HttpGet(uri) : this.setPost(uri, objecttosend);
                start = System.currentTimeMillis();
                try {
                    String message;
                    try {
                        MATException exception;
                        if (this.httpclient == null) {
                            this.httpclient = new ContentEncodingHttpClient();
                            this.mgr = this.httpclient.getConnectionManager();
                        }
                        CredentialsProvider provider = this.httpclient.getCredentialsProvider();
                        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.server.getUser(), this.server.getEPassword());
                        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                        BasicHttpResponse response = (BasicHttpResponse)this.httpclient.execute((HttpUriRequest)httpRequest);
                        reply = System.currentTimeMillis();
                        int result = response.getStatusLine().getStatusCode();
                        if (result == 200) {
                            HttpEntity entity = response.getEntity();
                            if (entity != null) {
                                HashMap<String, String> typeitems;
                                Header header = response.getFirstHeader("Content-Disposition");
                                String disposition = header == null ? "" : header.getValue();
                                HashMap<String, String> dispitems = this.parseHeader(disposition);
                                String dispmode = dispitems.get("primevalue");
                                boolean attached = "attachment".equals(dispmode);
                                header = entity.getContentType();
                                String type = header.getValue();
                                if (type == null) {
                                    type = "";
                                }
                                if ((type = (typeitems = this.parseHeader(type)).get("primevalue")).equals("multipart/mixed")) {
                                    xml = this.getMulti(response, entity, log);
                                } else if (attached || !type.equals("text/xml")) {
                                    String filename = dispitems.get("filename");
                                    xml = this.getAttached(type, filename == null || filename.isEmpty() ? "unknown" : filename, command, response, entity, log);
                                } else {
                                    InputStream stream = entity.getContent();
                                    xml = new XMLRequest(stream);
                                    finished = System.currentTimeMillis();
                                    stream.close();
                                }
                                finished = System.currentTimeMillis();
                                Level level = Level.FINE;
                                if (log.isLoggable(level)) {
                                    ArrayList<String> logParms = new ArrayList<String>();
                                    logParms.add("Server response time: " + (reply - start) + "ms");
                                    logParms.add("Response processing: " + (finished - reply) + "ms");
                                    CookieStore store = this.httpclient.getCookieStore();
                                    List cookies = store.getCookies();
                                    for (Cookie cookie : cookies) {
                                        logParms.add(String.format("cookie: name %s, value %s, domain %s, path %s", cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath()));
                                    }
                                    NodeList logs = xml.getLogs(null);
                                    int size = logs.getLength();
                                    int ix = 0;
                                    while (ix < size) {
                                        boolean listit;
                                        Element logElement = (Element)logs.item(ix);
                                        boolean bl = listit = !Boolean.parseBoolean(logElement.getAttribute("noautolog"));
                                        if (listit) {
                                            String contents = xml.logtoString(logElement);
                                            logParms.add(String.format("Log item %s: %s", ix, contents));
                                        }
                                        ++ix;
                                    }
                                    log.log(Level.FINE, String.format(Messages.serverResponseDetails, command), logParms);
                                }
                            }
                            break block39;
                        }
                        String text = response.getStatusLine().getReasonPhrase();
                        httpRequest.abort();
                        String message2 = MessageFormat.format(Messages.serverCommandFailedDetails, command, text);
                        log.log(Level.FINE, message2, new Object[]{response});
                        if (result == 401) {
                            exception = new MATSecurityException();
                            this.server.logOff();
                            exception.setErrorMessage(message2);
                        } else {
                            exception = new MATException(message2);
                        }
                        throw exception;
                    }
                    catch (ClientProtocolException e) {
                        log.log(Level.WARNING, String.format(Messages.serverResponseException, HexUtil.getErrorText(e), query), e);
                        throw new MATException(e);
                    }
                    catch (UnknownHostException e) {
                        log.log(Level.WARNING, String.format(Messages.serverResponseUnknownHost, this.server.getHostname()), e);
                        message = String.format("Unknown host %s", this.server.getHostname());
                        throw new MATException(message);
                    }
                    catch (HttpHostConnectException e) {
                        log.log(Level.WARNING, String.format(Messages.serverResponseException, HexUtil.getErrorText(e), query), e);
                        throw new MATException(HexUtil.getErrorText(e));
                    }
                    catch (ConnectException e) {
                        LogRecord record = new LogRecord(Level.WARNING, String.format(Messages.serverResponseConnectionRefused, this.server.getHostname(), this.server.getPort()));
                        record.setParameters(new Object[]{"Query: " + query});
                        record.setThrown(e);
                        log.log(record);
                        String message3 = String.format("Connection refused %s:%d", this.server.getHostname(), this.server.getPort());
                        throw new MATException(message3);
                    }
                    catch (SocketException e) {
                        log.log(Level.WARNING, String.format(Messages.serverResponseException, HexUtil.getErrorText(e), query), e);
                        throw new MATException(HexUtil.getErrorText(e));
                    }
                    catch (MATException e) {
                        log.log(Level.WARNING, String.format(Messages.serverResponseException, HexUtil.getErrorText(e), query), e);
                        throw e;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, String.format(Messages.serverResponseException, HexUtil.getErrorText(e), query), e);
                        message = HexUtil.getErrorText(e);
                        if (this.server.getHostname().equals(message)) {
                            message = HexUtil.getErrorText(e, true);
                        }
                        throw new MATException(message, e);
                    }
                }
                finally {
                    if (!stayConnected) {
                        this.mgr.shutdown();
                        this.mgr = null;
                        this.httpclient = null;
                    }
                }
            }
            log.log(Level.FINE, String.format(Messages.debugServerResponseXML, query), xml);
            return xml;
        }
        catch (Exception e) {
            if (e instanceof MATLoginCancelledException) {
                throw (MATException)e;
            }
            LogRecord logrecord = new LogRecord(Level.WARNING, String.format("Exception %s detected while executing %s", HexUtil.getErrorText(e), query));
            logrecord.setThrown(e.getCause());
            log.log(logrecord);
            if (e instanceof MATException) {
                throw (MATException)e;
            }
            log.log(Level.WARNING, String.format(Messages.serverResponseException, HexUtil.getErrorText(e), query), e);
            throw new MATException(e);
        }
    }

    protected XMLRequest getAttached(String type, String filename, String command, BasicHttpResponse response, HttpEntity entity, Logger log) throws IOException {
        String suffix = ".bin";
        boolean text = false;
        if (type.equals("application/zip")) {
            suffix = ".zip";
        } else if (type.equals("text/plain")) {
            suffix = ".txt";
            text = true;
        } else if (type.equals("text/xml")) {
            suffix = ".xml";
            text = true;
        } else if (type.equals("text/csv")) {
            suffix = ".csv";
            text = true;
        } else if (type.equals("application/octet-stream")) {
            suffix = ".bin";
        }
        File file = File.createTempFile(FILE_PREFIX, suffix);
        file.deleteOnExit();
        String fname = file.getAbsolutePath();
        log.log(Level.FINE, "File name:{0}", fname);
        if (text) {
            PrintWriter writer = new PrintWriter(file);
            InputStream instream = entity.getContent();
            InputStreamReader isReader = new InputStreamReader(instream);
            BufferedReader reader = new BufferedReader(isReader);
            String line = reader.readLine();
            int records = 0;
            while (line != null) {
                writer.println(line);
                ++records;
                line = reader.readLine();
            }
            writer.close();
            log.log(Level.FINE, String.format(Messages.debugResponseAttachmentText, fname, records));
        } else {
            FileOutputStream stream = new FileOutputStream(file);
            InputStream instream = entity.getContent();
            byte[] buffer = new byte[65535];
            int read = 0;
            int filesize = 0;
            while ((read = instream.read(buffer)) != -1) {
                ((OutputStream)stream).write(buffer, 0, read);
                filesize += read;
            }
            ((OutputStream)stream).close();
            log.log(Level.FINE, String.format(Messages.debugResponseAttachmentBin, fname, filesize));
        }
        XMLRequest xml = new XMLRequest();
        xml.setCommand(command);
        xml.setAttached(fname, filename, type);
        return xml;
    }

    protected XMLRequest getMulti(BasicHttpResponse response, HttpEntity entity, Logger log) throws IllegalStateException, IOException {
        ArrayList<FileEntity> files = new ArrayList<FileEntity>();
        InputStream input = entity.getContent();
        Header header = entity.getContentType();
        XMLRequest xml = null;
        String type = header.getValue();
        if (type == null) {
            type = "";
        }
        HashMap<String, String> typeitems = this.parseHeader(type);
        byte[] boundary = typeitems.get("boundary").replaceAll("\"", "").getBytes();
        try {
            MultipartStream multipartStream = new MultipartStream(input, boundary);
            boolean nextPart = multipartStream.skipPreamble();
            FileOutputStream output = null;
            while (nextPart) {
                String partheader = multipartStream.readHeaders();
                Header[] partheaders = this.parseHeaders(partheader, log);
                BasicHeader contentType = null;
                Header contentDisposition = null;
                Header[] headerArray = partheaders;
                int n = partheaders.length;
                int n2 = 0;
                while (n2 < n) {
                    Header item = headerArray[n2];
                    String name = item.getName();
                    if (name.equals("Content-Type")) {
                        contentType = item;
                    } else if (name.equals("Content-Disposition")) {
                        contentDisposition = item;
                    }
                    ++n2;
                }
                if (contentType == null) {
                    contentType = new BasicHeader("Content-Type", "application/octet-stream");
                }
                typeitems = this.parseHeader(contentType.getValue());
                String itemtype = typeitems.get("primevalue");
                String suffix = ".bin";
                if (itemtype.equals("text/xml")) {
                    suffix = ".xml";
                } else if (itemtype.equals("application/zip")) {
                    suffix = ".zip";
                } else if (itemtype.equals("text/plain")) {
                    suffix = ".txt";
                } else if (itemtype.equals("text/csv")) {
                    suffix = ".csv";
                } else if (itemtype.equals("application/octet-stream")) {
                    suffix = ".bin";
                }
                if (xml == null && files.isEmpty() && suffix.equals(".xml")) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
                    multipartStream.readBodyData((OutputStream)stream);
                    ByteArrayInputStream bytes = new ByteArrayInputStream(stream.toByteArray());
                    xml = new XMLRequest(bytes);
                    xml.clearAttached();
                } else {
                    String filename = null;
                    if (contentDisposition != null) {
                        HashMap<String, String> dispitems = this.parseHeader(contentDisposition.getValue());
                        filename = dispitems.get("filename");
                    }
                    File file = File.createTempFile(FILE_PREFIX, suffix);
                    file.deleteOnExit();
                    output = new FileOutputStream(file);
                    multipartStream.readBodyData((OutputStream)output);
                    FileEntity newEntity = new FileEntity(file, contentType.getValue());
                    files.add(newEntity);
                    if (xml == null) {
                        xml = new XMLRequest();
                        xml.setCommand("unknown");
                    }
                    xml.addAttachedfile(file.getAbsolutePath(), filename, itemtype);
                }
                nextPart = multipartStream.readBoundary();
            }
        }
        catch (MultipartStream.MalformedStreamException e) {
            log.log(Level.INFO, Messages.multipartResponseException, e);
        }
        catch (IOException e) {
            log.log(Level.INFO, Messages.multipartResponseException, e);
        }
        catch (MATException e) {
            log.log(Level.INFO, Messages.multipartResponseException, e);
        }
        return xml;
    }

    private HttpPost setPost(URI uri, Object objecttosend) {
        HttpPost httppost = new HttpPost(uri);
        HttpEntity entity = null;
        try {
            if (objecttosend instanceof AbstractHttpEntity) {
                entity = (HttpEntity)objecttosend;
            } else if (objecttosend instanceof String) {
                entity = new StringEntity((String)objecttosend);
                ((StringEntity)entity).setContentType("text/plain");
            } else if (objecttosend instanceof byte[]) {
                entity = new ByteArrayEntity((byte[])objecttosend);
                ((ByteArrayEntity)entity).setContentType("application/octet-stream");
            } else if (objecttosend instanceof XMLDocument) {
                entity = new StringEntity(((XMLDocument)objecttosend).toString(), "text/xml", "ISO-8859-1");
            } else if (objecttosend instanceof File) {
                entity = new FileEntity((File)objecttosend, "application/octet-stream");
            }
            if (entity == null) {
                entity = new StringEntity(String.valueOf(objecttosend));
                ((StringEntity)entity).setContentType("text/plain");
            }
            httppost.setEntity(entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return httppost;
    }

    private Header[] parseHeaders(String partheader, Logger log) {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        BufferedReader reader = new BufferedReader(new StringReader(partheader));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                int ix;
                if ((line = line.trim()).isEmpty() || (ix = line.indexOf(58)) == -1) continue;
                String name = line.substring(0, ix);
                String value = line.substring(ix + 1);
                BasicHeader header = new BasicHeader(name, value);
                headers.add(header);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, Messages.debugServerResponseHeadersUnreadable, e);
        }
        Header[] items = new Header[headers.size()];
        headers.toArray(items);
        return items;
    }

    private HashMap<String, String> parseHeader(String header) {
        HashMap<String, String> pairs = new HashMap<String, String>();
        if (header != null) {
            String value;
            int ix = header.indexOf(59);
            if (ix == -1) {
                value = header;
                header = "";
            } else {
                value = header.substring(0, ix);
                header = header.substring(ix + 1);
            }
            pairs.put("primevalue", value.trim());
            if (!header.isEmpty()) {
                String[] split;
                String[] stringArray = split = header.split(";");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] values = pair.split("=", 2);
                    if (values.length > 0) {
                        pairs.put(values[0].trim(), values.length > 1 ? values[1].trim() : null);
                    }
                    ++n2;
                }
            }
        }
        return pairs;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    public ContentEncodingHttpClient getHttpclient() {
        return this.httpclient;
    }
}

