/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.MATException;
import com.ca.mat.MATIgnoreStackTraceException;
import com.ca.mat.Messages;
import com.ca.mat.connect.MATLoginCancelledException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.dialogs.MATErrorDialog;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.xml.XMLRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AnalysisServerCallback
implements ServerCallback {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    String profile;
    String dsn;
    boolean isFirst;
    int analysisType;
    StandbyDialog dialog;
    IAnalysisPagePresentation view;
    Date start;
    Display display;

    public AnalysisServerCallback(String profile, String dsn, int analysisType, boolean isFirst, StandbyDialog dialog, Display display) {
        this.profile = profile;
        this.dsn = dsn;
        this.isFirst = isFirst;
        this.analysisType = analysisType;
        this.display = display;
        this.dialog = dialog;
        if (dialog != null) {
            ServerProxy serverProxy = Singletons.getServerProxy(display);
            serverProxy.addDependentDialog(serverProxy.getConnectedServer(), dialog);
        }
    }

    @Override
    public void processReply(XMLRequest reply, MATServer server) {
        if (Singletons.getServerProxy(this.display).isConnected(server)) {
            Singletons.getAnalysisManager(this.display).processAnalysis(this.dsn, reply, this.profile, this.analysisType, this.isFirst, server, this.dialog);
        }
    }

    @Override
    public void cancel(XMLRequest reply, MATServer server) {
        Singletons.getAnalysisManager(this.display).analysisCancelled(this.dsn, this.analysisType);
        if (this.dialog != null) {
            this.dialog.close();
            Singletons.getServerProxy(this.display).removeDependentDialog(server, this.dialog);
        }
        Logger log = Logging.getLogger(server.getDisplay());
        log.log(Level.FINE, String.format(Messages.analysisCancelled, this.profile, this.dsn));
        this.deleteTempFile(reply);
    }

    @Override
    public boolean abort(XMLRequest reply, MATException e, MATServer server) {
        Singletons.getAnalysisManager(this.display).analysisRequestFailed(this.dsn, this.analysisType);
        if (this.dialog != null) {
            this.dialog.close();
            Singletons.getServerProxy(this.display).removeDependentDialog(server, this.dialog);
        }
        if (e instanceof MATLoginCancelledException) {
            return true;
        }
        this.processError(reply, e);
        this.deleteTempFile(reply);
        return true;
    }

    private void processError(XMLRequest reply, MATException e) {
        String message = String.format("Error requesting analysis for %s", this.dsn);
        final ArrayList<String> detail = new ArrayList<String>();
        MATIgnoreStackTraceException exception = null;
        int rc = reply != null ? reply.getErrorLevel() : 20;
        if (rc > 0) {
            String reasonText;
            if (reply != null) {
                NodeList list = reply.getLogs(null);
                int i = 0;
                while (i < list.getLength()) {
                    Element log = (Element)list.item(i);
                    detail.addAll(reply.logtoList(log));
                    ++i;
                }
            }
            if (detail.isEmpty()) {
                if (e != null) {
                    detail.add(HexUtil.getErrorText(e));
                }
            } else {
                StringBuilder builder = new StringBuilder();
                for (String line : detail) {
                    builder.append(line);
                    builder.append("\n");
                }
                exception = new MATIgnoreStackTraceException(builder.toString());
            }
            final String finalMessage = message;
            String string = reasonText = reply == null ? "" : String.format("Server error: %s", reply.getReasonCode());
            if (reasonText.isEmpty()) {
                reasonText = "An error occured on the server, see detail for explanation";
            }
            if (rc == 12) {
                reasonText = String.format(String.valueOf(reply.getErrorMessage()) + ' ' + reply.getReasonCode(), new Object[0]);
            }
            final String reason = reasonText;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MATErrorDialog.openError(shell, "Server error", finalMessage, detail, reason);
                }
            });
            LogRecord record = new LogRecord(Level.WARNING, String.valueOf(finalMessage) + " " + reasonText);
            record.setParameters(detail.toArray());
            record.setThrown(exception);
            Logging.getLogger(this.display).log(record);
        }
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager(this.display).unregisterTempFile(reply.getAttachedFile());
        }
    }
}

