/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.common.table;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModelListener;
import com.ca.mat.common.table.MATTableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class MATTableModel {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private List<MATTableRow> content = new ArrayList<MATTableRow>();
    private MATTableRow total;
    private Map<MATTableModelListener, Object> listeners = new WeakHashMap<MATTableModelListener, Object>();
    private Object nullObject = new Object();
    private List<String> columnOrder = new ArrayList<String>();
    private Map<String, ColumnDescriptor> columns = new HashMap<String, ColumnDescriptor>();
    private boolean defaultSort = true;
    private String dsn;
    private int type;

    public MATTableModel(String dsn, int type) {
        this.dsn = dsn;
        this.type = type;
    }

    public MATTableModel(String dsn) {
        this.dsn = dsn;
    }

    public MATTableModel() {
        this(null);
    }

    public String getDsn() {
        return this.dsn;
    }

    public int getType() {
        return this.type;
    }

    public void addRow(MATTableRow row) {
        this.content.add(row);
        row.model = this;
        this.notifyListeners();
    }

    public void removeRow(MATTableRow row) {
        this.content.remove(row);
        this.notifyListeners();
    }

    public void setTotal(MATTableRow total) {
        this.total = total;
    }

    public Double summarizeColumn(int column) {
        Double result = 0.0;
        MATTableRow[] mATTableRowArray = this.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (column >= 0 && column < row.getArray().length) {
                if (row.getObject(column) instanceof Double) {
                    result = result + (Double)row.getObject(column);
                } else {
                    try {
                        result = result + Double.valueOf(row.getObject(column).toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            ++n2;
        }
        return result;
    }

    public MATTableRow getTotal() {
        return this.total;
    }

    public boolean containsColumn(String id) {
        return this.columns.get(id) != null;
    }

    public MATTableModel filterBy(String fieldName, Object value) {
        HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
        arguments.put(fieldName, new Object[]{value});
        return this.filterBy(arguments);
    }

    public MATTableModel filterBy(Map<String, Object[]> arguments) {
        return this.filterBy(arguments, false, false);
    }

    public MATTableModel filterBy(Map<String, Object[]> arguments, boolean or) {
        return this.filterBy(arguments, or, false);
    }

    public MATTableModel filterBy(Map<String, Object[]> arguments, boolean or, boolean not) {
        MATTableModel result = new MATTableModel();
        result.columns = this.columns;
        result.columnOrder = this.columnOrder;
        result.dsn = this.dsn;
        for (MATTableRow row : this.content) {
            if (row instanceof FilterableTableRow) {
                int n;
                FilterableTableRow fRow = (FilterableTableRow)((Object)row);
                boolean complies = false;
                if (or) {
                    complies = false;
                    for (Map.Entry<String, Object[]> argument : arguments.entrySet()) {
                        Object[] objectArray = argument.getValue();
                        n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            if (fRow.compliesWithFilter(argument.getKey(), obj)) {
                                complies = true;
                            }
                            ++n2;
                        }
                    }
                } else {
                    complies = true;
                    for (Map.Entry<String, Object[]> argument : arguments.entrySet()) {
                        boolean fieldComplies = false;
                        Object[] objectArray = argument.getValue();
                        int n3 = objectArray.length;
                        n = 0;
                        while (n < n3) {
                            Object obj = objectArray[n];
                            if (fRow.compliesWithFilter(argument.getKey(), obj)) {
                                fieldComplies = true;
                            }
                            ++n;
                        }
                        if (fieldComplies) continue;
                        complies = false;
                    }
                }
                if (not) {
                    boolean bl = complies = !complies;
                }
                if (!complies) continue;
                result.addRow(row);
                continue;
            }
            throw new RuntimeException("All table rows must implement FilterableTableRow to use CATAbleModel.filterBy");
        }
        return result;
    }

    public boolean contains(String fieldName, Object value) {
        HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
        arguments.put(fieldName, new Object[]{value});
        return this.contains(arguments);
    }

    public boolean contains(Map<String, Object[]> arguments) {
        return this.contains(arguments, false);
    }

    public boolean contains(Map<String, Object[]> arguments, boolean or) {
        return this.contains(arguments, or, false);
    }

    public boolean contains(Map<String, Object[]> arguments, boolean or, boolean not) {
        for (MATTableRow row : this.content) {
            if (row instanceof FilterableTableRow) {
                Object obj;
                int n;
                int n2;
                Object[] objectArray;
                FilterableTableRow fRow = (FilterableTableRow)((Object)row);
                boolean complies = false;
                if (or) {
                    complies = false;
                    for (Map.Entry<String, Object[]> argument : arguments.entrySet()) {
                        objectArray = argument.getValue();
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            obj = objectArray[n];
                            if (fRow.compliesWithFilter(argument.getKey(), obj)) {
                                complies = true;
                            }
                            ++n;
                        }
                    }
                } else {
                    complies = true;
                    for (Map.Entry<String, Object[]> argument : arguments.entrySet()) {
                        objectArray = argument.getValue();
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            obj = objectArray[n];
                            if (!fRow.compliesWithFilter(argument.getKey(), obj)) {
                                complies = false;
                            }
                            ++n;
                        }
                    }
                }
                if (not) {
                    boolean bl = complies = !complies;
                }
                if (!complies) continue;
                return true;
            }
            throw new RuntimeException("All table rows must implement FilterableTableRow to use CATAbleModel.filterBy");
        }
        return false;
    }

    public MATTableRow[] getRows() {
        return this.getRows(false);
    }

    public void sortByColumn(final int columnIndex, final boolean ascending) {
        Collections.sort(this.content, new Comparator<MATTableRow>(){

            @Override
            public int compare(MATTableRow row1, MATTableRow row2) {
                int sign = ascending ? 1 : -1;
                Object obj1 = row1.getObject(columnIndex);
                Object obj2 = row2.getObject(columnIndex);
                if (obj1 != null && obj2 == null) {
                    return -1 * sign;
                }
                if (obj1 == null && obj2 != null) {
                    return 1 * sign;
                }
                if (obj1 == null && obj2 == null) {
                    return 0;
                }
                if (obj1 instanceof Integer && obj2 instanceof Integer) {
                    return ((Integer)obj1).compareTo((Integer)obj2) * sign;
                }
                if (obj1 instanceof Double && obj2 instanceof Double) {
                    return ((Double)obj1).compareTo((Double)obj2) * sign;
                }
                return obj1.toString().compareToIgnoreCase(obj2.toString()) * sign;
            }
        });
    }

    public MATTableRow[] getRows(boolean includeTotal) {
        if (this.content.size() > 0) {
            boolean useTotal = this.getTotal() != null && includeTotal;
            MATTableRow[] result = new MATTableRow[this.content.size() + (useTotal ? 1 : 0)];
            int i = 0;
            Iterator<MATTableRow> iterator = this.content.iterator();
            while (iterator.hasNext()) {
                MATTableRow row;
                result[i] = row = iterator.next();
                ++i;
            }
            if (useTotal) {
                result[i] = this.getTotal();
            }
            return result;
        }
        return new MATTableRow[0];
    }

    public boolean isEmpty() {
        return this.content == null || this.content.size() == 0;
    }

    public void clearRows() {
        this.content = new ArrayList<MATTableRow>();
        this.notifyListeners();
    }

    public void addCATableModelListener(MATTableModelListener listener) {
        this.listeners.put(listener, this.nullObject);
    }

    public void removeCATableModelListener(MATTableModelListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (MATTableModelListener listener : this.listeners.keySet()) {
            listener.contentChanged(this);
        }
    }

    public void addColumnFormat(String id, String format) {
        ColumnDescriptor colDesc = new ColumnDescriptor();
        if (!this.columnOrder.contains(id)) {
            this.columnOrder.add(id);
        }
        if (this.columns.containsKey(id)) {
            colDesc = this.columns.get(id);
        }
        if (format.contains("L")) {
            colDesc.type = "MATTableViewer.COLUMN_TYPE_NUMBER";
            colDesc.vartype = "Double";
        } else if (format.contains("R")) {
            colDesc.type = "MATTableViewer.COLUMN_TYPE_PERCENTAGE";
            colDesc.vartype = "Double";
        } else if (format.contains("I") || format.contains("U")) {
            colDesc.type = "MATTableViewer.COLUMN_TYPE_NUMBER";
            colDesc.vartype = "Integer";
        } else {
            colDesc.type = "MATTableViewer.COLUMN_TYPE_STRING";
            colDesc.vartype = "String";
        }
        colDesc.width = 150;
        this.columns.put(id, colDesc);
    }

    public void addColumnDescription(String id, String desc) {
        ColumnDescriptor colDesc = new ColumnDescriptor();
        if (!this.columnOrder.contains(id)) {
            this.columnOrder.add(id);
        }
        if (this.columns.containsKey(id)) {
            colDesc = this.columns.get(id);
        }
        colDesc.name = desc;
        this.columns.put(id, colDesc);
    }

    public List<String> getColumnOrder() {
        return this.columnOrder;
    }

    public String getColumnDescription(String id) {
        ColumnDescriptor colDesc = this.columns.get(id);
        if (colDesc == null) {
            return "";
        }
        return colDesc.name;
    }

    public boolean hasColumn(String id) {
        return this.columns.containsKey(id);
    }

    public void printCode(String modelName) {
        ColumnDescriptor colDesc;
        String object;
        ColumnDescriptor colDesc2;
        System.out.println("--------------------------------------------------");
        System.out.println("            Model Name: " + modelName);
        System.out.println("--------------------------------------------------");
        System.out.println("--------Column definitions----------");
        for (String id : this.columnOrder) {
            colDesc2 = this.columns.get(id);
            System.out.println("viewer.addStandardColumn(\"" + colDesc2.name + "\", " + colDesc2.width + ", \"" + colDesc2.name + "\", " + colDesc2.type + ");");
        }
        System.out.println("--------Variable definitions----------");
        for (String id : this.columnOrder) {
            colDesc2 = this.columns.get(id);
            String def = "\"\"";
            if (colDesc2.vartype == "Integer") {
                def = "null";
            }
            if (colDesc2.vartype == "Double") {
                def = "null";
            }
            System.out.println("private " + colDesc2.vartype + " " + id.toLowerCase() + " = " + def + ";     //" + colDesc2.name);
        }
        System.out.println("--------getArray() function ----------");
        System.out.print("return new Object[]{ ");
        int i = 0;
        for (String id : this.columnOrder) {
            ++i;
            object = id.toLowerCase();
            if (this.columns.get(object) != null && (this.columns.get((Object)object).vartype == "Integer" || this.columns.get((Object)object).vartype == "Double")) {
                object = "(" + id + " == -1 ? \"\" : " + id + ")";
            }
            System.out.print(String.valueOf(object) + (i == this.columnOrder.size() ? "};" : ", "));
        }
        System.out.println("");
        System.out.println("--------handleAttributes assignments----------");
        for (String id : this.columnOrder) {
            colDesc = this.columns.get(id);
            String value = "error";
            if (colDesc.vartype.equals("Integer")) {
                value = "Integer.valueOf(value)";
            } else if (colDesc.vartype.equals("Double")) {
                value = "Double.valueOf(value)";
            } else if (colDesc.vartype.equals("String")) {
                value = "value";
            }
            System.out.println("value = attr.getValue(\"" + id + "\");\t\tif(value!=null) result." + id.toLowerCase() + " = " + value + ";");
        }
        System.out.println("--------getTooltip ----------");
        System.out.print("String f = \"\"");
        for (String id : this.columnOrder) {
            colDesc = this.columns.get(id);
            String tooltipname = colDesc.name.replace("%", "%%");
            System.out.println(" +\"" + tooltipname + " %s\\n\"");
        }
        System.out.println(";");
        System.out.print("return String.format(f, ");
        i = 0;
        for (String id : this.columnOrder) {
            ++i;
            object = id.toLowerCase();
            if (this.columns.get(object) != null && (this.columns.get((Object)object).vartype == "Integer" || this.columns.get((Object)id).vartype == "Double")) {
                object = "(" + id + " == -1 ? \"\" : " + id + ")";
            }
            System.out.print(String.valueOf(object) + (i == this.columnOrder.size() ? ");" : ", "));
        }
        System.out.println("");
        System.out.println("------------------------------------");
    }

    private class ColumnDescriptor {
        public String name;
        public String type;
        public String vartype;
        public int width;

        private ColumnDescriptor() {
        }
    }
}

