/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.common.table;

import com.ca.mat.Constants;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableRow;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MATTableFilter
extends ViewerFilter {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final int NULL_FILTER = 0;
    private static final int operatorType_GREATER_THAN = 200;
    private static final int operatorType_GREATER_OR_EQUAL = 201;
    private static final int operatorType_EQUAL = 202;
    private static final int operatorType_NOT_EQUAL = 212;
    private static final int operatorType_LESSER_OR_EQUAL = 203;
    private static final int operatorType_LESSER = 204;
    private static final int operatorType_NONE = 205;
    private static final int INPUT_TEXT_HEX = 1;
    private static final int INPUT_TEXT_DATE = 2;
    private static final int INPUT_TEXT_TIME = 3;
    private static final int INPUT_TEXT_DOUBLE = 4;
    private static final int INPUT_TEXT_FLOAT = 5;
    private static final int INPUT_TEXT_STRING = 6;
    private static final int INPUT_TEXT_STRING_WITH_WILDCARDS = 7;
    private static final int INPUT_TEXT_STRING_NA = 8;
    private static final Pattern filter = Pattern.compile("[\\*%\\?]");
    private static final String TIPFORMAT = "\nFilter: '%s'";
    private boolean internal = false;
    private boolean valid = true;
    IMATTableViewer viewer;
    static final int FILTER_TYPE_SPECIFIC_COLUMN = 0;
    static final int FILTER_TYPE_QUICK_FILTER = 1;
    private static final String decimalSeparator;
    private static final String groupingSeparator;
    private List<Integer> filteredColumns;
    private int dataColumn;
    private String expression;
    private String inputText;
    private Double inputNumber;
    private Double inputNumberHex;
    private Date inputDate;
    private int inputTextType;
    private boolean isQuickFilter;
    private int operatorType;
    private String operatorText;
    private Pattern pattern;
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private String toolTip;
    private int type;
    private static HashMap<String, int[]> verificationMap;

    static {
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance();
        DecimalFormatSymbols dfs = format.getDecimalFormatSymbols();
        decimalSeparator = String.valueOf(dfs.getDecimalSeparator());
        groupingSeparator = String.valueOf(dfs.getGroupingSeparator());
        verificationMap = new HashMap();
        int[] nArray = new int[3];
        nArray[0] = 10;
        nArray[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(205), nArray);
        int[] nArray2 = new int[3];
        nArray2[0] = 10;
        nArray2[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(202), nArray2);
        int[] nArray3 = new int[3];
        nArray3[0] = 10;
        nArray3[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(204), nArray3);
        int[] nArray4 = new int[3];
        nArray4[0] = 10;
        nArray4[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(203), nArray4);
        int[] nArray5 = new int[3];
        nArray5[0] = 10;
        nArray5[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(212), nArray5);
        int[] nArray6 = new int[3];
        nArray6[0] = 10;
        nArray6[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(201), nArray6);
        int[] nArray7 = new int[3];
        nArray7[0] = 10;
        nArray7[1] = 1;
        verificationMap.put(String.valueOf(String.valueOf(1)) + String.valueOf(200), nArray7);
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(205), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(204), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(203), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(212), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(202), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(201), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(2)) + String.valueOf(200), new int[]{4, 5});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(205), new int[]{6});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(204), new int[]{6});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(203), new int[]{6});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(212), new int[]{6});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(202), new int[]{6});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(201), new int[]{6});
        verificationMap.put(String.valueOf(String.valueOf(3)) + String.valueOf(200), new int[]{6});
        int[] nArray8 = new int[10];
        nArray8[0] = 1;
        nArray8[2] = 2;
        nArray8[3] = 3;
        nArray8[4] = 6;
        nArray8[5] = 8;
        nArray8[6] = 9;
        nArray8[7] = 10;
        nArray8[8] = 11;
        nArray8[9] = 12;
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(205), nArray8);
        int[] nArray9 = new int[10];
        nArray9[0] = 1;
        nArray9[2] = 2;
        nArray9[3] = 3;
        nArray9[4] = 6;
        nArray9[5] = 8;
        nArray9[6] = 9;
        nArray9[7] = 10;
        nArray9[8] = 11;
        nArray9[9] = 12;
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(202), nArray9);
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(204), new int[]{2, 3, 8, 9, 10, 11, 12});
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(203), new int[]{2, 3, 8, 9, 10, 11, 12});
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(212), new int[]{2, 3, 8, 9, 10, 11, 12});
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(201), new int[]{2, 3, 8, 9, 10, 11, 12});
        verificationMap.put(String.valueOf(String.valueOf(4)) + String.valueOf(200), new int[]{2, 3, 8, 9, 10, 11, 12});
        int[] nArray10 = new int[6];
        nArray10[0] = 1;
        nArray10[2] = 2;
        nArray10[3] = 3;
        nArray10[4] = 9;
        nArray10[5] = 12;
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(205), nArray10);
        int[] nArray11 = new int[6];
        nArray11[0] = 1;
        nArray11[2] = 2;
        nArray11[3] = 3;
        nArray11[4] = 9;
        nArray11[5] = 12;
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(202), nArray11);
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(204), new int[]{2, 3, 9, 12});
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(203), new int[]{2, 3, 9, 12});
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(212), new int[]{2, 3, 9, 12});
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(201), new int[]{2, 3, 9, 12});
        verificationMap.put(String.valueOf(String.valueOf(5)) + String.valueOf(200), new int[]{2, 3, 9, 12});
        int[] nArray12 = new int[2];
        nArray12[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(205), nArray12);
        int[] nArray13 = new int[2];
        nArray13[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(204), nArray13);
        int[] nArray14 = new int[2];
        nArray14[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(203), nArray14);
        int[] nArray15 = new int[2];
        nArray15[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(212), nArray15);
        int[] nArray16 = new int[2];
        nArray16[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(202), nArray16);
        int[] nArray17 = new int[2];
        nArray17[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(201), nArray17);
        int[] nArray18 = new int[2];
        nArray18[0] = 1;
        verificationMap.put(String.valueOf(String.valueOf(6)) + String.valueOf(200), nArray18);
        int[] nArray19 = new int[7];
        nArray19[0] = 1;
        nArray19[2] = 4;
        nArray19[3] = 5;
        nArray19[4] = 6;
        nArray19[5] = 6;
        nArray19[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(205), nArray19);
        int[] nArray20 = new int[7];
        nArray20[0] = 1;
        nArray20[2] = 4;
        nArray20[3] = 5;
        nArray20[4] = 6;
        nArray20[5] = 6;
        nArray20[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(204), nArray20);
        int[] nArray21 = new int[7];
        nArray21[0] = 1;
        nArray21[2] = 4;
        nArray21[3] = 5;
        nArray21[4] = 6;
        nArray21[5] = 6;
        nArray21[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(203), nArray21);
        int[] nArray22 = new int[7];
        nArray22[0] = 1;
        nArray22[2] = 4;
        nArray22[3] = 5;
        nArray22[4] = 6;
        nArray22[5] = 6;
        nArray22[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(212), nArray22);
        int[] nArray23 = new int[7];
        nArray23[0] = 1;
        nArray23[2] = 4;
        nArray23[3] = 5;
        nArray23[4] = 6;
        nArray23[5] = 6;
        nArray23[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(202), nArray23);
        int[] nArray24 = new int[7];
        nArray24[0] = 1;
        nArray24[2] = 4;
        nArray24[3] = 5;
        nArray24[4] = 6;
        nArray24[5] = 6;
        nArray24[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(201), nArray24);
        int[] nArray25 = new int[7];
        nArray25[0] = 1;
        nArray25[2] = 4;
        nArray25[3] = 5;
        nArray25[4] = 6;
        nArray25[5] = 6;
        nArray25[6] = 10;
        verificationMap.put(String.valueOf(String.valueOf(7)) + String.valueOf(200), nArray25);
        int[] nArray26 = new int[13];
        nArray26[0] = 1;
        nArray26[2] = 2;
        nArray26[3] = 3;
        nArray26[4] = 4;
        nArray26[5] = 5;
        nArray26[6] = 6;
        nArray26[7] = 6;
        nArray26[8] = 8;
        nArray26[9] = 9;
        nArray26[10] = 10;
        nArray26[11] = 11;
        nArray26[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(205), nArray26);
        int[] nArray27 = new int[13];
        nArray27[0] = 1;
        nArray27[2] = 2;
        nArray27[3] = 3;
        nArray27[4] = 4;
        nArray27[5] = 5;
        nArray27[6] = 6;
        nArray27[7] = 6;
        nArray27[8] = 8;
        nArray27[9] = 9;
        nArray27[10] = 10;
        nArray27[11] = 11;
        nArray27[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(204), nArray27);
        int[] nArray28 = new int[13];
        nArray28[0] = 1;
        nArray28[2] = 2;
        nArray28[3] = 3;
        nArray28[4] = 4;
        nArray28[5] = 5;
        nArray28[6] = 6;
        nArray28[7] = 6;
        nArray28[8] = 8;
        nArray28[9] = 9;
        nArray28[10] = 10;
        nArray28[11] = 11;
        nArray28[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(203), nArray28);
        int[] nArray29 = new int[13];
        nArray29[0] = 1;
        nArray29[2] = 2;
        nArray29[3] = 3;
        nArray29[4] = 4;
        nArray29[5] = 5;
        nArray29[6] = 6;
        nArray29[7] = 6;
        nArray29[8] = 8;
        nArray29[9] = 9;
        nArray29[10] = 10;
        nArray29[11] = 11;
        nArray29[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(212), nArray29);
        int[] nArray30 = new int[13];
        nArray30[0] = 1;
        nArray30[2] = 2;
        nArray30[3] = 3;
        nArray30[4] = 4;
        nArray30[5] = 5;
        nArray30[6] = 6;
        nArray30[7] = 6;
        nArray30[8] = 8;
        nArray30[9] = 9;
        nArray30[10] = 10;
        nArray30[11] = 11;
        nArray30[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(202), nArray30);
        int[] nArray31 = new int[13];
        nArray31[0] = 1;
        nArray31[2] = 2;
        nArray31[3] = 3;
        nArray31[4] = 4;
        nArray31[5] = 5;
        nArray31[6] = 6;
        nArray31[7] = 6;
        nArray31[8] = 8;
        nArray31[9] = 9;
        nArray31[10] = 10;
        nArray31[11] = 11;
        nArray31[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(201), nArray31);
        int[] nArray32 = new int[13];
        nArray32[0] = 1;
        nArray32[2] = 2;
        nArray32[3] = 3;
        nArray32[4] = 4;
        nArray32[5] = 5;
        nArray32[6] = 6;
        nArray32[7] = 6;
        nArray32[8] = 8;
        nArray32[9] = 9;
        nArray32[10] = 10;
        nArray32[11] = 11;
        nArray32[12] = 12;
        verificationMap.put(String.valueOf(String.valueOf(8)) + String.valueOf(200), nArray32);
    }

    public MATTableFilter(IMATTableViewer viewer, List<Integer> dataColumns, String inputText, boolean internal, boolean isQuickFilter) {
        this.viewer = viewer;
        this.setFilteredColumns(dataColumns);
        this.internal = internal;
        this.inputText = inputText;
        this.toolTip = String.format(TIPFORMAT, this.inputText);
        this.isQuickFilter = isQuickFilter;
        if (inputText == null || inputText.trim().isEmpty()) {
            this.operatorType = 0;
            return;
        }
        this.getInputTextOperatorType(inputText);
        this.inputTextType = this.getInputTextType();
        String regex = this.composeRegex(this.expression.toUpperCase());
        this.pattern = Pattern.compile(regex);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (viewer != this.viewer) {
            throw new RuntimeException("Filtering applied for a different table than this filter was created for.");
        }
        if (this.operatorType == 0) {
            return true;
        }
        MATTableRow row = (MATTableRow)element;
        boolean atLeastOneMatchFound = false;
        int i = 0;
        while (i < this.filteredColumns.size()) {
            int columnIndex = this.filteredColumns.get(i);
            if (this.doesTheCellContentMatch(row, columnIndex)) {
                atLeastOneMatchFound = true;
            }
            ++i;
        }
        return atLeastOneMatchFound;
    }

    final boolean doesTheCellContentMatch(MATTableRow row, int columnIndex) {
        Object item = row.getObject(columnIndex);
        int cellType = this.viewer.getColumnType(columnIndex);
        String cellText = row.getText(columnIndex);
        switch (this.inputTextType) {
            case 6: 
            case 7: 
            case 8: {
                if (this.operatorType == 212) {
                    return !this.pattern.matcher(cellText.toUpperCase()).matches();
                }
                return this.pattern.matcher(cellText.toUpperCase()).matches();
            }
            case 1: {
                if (cellType == 10) {
                    if (cellText == null || cellText.trim().isEmpty()) {
                        cellText = "0";
                    }
                    Double d = new Double(Integer.parseInt(cellText, 16));
                    return this.compareByOperator(this.inputNumberHex, d);
                }
                if (this.operatorType == 212) {
                    return !this.pattern.matcher(cellText.toUpperCase()).matches();
                }
                return this.pattern.matcher(cellText.toUpperCase()).matches();
            }
            case 2: {
                if (cellType == 4) {
                    return this.compareByOperator((Comparable)((Object)this.expression), (Comparable)((Object)cellText));
                }
                if (cellType == 1 || cellType == 0) {
                    return this.pattern.matcher(cellText.toUpperCase()).matches();
                }
                return false;
            }
            case 3: {
                if (cellType == 6) {
                    if (!cellText.isEmpty()) {
                        if (cellText.length() == 5) {
                            return this.compareByOperator((Comparable)((Object)this.expression), (Comparable)((Object)(String.valueOf(cellText) + ":00.0")));
                        }
                        if (cellText.length() == 8) {
                            return this.compareByOperator((Comparable)((Object)this.expression), (Comparable)((Object)(String.valueOf(cellText) + ".0")));
                        }
                        return this.compareByOperator((Comparable)((Object)this.expression), (Comparable)((Object)cellText));
                    }
                } else {
                    if (cellType == 1 || cellType == 0) {
                        return this.pattern.matcher(cellText.toUpperCase()).matches();
                    }
                    return false;
                }
            }
            case 4: {
                if (cellType == 10 && this.inputNumberHex != null) {
                    if (cellText == null || cellText.trim().isEmpty()) {
                        cellText = "0";
                    }
                    Double d = new Double(Integer.parseInt(cellText, 16));
                    return this.compareByOperator(this.inputNumberHex, d);
                }
                if (item instanceof Number) {
                    BigDecimal bd = new BigDecimal(((Number)row.getObject(columnIndex)).doubleValue());
                    bd = cellType == 11 ? bd.setScale(6, 4) : bd.setScale(2, 4);
                    Double d = bd.doubleValue();
                    return this.compareByOperator(this.inputNumber, d);
                }
                try {
                    String cellTextEdited = decimalSeparator == "." ? cellText : cellText.replace(decimalSeparator, ".");
                    cellTextEdited = groupingSeparator == "." ? cellTextEdited : cellTextEdited.replace(groupingSeparator, "");
                    Double d = Double.valueOf(cellTextEdited);
                    return this.compareByOperator(this.inputNumber, d);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.operatorType != 205) break;
                    return this.pattern.matcher(cellText.toUpperCase()).matches();
                }
            }
        }
        return false;
    }

    private boolean compareByOperator(Comparable comp1, Comparable comp2) {
        int result = comp1.compareTo(comp2);
        switch (this.operatorType) {
            case 200: {
                return result < 0;
            }
            case 201: {
                return result <= 0;
            }
            case 204: {
                return result > 0;
            }
            case 203: {
                return result >= 0;
            }
            case 202: {
                return result == 0;
            }
            case 212: {
                return result != 0;
            }
            case 205: {
                return result == 0;
            }
        }
        return false;
    }

    public boolean isFilterValidForTheColumnList() {
        int[] validColumnsForInputType = verificationMap.get(String.valueOf(String.valueOf(this.inputTextType)) + String.valueOf(this.operatorType));
        boolean atLeastOneValidColumnFound = false;
        ArrayList<Integer> temporaryFilteredColumns = new ArrayList<Integer>();
        int i = 0;
        while (i < this.filteredColumns.size()) {
            atLeastOneValidColumnFound = false;
            int j = 0;
            while (j < validColumnsForInputType.length) {
                if (this.viewer.getColumnType(this.filteredColumns.get(i)) == validColumnsForInputType[j]) {
                    atLeastOneValidColumnFound = true;
                }
                ++j;
            }
            if (atLeastOneValidColumnFound) {
                temporaryFilteredColumns.add(this.filteredColumns.get(i));
            }
            ++i;
        }
        if (temporaryFilteredColumns.isEmpty()) {
            this.valid = false;
            if (!this.isQuickFilter) {
                String columnNamesSequence = "";
                int i2 = 0;
                while (i2 < this.filteredColumns.size()) {
                    String columnName = this.viewer.getColumnName(this.filteredColumns.get(i2));
                    columnNamesSequence = String.valueOf(columnNamesSequence) + (i2 == 0 ? columnName : ", " + columnName);
                    ++i2;
                }
                String plural = this.filteredColumns.size() > 1 ? "s" : "";
                MessageDialog.openWarning(null, (String)"Invalid data format", (String)(String.valueOf(this.inputText) + " is not a valid value for " + columnNamesSequence + " column" + plural + "."));
            }
        } else {
            this.valid = true;
        }
        this.filteredColumns = temporaryFilteredColumns;
        return this.valid;
    }

    private int getInputTextOperatorType(String inputText) {
        if ((inputText = inputText.trim()) == "") {
            this.expression = "";
            return 0;
        }
        this.operatorType = 205;
        if (inputText.startsWith(">=") || inputText.startsWith("=>")) {
            this.operatorType = 201;
            this.operatorText = inputText.substring(0, 2);
            this.expression = inputText.substring(2);
        } else if (inputText.startsWith("<=") || inputText.startsWith("=<")) {
            this.operatorType = 203;
            this.operatorText = inputText.substring(0, 2);
            this.expression = inputText.substring(2);
        } else if (inputText.startsWith("<>") || inputText.startsWith("!=")) {
            this.operatorType = 212;
            this.operatorText = inputText.substring(0, 2);
            this.expression = inputText.substring(2);
        } else if (inputText.startsWith(">")) {
            this.operatorType = 200;
            this.operatorText = inputText.substring(0, 1);
            this.expression = inputText.substring(1);
        } else if (inputText.startsWith("<")) {
            this.operatorType = 204;
            this.operatorText = inputText.substring(0, 1);
            this.expression = inputText.substring(1);
        } else if (inputText.startsWith("=")) {
            this.operatorType = 202;
            this.operatorText = inputText.substring(0, 1);
            this.expression = inputText.substring(1);
        } else if (inputText.startsWith("~") || inputText.startsWith("!") || inputText.startsWith("\u00a2") || inputText.startsWith("\u00ac")) {
            this.operatorType = 212;
            this.operatorText = inputText.substring(0, 1);
            this.expression = inputText.substring(1);
        } else {
            this.operatorType = 205;
            this.expression = inputText;
        }
        this.expression = this.expression.trim();
        return 0;
    }

    private int getInputTextType() {
        try {
            Date date;
            this.inputDate = date = Constants.DATE_FORMAT.parse(this.expression);
            this.expression = Constants.DATE_FORMAT.format(date);
            return 2;
        }
        catch (Exception exception) {
            try {
                Date date;
                this.inputDate = date = Constants.TIME_FORMAT_LONG.parse(this.expression);
                this.expression = Constants.TIME_FORMAT_LONG.format(date);
                return 3;
            }
            catch (Exception exception2) {
                try {
                    Date date;
                    this.inputDate = date = Constants.TIME_FORMAT.parse(this.expression);
                    this.expression = Constants.TIME_FORMAT_LONG.format(date);
                    return 3;
                }
                catch (Exception exception3) {
                    try {
                        Date date;
                        this.inputDate = date = Constants.TIME_FORMAT_SHORT.parse(this.expression);
                        this.expression = Constants.TIME_FORMAT_LONG.format(date);
                        return 3;
                    }
                    catch (Exception exception4) {
                        try {
                            String inputTextEdited = decimalSeparator == "." ? this.expression : this.expression.replace(decimalSeparator, ".");
                            inputTextEdited = groupingSeparator == "." ? inputTextEdited : inputTextEdited.replace(groupingSeparator, "");
                            inputTextEdited = inputTextEdited.replace(" ", "");
                            Float.valueOf(inputTextEdited);
                            Double inputNumberObject = new Double(inputTextEdited);
                            this.inputNumber = (double)inputNumberObject;
                            try {
                                this.inputNumberHex = Integer.valueOf(inputTextEdited, 16).doubleValue();
                            }
                            catch (NumberFormatException numberFormatException) {}
                            return 4;
                        }
                        catch (Exception exception5) {
                            try {
                                String inputTextEdited = decimalSeparator == "." ? this.expression : this.expression.replace(decimalSeparator, ".");
                                inputTextEdited = groupingSeparator == "." ? inputTextEdited : inputTextEdited.replace(groupingSeparator, "");
                                inputTextEdited = inputTextEdited.replace(" ", "");
                                Float.valueOf(inputTextEdited);
                                return 5;
                            }
                            catch (Exception exception6) {
                                if (this.expression.startsWith("0x") || this.expression.matches("-?[0-9a-fA-F]+")) {
                                    try {
                                        this.inputNumberHex = Integer.valueOf(this.expression, 16).doubleValue();
                                        if (this.operatorType != 205 && this.operatorType != 212 && this.operatorType != 202) {
                                            this.expression = this.inputText.trim();
                                        }
                                        return 1;
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                if (this.operatorType != 205 && this.operatorType != 212 && this.operatorType != 202) {
                                    this.expression = this.inputText.trim();
                                }
                                if (this.inputText.matches(".*[N,n][\b,\\\\,/]?[A,a].*")) {
                                    return 8;
                                }
                                if (this.inputText.matches(".*[?%*].*")) {
                                    return 7;
                                }
                                return 6;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isQuickFilter() {
        return this.isQuickFilter;
    }

    private String composeRegex(String expression) {
        StringBuilder regex = new StringBuilder(expression.length() + 20);
        regex.append(expression);
        Object[][] objectArrayArray = new Object[][]{{"\\", "\\\\"}, {".", "\\."}, {"[", "\\["}, {"^", "\\^"}, {"|", "\\|"}, {"+", "\\+"}, {"$", "\\$"}, {"*", ".*"}, {"%", "[0-9]"}, {"?", "."}};
        int n = objectArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] item = objectArrayArray[n2];
            int ix = 0;
            while ((ix = regex.indexOf((String)item[0], ix)) != -1) {
                int repl_start = ix;
                int repl_end = repl_start + ((String)item[0]).length();
                regex.replace(repl_start, repl_end, (String)item[1]);
                ix = repl_end + ((String)item[1]).length() - 1;
            }
            ++n2;
        }
        expression = "^" + regex.toString() + ".*$";
        this.log.log(Level.FINE, "Generated Regular Expression {0} from {1}", new Object[]{expression, this.inputText});
        return expression;
    }

    public int getoperatorType() {
        return this.operatorType;
    }

    public List<Integer> getDataColumns() {
        return this.filteredColumns;
    }

    public String getText() {
        if (this.operatorType == 0) {
            return "";
        }
        return this.inputText;
    }

    public String toString() {
        return this.operatorType == 0 ? "** no filter **" : this.inputText;
    }

    public boolean isFilteredBySameColumns(List<Integer> filteredColumns) {
        if (this.getFilteredColumns().size() == filteredColumns.size()) {
            int i = 0;
            while (i < filteredColumns.size()) {
                if (!this.getFilteredColumns().get(i).equals(filteredColumns.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MATTableFilter other = (MATTableFilter)((Object)obj);
        if (this.filteredColumns.size() == other.filteredColumns.size()) {
            int i = 0;
            while (i < this.filteredColumns.size()) {
                if (this.filteredColumns.get(i) != other.filteredColumns.get(i)) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        if (this.isQuickFilter != other.isQuickFilter) {
            return false;
        }
        if (this.operatorType != other.operatorType) {
            return false;
        }
        return this.inputText.equals(other.inputText);
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<Integer> getFilteredColumns() {
        return this.filteredColumns;
    }

    public void setFilteredColumns(List<Integer> filteredColumns) {
        this.filteredColumns = filteredColumns;
    }
}

