/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.ui.wizards.LayoutMemberWizardPage;
import com.ca.filemaster.ui.wizards.MemberWizardOptionsPage;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class LayoutMemberWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private String memberName;
    private String dataSetName;
    private String serverName;
    private LayoutMemberWizardPage page;
    private boolean isSingleMember;
    private ArrayList<String> memberList;
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private FileMasterMember member;
    private static final FMServerTreeModel model = FMServerTreeModel.getInstance();

    public LayoutMemberWizard(FileMasterMember member, FileMasterDataset dataSet, FileMasterServer server, boolean isSingleMember, ArrayList<String> memberList) {
        this(member, dataSet, server, isSingleMember);
        this.memberList = memberList;
    }

    public LayoutMemberWizard(FileMasterMember member, FileMasterDataset dataSet, FileMasterServer server, boolean isSingleMember) {
        this.setWindowTitle("Select Member");
        this.member = member;
        this.dataSet = dataSet;
        this.server = server;
        this.isSingleMember = isSingleMember;
    }

    public LayoutMemberWizard(String memberName, String dataSetName, String serverName, boolean isSingleMember) {
        this.setWindowTitle("Select Member");
        this.memberName = memberName;
        this.dataSetName = dataSetName;
        this.serverName = serverName;
        this.isSingleMember = isSingleMember;
    }

    public LayoutMemberWizard(String dataSetName, String serverName, boolean isSingleMember) {
        this.setWindowTitle("Select Member");
        this.dataSetName = dataSetName;
        this.serverName = serverName;
        this.isSingleMember = isSingleMember;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TT_TreeItem datasetItem;
        Object object = selection.getFirstElement();
        TT_TreeItem treeItem = model.findObject(object);
        if (treeItem != null && (datasetItem = treeItem.getParent(Profile.class)) != null) {
            treeItem = datasetItem;
        }
        if (treeItem != null) {
            FileMasterDataset value = (FileMasterDataset)((Object)treeItem.getAdapter(FileMasterDataset.class));
            if (value != null) {
                this.dataSet = value;
                this.server = (FileMasterServer)treeItem.getServer();
            } else if (treeItem.getAdapter(FileMasterServer.class) != null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getAdapter(FileMasterMember.class) != null) {
                this.server = (FileMasterServer)treeItem.getServer();
                this.dataSet = (FileMasterDataset)((Object)treeItem.getAdapter(FileMasterDataset.class));
                this.member = (FileMasterMember)((Object)treeItem.getAdapter(FileMasterMember.class));
            }
        }
        if (treeItem == null) {
            TT_TreeItem[] AllServerItem;
            TT_TreeItem[] tT_TreeItemArray = AllServerItem = model.getServers();
            int n = AllServerItem.length;
            int n2 = 0;
            while (n2 < n) {
                TT_TreeItem item = tT_TreeItemArray[n2];
                String serverStatus = item.getServer().getStatusText();
                if (serverStatus == "Active") {
                    this.server = (FileMasterServer)item.getServer();
                    break;
                }
                ++n2;
            }
        }
    }

    public void addPages() {
        String pageName = "wizardPage";
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog && ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof MemberWizardOptionsPage) {
            pageName = "MemberWizardOptions";
        }
        this.page = this.memberList != null ? new LayoutMemberWizardPage(pageName, this.member, this.dataSet, this.server, this.isSingleMember, this.memberList) : new LayoutMemberWizardPage(pageName, this.member, this.dataSet, this.server, this.isSingleMember);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        return this.page.doFinish();
    }
}

