/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.ui.wizards.AddServerPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddServerWizard
extends Wizard
implements INewWizard {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private AddServerPage page;
    private FileMasterServer server;
    private boolean newItem = true;

    public AddServerWizard() {
        this.setForcePreviousAndNextButtons(false);
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle("Update Server Settings");
    }

    public AddServerWizard(FileMasterServer server) {
        this();
        this.server = server;
    }

    public boolean performFinish() {
        return this.page.performUpdate();
    }

    public void addPages() {
        String title = this.newItem ? "New Server" : String.format("Update %s", this.server.toString());
        this.page = new AddServerPage("", title, null);
        this.page.SetServer(this.server);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public Image getDefaultPageImage() {
        return super.getDefaultPageImage();
    }

    public void setNewItem(boolean newItem) {
        this.newItem = newItem;
        if (newItem) {
            this.server = null;
            this.setWindowTitle("New Server Definition");
        } else {
            this.setWindowTitle("Update Server Definition");
        }
    }

    public boolean isNewItem() {
        return this.newItem;
    }
}

