/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunSetODOChange
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String uuid;
    private boolean canRetry = true;
    private boolean confirmODOChange;
    private static final String SERVICE = "filemaster/fmp";

    public RunSetODOChange(FileMasterServer server, String uuid, boolean confirmODOChange) {
        this.server = server;
        this.uuid = uuid;
        this.confirmODOChange = confirmODOChange;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = connection.connect("flip", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                Element reqElement = this.xml.getRoot();
                if (reqElement != null) {
                    if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                        if (this.canRetry) {
                            this.canRetry = false;
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                        FileMasterSession.removeSession(this.server, this.uuid);
                    }
                    if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                        FileMasterSession.removeSession(this.server, this.uuid);
                        this.run();
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><MFResponse GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<EditODOChangeResponse response=\"" + (this.confirmODOChange ? "G" : "C") + "\"/>" + "</MFResponse>";
        return CommonMFCalls.createXMLDoc(command);
    }
}

