/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class JclEditDialog
extends TrayDialog {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected StyledText editor;
    protected String jobCardStream;
    protected boolean readonly = false;
    protected boolean backspace = false;
    protected boolean submit = false;

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public JclEditDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public JclEditDialog(Shell parentShell) {
        super(parentShell);
    }

    public JclEditDialog(Shell shell, String items) {
        super(shell);
        this.jobCardStream = items;
        this.setShellStyle(66672);
    }

    public void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Update Job Card Information");
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        Composite composite = (Composite)super.createDialogArea(parent);
        int style = 2816;
        if (this.readonly) {
            style |= 8;
        }
        this.editor = new StyledText(composite, style);
        GridData gridData = new GridData(4, 4, true, true, 2, 3);
        gridData.heightHint = 178;
        gridData.widthHint = 587;
        this.editor.setLayoutData((Object)gridData);
        this.editor.setText(this.jobCardStream);
        this.editor.setFont(JFaceResources.getTextFont());
        this.editor.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int currentline = JclEditDialog.this.editor.getLineAtOffset(((StyledText)e.widget).getCaretOffset());
                ((StyledText)e.widget).addVerifyKeyListener(new VerifyKeyListener(){

                    public void verifyKey(VerifyEvent event) {
                        int currentline = (this).JclEditDialog.this.editor.getLineAtOffset(((StyledText)event.widget).getCaretOffset());
                        if (!((this).JclEditDialog.this.editor.getLine(currentline).length() + 1 <= 73 && (this).JclEditDialog.this.editor.getLine(currentline).length() != 0 && (this).JclEditDialog.this.editor.getLineCount() <= 4 || event.character != '\b' && event.character != '\u007f' && (this).JclEditDialog.this.editor.getSelectionText().length() <= 0)) {
                            (this).JclEditDialog.this.backspace = true;
                        }
                    }
                });
                if (JclEditDialog.this.editor.getLineCount() > 4 && !JclEditDialog.this.backspace) {
                    e.doit = false;
                } else if (JclEditDialog.this.backspace || JclEditDialog.this.editor.getSelectionText().length() == 73) {
                    e.doit = true;
                    JclEditDialog.this.backspace = false;
                } else if (currentline == 3 && JclEditDialog.this.editor.getLine(currentline).length() + 1 > 73) {
                    e.doit = false;
                } else if (e.text.equals("\r\n") && JclEditDialog.this.editor.getLine(currentline).length() + 1 > 73) {
                    e.doit = true;
                } else if (JclEditDialog.this.editor.getLine(currentline).length() + 1 > 73) {
                    e.doit = false;
                } else if (e.text.length() + JclEditDialog.this.editor.getLine(currentline).length() > 73) {
                    e.doit = false;
                }
                if (e.doit) {
                    e.text = e.text.toUpperCase();
                }
                if (!e.doit) {
                    return;
                }
                if (e.text.length() == 0) {
                    return;
                }
                e.text = e.text.toUpperCase();
            }
        });
        return composite;
    }

    protected void okPressed() {
        this.jobCardStream = this.editor.getText();
        super.okPressed();
    }

    public String getJobCardStream() {
        return this.jobCardStream.trim();
    }

    public void setJobCardStream(String jobCardStream) {
        this.jobCardStream = jobCardStream;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(boolean submit) {
        this.submit = submit;
    }
}

