/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.wizards;

import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.wizards.ServerWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ServerWizard
extends Wizard
implements INewWizard {
    static String cacopyright = "Copyright \u00a9 2011 CA";
    private ServerWizardPage page;
    private TTServer server;
    private boolean newItem = true;

    public ServerWizard() {
        this.setForcePreviousAndNextButtons(false);
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle("Update Server Settings");
    }

    public ServerWizard(TTServer server) {
        this();
        this.server = server;
    }

    public boolean performFinish() {
        return this.page.performUpdate();
    }

    public void addPages() {
        String title = this.newItem ? "New Server" : String.format("Update %s", this.server.toString());
        this.page = new ServerWizardPage("", title, null);
        this.page.SetServer(this.server);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public Image getDefaultPageImage() {
        return super.getDefaultPageImage();
    }

    public void setNewItem(boolean newItem) {
        this.newItem = newItem;
        if (newItem) {
            this.server = null;
            this.setWindowTitle("New Server Definition");
        } else {
            this.setWindowTitle("Update Server Definition");
        }
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public TTServer getServer() {
        return this.page == null ? this.server : this.page.getServer();
    }
}

