/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.views.datawatch;

import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.ui.views.datawatch.HexColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.PropertiesColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.ValueColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.VariableColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.WatchDataContentProvider;
import com.ca.testingtools.ui.views.datawatch.WatchItemDoubleClickListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class WatchData
extends ViewPart
implements IPropertyChangeListener {
    static String cacopyright = "Copyright (c) 2011 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final String ID = "com.ca.testingtools.ui.views.watchdataview";
    public static final String watchID = String.valueOf(WatchData.class.getName()) + ".watchID";
    private static final String CONTEXT_HELP_ID = "com.ca.testingtools.help.datawatchview";
    private static final String Variable_Column = "Name";
    private static final String Value_Column = "Value";
    private static final String Hex_Column = "Hex";
    private static final String Properties_Column = "Description";
    public static final int VARIABLE = 0;
    public static final int VALUE = 1;
    public static final int HEXVALUE = 2;
    public static final int PROPERTIES = 3;
    protected ArrayList<IWatchData> data = new ArrayList();
    protected Control control;
    protected TreeViewer viewer;

    public void createPartControl(Composite parent) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("com.ca.testingtools.context");
        this.viewer = new TreeViewer(parent, 68354);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        Tree tree = this.viewer.getTree();
        this.viewer.getControl().setFont(JFaceResources.getTextFont());
        String[] titles = new String[]{Variable_Column, Value_Column, Hex_Column, Properties_Column};
        int[] styles = new int[]{16384, 16384, 16384, 16384};
        int[] bounds = new int[]{150, 200, 600, 300};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] order = nArray;
        TreeEditor editor = new TreeEditor(tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        int columnIndex = 0;
        while (columnIndex < titles.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new VariableColumnlabelProvider());
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new ValueColumnlabelProvider());
                    break;
                }
                case 2: {
                    column.setLabelProvider((CellLabelProvider)new HexColumnlabelProvider());
                    break;
                }
                case 3: {
                    column.setLabelProvider((CellLabelProvider)new PropertiesColumnlabelProvider());
                }
            }
            column.getColumn().setText(titles[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.getColumn().setData((Object)order[columnIndex]);
            column.getColumn().setWidth(bounds[columnIndex]);
            ++columnIndex;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new WatchDataContentProvider());
        this.viewer.setColumnProperties(titles);
        this.hookDoubleClickAction();
        this.control = this.viewer.getControl();
        this.hookContextMenu();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new WatchItemDoubleClickListener());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void addContent(IWatchData[] content) {
        IWatchData child;
        boolean changed = false;
        IWatchData[] iWatchDataArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            child = iWatchDataArray[n2];
            if (child != null && !this.data.contains(child)) {
                this.data.add(child);
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            this.refresh();
        }
        iWatchDataArray = content;
        n = content.length;
        n2 = 0;
        while (n2 < n) {
            child = iWatchDataArray[n2];
            this.viewer.expandToLevel((Object)child, -1);
            ++n2;
        }
    }

    public void refresh() {
        this.viewer.setInput((Object)this.data.toArray(new IWatchData[this.data.size()]));
    }

    public boolean removeContent(IWatchData content) {
        return this.data.remove(content);
    }

    public boolean isTop(IWatchData item) {
        int index = this.data.indexOf(item);
        return index == 0;
    }

    public boolean isBottom(IWatchData item) {
        int index = this.data.indexOf(item);
        return index == this.data.size() - 1;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public int reposition(IWatchData item, boolean up) {
        int newindex;
        int index = this.data.indexOf(item);
        if (index == -1) {
            return index;
        }
        if (up && index == 0) {
            return -1;
        }
        if (!up && index == this.data.size() - 1) {
            return -1;
        }
        int n = newindex = up ? index - 1 : index + 1;
        if (up) {
            IWatchData prevItem = this.data.get(index - 1);
            newindex = index - 1;
            this.data.remove(newindex);
            this.data.add(newindex, item);
            this.data.remove(index);
            this.data.add(index, prevItem);
        } else if (!up) {
            IWatchData nextItem = this.data.get(index + 1);
            newindex = index + 1;
            this.data.remove(nextItem);
            this.data.add(index, nextItem);
            this.data.remove(item);
            this.data.add(newindex, item);
        }
        this.refresh();
        return newindex;
    }

    public void setFocus() {
        if (this.control != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(new Object[0]));
            this.control.setFocus();
        }
    }

    public void dispose() {
        if (this.viewer != null) {
            IContentProvider provider = this.viewer.getContentProvider();
            if (provider != null) {
                provider.dispose();
            }
            this.viewer.getControl().dispose();
        }
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        Integer id;
        String property = event.getProperty();
        if (!watchID.equals(property)) {
            return;
        }
        if (event.getOldValue() == null) {
            return;
        }
        Object obj = event.getOldValue();
        if (obj instanceof Integer && (id = (Integer)obj) != 0) {
            Iterator<IWatchData> it = this.data.iterator();
            while (it.hasNext()) {
                IWatchData item = it.next();
                if (item.getOwner() != id.intValue()) continue;
                it.remove();
            }
            this.refresh();
        }
    }
}

