/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.logging;

import com.ca.testingtools.logging.EclipseFormatter;
import com.ca.testingtools.logging.EclipseHandler;
import java.util.Dictionary;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class Logging {
    static final String cacopyright = "Copyright \u00a9 2011 CA";

    private Logging() {
    }

    public static void setLogging(Bundle bundle, boolean announce) {
        String id = bundle.getSymbolicName();
        EclipseFormatter formater = new EclipseFormatter();
        Logger log = Logger.getLogger(id);
        EclipseHandler newHandler = new EclipseHandler(bundle);
        newHandler.setFormatter((Formatter)((Object)formater));
        log.addHandler(newHandler);
        log.setUseParentHandlers(false);
        log.setLevel(Level.ALL);
        if (announce) {
            Dictionary dict = bundle.getHeaders();
            String build = (String)dict.get("Bundle-Build");
            build = build == null || build.equals("--BUILD--") ? "" : String.format(" Build %s", build);
            String message = String.format("Logging for %s %s%s started", id, bundle.getVersion().toString(), build);
            ILog elog = Platform.getLog((Bundle)bundle);
            Status status = new Status(1, bundle.getSymbolicName(), 0, message, null);
            elog.log((IStatus)status);
        }
    }
}

