/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.handlers;

import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class DeleteHandler
extends AbstractHandler
implements IElementUpdater {
    static String cacopyright = "Copyright (c) 2011 CA";
    private ServerTreeModel model = ServerTreeModel.getInstance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String question;
        Object result;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection.size() == 0) {
            return null;
        }
        Object object = selection.getFirstElement();
        if (!(object instanceof TT_TreeItem)) {
            return null;
        }
        Command command = event.getCommand();
        String id = command.getId();
        String deleteItem = null;
        Class testClass = null;
        ArrayList<Class<Dataset>> allowedClasses = new ArrayList<Class<Dataset>>(3);
        allowedClasses.add(Profile.class);
        allowedClasses.add(TTServer.class);
        allowedClasses.add(Dataset.class);
        if (id.equals("com.ca.testingtools.commands.deleteprofile")) {
            testClass = Profile.class;
            deleteItem = "Profile";
        } else if (id.equals("com.ca.testingtools.commands.deleteserver")) {
            testClass = TTServer.class;
            deleteItem = "Server";
        } else if (id.equals("com.ca.testingtools.commands.deletedataset")) {
            testClass = Dataset.class;
            deleteItem = "Dataset";
        } else if (id.equals("com.ca.testingtools.commands.delete") || id.equals("org.eclipse.ui.edit.delete")) {
            TT_TreeItem item = (TT_TreeItem)object;
            for (Class clazz : allowedClasses) {
                result = item.getAdapter(clazz);
                if (result == null) continue;
                testClass = clazz;
                if (testClass.equals(TTServer.class)) {
                    deleteItem = "Server";
                    break;
                }
                deleteItem = testClass.getSimpleName();
                break;
            }
        }
        if (testClass == null) {
            return null;
        }
        ArrayList<TT_TreeItem> list = new ArrayList<TT_TreeItem>(selection.size());
        for (Object item : selection) {
            if (!(item instanceof TT_TreeItem) || testClass == null || (result = ((TT_TreeItem)item).getAdapter(testClass)) == null) continue;
            list.add((TT_TreeItem)item);
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            question = String.format("Do you want to delete these %d items", selection.size());
        } else {
            Object target = list.get(0);
            question = String.format("Do you want to delete %s:%s ", deleteItem, target.toString());
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        String title = String.format("Confirm %s Delete", deleteItem);
        if (!MessageDialog.openQuestion((Shell)shell, (String)title, (String)question)) {
            return null;
        }
        for (TT_TreeItem value : list) {
            this.model.removeItem(value);
        }
        this.model.save();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

