/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.core.ITreeType;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.TTServer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TT_TreeItem
implements IAdaptable,
ITreeType {
    static final String cacopyright = "Copyright (c) 2011 CA";
    private String name;
    private boolean grayed = false;
    private boolean checked = false;
    private Element element = null;
    private ITreeWrappedItem value = null;
    private TT_TreeItem parent;
    private ArrayList<TT_TreeItem> children = new ArrayList();

    public TT_TreeItem(Element element, ITreeWrappedItem value) {
        this.value = value;
        this.element = element;
        String string = this.name = value == null ? "null" : value.toString();
        if (value instanceof ITreeWrappedItem) {
            ITreeWrappedItem child = value;
            child.setParent(this);
        }
        if (element == null && value instanceof Element) {
            element = (Element)((Object)value);
        }
        if (element != null) {
            String result = element.getAttribute("grayed");
            this.grayed = Boolean.parseBoolean(result);
            result = element.getAttribute("checked");
            this.checked = Boolean.parseBoolean(result);
        }
    }

    public TT_TreeItem(Element element, ITreeWrappedItem value, String name) {
        this(element, value);
        this.name = name;
    }

    public TTServer getServer() {
        TT_TreeItem root = this.getParent(TTServer.class);
        ITreeWrappedItem object = root == null ? null : root.getValue();
        return object instanceof TTServer ? (TTServer)object : null;
    }

    public TT_TreeItem getParent(Class<?> testClass) {
        if (testClass.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (this.value != null && testClass.isAssignableFrom(this.value.getClass())) {
            return this;
        }
        return this.parent != null ? this.parent.getParent(testClass) : null;
    }

    public String getName() {
        if (this.value instanceof ITreeWrappedItem) {
            return this.value.getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.value == null ? super.toString() : this.value.toString();
    }

    public String toString() {
        String string = this.getName();
        return string == null || string.isEmpty() ? "No Name" : string;
    }

    public void addListener(IPropertyChangeListener listener) {
        if (this.value instanceof PropertyChangeManager) {
            ((PropertyChangeManager)((Object)this.value)).addPropertyChangeListener(listener);
        }
    }

    public void removeListener(IPropertyChangeListener listener) {
        if (this.value instanceof PropertyChangeManager) {
            ((PropertyChangeManager)((Object)this.value)).removePropertyChangeListener(listener);
        }
    }

    public boolean addChild(TT_TreeItem child) {
        if (this.children.contains(child)) {
            return false;
        }
        child.setParent(this);
        this.children.add(child);
        return true;
    }

    private void setParent(TT_TreeItem parent) {
        this.parent = parent;
    }

    public void delete() {
        Node parentNode;
        Iterator<TT_TreeItem> it = this.children.iterator();
        while (it.hasNext()) {
            TT_TreeItem child = it.next();
            child.delete();
            child.setParent(null);
            it.remove();
        }
        if (this.element != null && (parentNode = this.element.getParentNode()) != null) {
            parentNode.removeChild(this.element);
        }
        this.element = null;
        this.children.clear();
        this.value = null;
    }

    public boolean removeChild(TT_TreeItem child) {
        boolean result = this.children.remove(child);
        if (result) {
            child.setParent(null);
        }
        return result;
    }

    public TT_TreeItem findValue(Object object) {
        if (object == null) {
            return null;
        }
        if (this.equals(object)) {
            return this;
        }
        for (TT_TreeItem child : this.children) {
            TT_TreeItem item = child.findValue(object);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (this.value instanceof IAdaptable && (result = this.value.getAdapter(adapter)) != null) {
            return result;
        }
        if (this.value != null && adapter.isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TT_TreeItem) {
            return false;
        }
        if (other instanceof ITreeWrappedItem) {
            ITreeWrappedItem otherItem = (ITreeWrappedItem)other;
            return otherItem == null ? null : Boolean.valueOf(otherItem.equals(this.value));
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGrayed() {
        return this.grayed;
    }

    public void setGrayed(boolean greyed) {
        this.grayed = greyed;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.setGrayed(false);
        for (TT_TreeItem item : this.children) {
            item.setChecked(checked);
        }
        this.checkPath(this.parent, checked, false);
        if (this.element != null) {
            this.element.setAttribute("checked", Boolean.toString(checked));
            this.element.setAttribute("grayed", Boolean.toString(this.grayed));
        }
    }

    private void checkPath(TT_TreeItem parent, boolean checked, boolean grayed) {
        if (parent == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            for (TT_TreeItem child : parent.children) {
                if (!child.isGrayed() && checked == child.isChecked()) continue;
                grayed = true;
                checked = true;
                break;
            }
        }
        parent.checked = checked;
        parent.grayed = grayed;
        if (parent.element != null) {
            parent.element.setAttribute("checked", Boolean.toString(checked));
            parent.element.setAttribute("grayed", Boolean.toString(grayed));
        }
        this.checkPath(parent.getParent(), checked, grayed);
    }

    @Override
    public TT_TreeItem getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public ITreeWrappedItem getValue() {
        return this.value;
    }

    public void setValue(ITreeWrappedItem value) {
        this.value = value;
    }

    @Override
    public Object[] getChildren() {
        return this.children.toArray(new TT_TreeItem[this.children.size()]);
    }

    public TT_TreeItem[] getSiblings() {
        if (this.parent == null) {
            return new TT_TreeItem[0];
        }
        TT_TreeItem[] children = (TT_TreeItem[])this.parent.getChildren();
        TT_TreeItem[] siblings = new TT_TreeItem[children.length - 1];
        int j = 0;
        int i = 0;
        while (i < children.length) {
            if (this != children[i]) {
                siblings[j++] = children[i];
            }
            ++i;
        }
        return siblings;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Image getImage() {
        if (this.value instanceof ITreeWrappedItem) {
            return this.value.getImage();
        }
        return null;
    }

    public String getText() {
        if (this.value instanceof ITreeWrappedItem) {
            return this.value.getText();
        }
        return this.getName();
    }

    public ArrayList<TT_TreeItem> getAllCheckedChildren(Class classType) {
        ArrayList<TT_TreeItem> all = new ArrayList<TT_TreeItem>(this.children.size() + 1);
        if (!this.isChecked() && !this.isGrayed()) {
            return all;
        }
        if (this.isChecked() && this.getAdapter(classType) != null) {
            all.add(this);
        }
        for (TT_TreeItem child : this.children) {
            all.addAll(child.getAllCheckedChildren(classType));
        }
        return all;
    }

    public ArrayList<TT_TreeItem> getAllChildren(Class classType) {
        ArrayList<TT_TreeItem> all = new ArrayList<TT_TreeItem>(this.children.size() + 1);
        if (this.getAdapter(classType) != null) {
            all.add(this);
        }
        for (TT_TreeItem child : this.children) {
            all.addAll(child.getAllChildren(classType));
        }
        return all;
    }

    @Override
    public <T> T getRoot(Class<T> classModel) {
        if (this.parent == null) {
            return (T)(classModel.isAssignableFrom(this.getClass()) ? this : null);
        }
        if (classModel.isAssignableFrom(this.parent.getClass())) {
            return this.parent.getRoot(classModel);
        }
        return (T)(classModel.isAssignableFrom(this.getClass()) ? this : null);
    }

    @Override
    public ITreeType getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }
}

