/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.TestingToolsActivator;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.core.XMLProfile;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerTreeModel
extends PropertyChangeManager
implements IPropertyChangeListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String NAME = "name";
    private static final String TREE_FILE = "com.ca.testingtools.TREE_FILE";
    private static ServerTreeModel model = null;
    private ArrayList<String> order = new ArrayList();
    private HashMap<String, IConfigurationElement> elementlist;
    private final ArrayList<TT_TreeItem> servers = new ArrayList();
    private XMLProfile profiles;
    private final String XMLPathName;

    private ServerTreeModel() {
        this.loadPlugins();
        ScopedPreferenceStore store = (ScopedPreferenceStore)TestingToolsActivator.plugin.getPreferenceStore();
        String filename = store.getString(TREE_FILE);
        if (filename == null || filename.isEmpty()) {
            filename = ServerTreeModel.setFileName();
        }
        IPath propertyPath = Platform.getStateLocation((Bundle)TestingToolsActivator.plugin.getBundle());
        this.XMLPathName = propertyPath.append(filename).toOSString();
        File pFile = new File(this.XMLPathName);
        if (pFile.exists()) {
            try {
                this.profiles = new XMLProfile(pFile);
                Element[] elementArray = this.profiles.getServers();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element server = elementArray[n2];
                    try {
                        this.insertServer(server);
                    }
                    catch (IOException e) {
                        this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
                    }
                    ++n2;
                }
            }
            catch (TTException tTException) {
                this.profiles = new XMLProfile();
            }
        } else {
            this.profiles = new XMLProfile();
        }
    }

    public static String setFileName() {
        ScopedPreferenceStore store = (ScopedPreferenceStore)TestingToolsActivator.plugin.getPreferenceStore();
        String filename = store.getDefaultString("DEFAULT_TREE_FILE_NAME");
        SimpleDateFormat dflocaltime = new SimpleDateFormat("yyyyMMddHHmmss");
        String ts = dflocaltime.format(new Date());
        filename = filename.replace(".", "." + ts + ".");
        store.setValue(TREE_FILE, filename);
        try {
            store.save();
        }
        catch (IOException iOException) {}
        return filename;
    }

    private void loadPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("com.ca.testingtools.profile");
        this.elementlist = new HashMap(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (name.equals("seperator")) {
                this.locate(element);
            } else {
                this.elementlist.put(element.getAttribute("id"), element);
            }
            ++n2;
        }
        for (IConfigurationElement element : this.elementlist.values()) {
            this.locate(element);
        }
        Iterator<String> iterator = this.order.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (this.elementlist.containsKey(key)) continue;
            iterator.remove();
        }
    }

    public void save() {
        try {
            this.profiles.toFile(this.XMLPathName);
        }
        catch (TTException e) {
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public void dispose() {
        for (TT_TreeItem item : this.servers) {
            item.removeListener(this);
        }
        this.save();
        model = null;
    }

    public TT_TreeItem insertServer(Element serverElement) throws IOException {
        TTServer server = new TTServer(serverElement);
        server.addPropertyChangeListener(this);
        TT_TreeItem serverItem = new TT_TreeItem(serverElement, server, server.getName());
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.testingtools.server", null, (Object)serverItem);
        this.servers.add(serverItem);
        this.insertProfiles(serverElement, serverItem);
        this.firePropertyChange(event);
        return serverItem;
    }

    protected void insertProfiles(Element serverElement, TT_TreeItem parent) {
        Element[] profileList;
        Element[] elementArray = profileList = this.profiles.getProfiles(serverElement);
        int n = profileList.length;
        int n2 = 0;
        while (n2 < n) {
            Element profile = elementArray[n2];
            this.insertProfile(parent, profile);
            ++n2;
        }
    }

    public TT_TreeItem insertProfile(TT_TreeItem parent, Element profile) {
        TTServer server = (TTServer)parent.getValue();
        String name = profile.getAttribute(NAME);
        Profile profileObject = new Profile();
        TT_TreeItem profileItem = new TT_TreeItem(profile, profileObject, name);
        parent.addChild(profileItem);
        for (String key : this.order) {
            IConfigurationElement nodeConfig = this.elementlist.get(key);
            ProfileNode node = null;
            try {
                node = (ProfileNode)nodeConfig.createExecutableExtension("class");
                node.setInitializationData(nodeConfig, "config", node);
                node.setInitializationData(nodeConfig, "server", server);
                String id = nodeConfig.getAttribute("id");
                Element profileNodeElement = this.profiles.getProfileNode(profile, id);
                if (profileNodeElement == null) {
                    profileNodeElement = this.createElement("profilenode");
                    profile.appendChild(profileNodeElement);
                }
                node.setInitializationData(nodeConfig, "settings", profileNodeElement);
                TT_TreeItem nodeItem = new TT_TreeItem(profileNodeElement, node, node.getName());
                node.setParent(nodeItem);
                profileItem.addChild(nodeItem);
                NodeList nodeChildren = profileNodeElement.getElementsByTagName("nodechild");
                int ix = 0;
                while (ix < nodeChildren.getLength()) {
                    this.insertNodeChild(nodeItem, (Element)nodeChildren.item(ix));
                    ++ix;
                }
            }
            catch (CoreException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return profileItem;
    }

    public TT_TreeItem insertNodeChild(TT_TreeItem parent, Element nodechild) {
        ProfileNode profileNode = (ProfileNode)parent.getValue();
        String name = nodechild.getAttribute(NAME);
        NodeChild nodechildObject = profileNode.buildChild();
        TT_TreeItem nodechildItem = new TT_TreeItem(nodechild, nodechildObject, name);
        parent.addChild(nodechildItem);
        return nodechildItem;
    }

    public TT_TreeItem findObject(Object object) {
        TT_TreeItem result = null;
        for (TT_TreeItem node : this.servers) {
            result = node.findValue(object);
            if (result != null) break;
        }
        return result;
    }

    public Element addServer(String name, String hostname, int port, String uuidString) throws Exception {
        Element top = this.profiles.getTop();
        Element serverElement = TTServer.BuildElement(name, hostname, port, uuidString);
        top.appendChild(serverElement);
        this.addProfile(serverElement, "Default Profile");
        return serverElement;
    }

    public Element addProfile(Element serverElement, String name) {
        Element profile = this.createElement("profile");
        profile.setAttribute(NAME, name);
        profile.setAttribute("UUID", UUID.randomUUID().toString());
        serverElement.appendChild(profile);
        return profile;
    }

    public Element addNodeChild(Element profileNodeElement, String name) {
        Element nodechild = this.createElement("nodechild");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        profileNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public void removeItem(Object element) {
        TT_TreeItem item = this.findObject(element);
        if (item == null) {
            return;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            this.servers.remove(item);
        } else {
            parent.removeChild(item);
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.firePropertyChange(event);
    }

    public static synchronized ServerTreeModel getInstance() {
        if (model == null) {
            model = new ServerTreeModel();
        }
        return model;
    }

    public TTServer getServer(String name) {
        for (TT_TreeItem item : this.servers) {
            TTServer server = (TTServer)item.getValue();
            if (server.getUUIDString().equals(name)) {
                return server;
            }
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return server;
        }
        return null;
    }

    private void locate(IConfigurationElement element) {
        Position position;
        String name = element.getName();
        boolean seperator = "seperator".equals(name);
        String ID = element.getAttribute(seperator ? NAME : "id");
        String menuid = element.getAttribute("menuid");
        try {
            position = Position.valueOf(element.getAttribute("menulocation"));
        }
        catch (Exception exception) {
            position = Position.last;
        }
        switch (position) {
            case first: {
                this.order.add(0, ID);
                break;
            }
            case last: {
                this.order.add(ID);
                break;
            }
            case before: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix > this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix, ID);
                break;
            }
            case after: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix >= this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix + 1, ID);
            }
        }
    }

    public XMLProfile getProfiles() {
        return this.profiles;
    }

    public Element createElement(String name) {
        return this.profiles.createElement(name);
    }

    public TT_TreeItem[] getServers() {
        return this.servers.toArray(new TT_TreeItem[this.servers.size()]);
    }

    public String getXMLPathName() {
        return this.XMLPathName;
    }

    protected static enum Position {
        first,
        last,
        before,
        after;

    }
}

