/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.Activator;
import com.ca.mat.connect.IServerList;
import com.ca.mat.connect.IServerListListener;
import com.ca.mat.connect.MATServer;
import com.ca.mat.managers.Singletons;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ServerList
implements IPropertyChangeListener,
IServerList {
    static final String cacopyright = "Copyright \u00a9 2014 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    static final String SERVER_MEMENTO_TYPE = "server";
    static IServerList inst;
    List<MATServer> servers = new ArrayList<MATServer>();
    List<IServerListListener> listeners = new ArrayList<IServerListListener>();
    Display display = Display.getCurrent();

    public ServerList() {
        this.loadAll();
    }

    public void addServer(MATServer server) {
        if (!this.servers.contains(server)) {
            this.servers.add(server);
            server.addPropertyChangeListener((IPropertyChangeListener)this);
            for (IServerListListener listener : this.listeners) {
                listener.serverAdded(server);
            }
            Singletons.getServerProxy().refreshServerStatus(server);
        }
    }

    public void removeServer(MATServer server) {
        if (this.servers.contains(server)) {
            this.servers.remove(server);
            server.removePropertyChangeListener((IPropertyChangeListener)this);
            for (IServerListListener listener : this.listeners) {
                listener.serverRemoved(server);
            }
        }
    }

    public List<MATServer> getServers() {
        ArrayList<MATServer> result = new ArrayList<MATServer>();
        result.addAll(this.servers);
        return result;
    }

    public void addChangeListener(IServerListListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IServerListListener listener) {
        this.listeners.remove(listener);
    }

    public void loadAll() {
        IPath propertyPath = Activator.plugin.getFragmentActivator().getPropertyPath();
        File file = (propertyPath = propertyPath.append("servers.xml")).toFile();
        if (file != null) {
            try {
                IMemento[] mementos;
                XMLMemento root = XMLMemento.createReadRoot((Reader)new FileReader(file));
                IMemento[] iMementoArray = mementos = root.getChildren(SERVER_MEMENTO_TYPE);
                int n = mementos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento memento = iMementoArray[n2];
                    MATServer server = this.mementoToServer(memento);
                    this.servers.add(server);
                    server.addPropertyChangeListener((IPropertyChangeListener)this);
                    ++n2;
                }
            }
            catch (IOException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            catch (WorkbenchException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
    }

    public void saveAll() {
        IPath propertyPath = Activator.plugin.getFragmentActivator().getPropertyPath();
        File file = (propertyPath = propertyPath.append("servers.xml")).toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
        XMLMemento root = XMLMemento.createWriteRoot((String)"Root");
        for (MATServer server : this.getServers()) {
            this.serverToMemento(server, (IMemento)root);
        }
        try {
            root.save((Writer)new FileWriter(file));
        }
        catch (IOException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    private IMemento serverToMemento(MATServer server, IMemento root) {
        IMemento memento = root.createChild(SERVER_MEMENTO_TYPE);
        memento.putString("name", server.getName());
        memento.putString("host", server.getHostname());
        memento.putString("port", String.valueOf(server.getPort()));
        memento.putString("uuid", server.getName());
        return memento;
    }

    private MATServer mementoToServer(IMemento memento) {
        String name = memento.getString("name");
        String host = memento.getString("host");
        String port = memento.getString("port");
        String uuid = memento.getString("uuid");
        MATServer server = new MATServer(name, host, port, uuid, this.display);
        return server;
    }

    public void propertyChange(PropertyChangeEvent event) {
        MATServer server = (MATServer)event.getSource();
        for (IServerListListener listener : this.listeners) {
            listener.serverChanged(server);
        }
    }
}

