/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.wizards;

import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.layout.wizards.AddLayoutPage;
import com.ca.filemaster.layout.wizards.AddLayoutPage2;
import com.ca.filemaster.layout.wizards.UpdateLayoutPage;
import com.ca.filemaster.layout.wizards.ViewLayoutServerPage;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class LayoutWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private AddLayoutPage page1;
    private ViewLayoutServerPage vlsp;
    private UpdateLayoutPage nextPage;
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private FMLayoutTreeModel layoutModel = FMLayoutTreeModel.getInstance();
    private FMServerTreeModel DLModel = FMServerTreeModel.getInstance();
    private boolean isLayoutTreeItem = false;
    private boolean isDirectoryListCaller = false;
    private TT_TreeItem ismember;

    public LayoutWizard() {
        this.setWindowTitle("Add Layout");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TrayDialog.setDialogHelpAvailable((boolean)true);
        Object object = selection.getFirstElement();
        if (object != null) {
            TT_TreeItem treeItem = this.layoutModel.findObject(object);
            this.isLayoutTreeItem = true;
            this.ismember = ((TT_TreeItem)selection.getFirstElement()).getParent(FileMasterMember.class);
            if (treeItem == null) {
                this.isDirectoryListCaller = true;
                treeItem = this.DLModel.findObject(object);
                this.isLayoutTreeItem = false;
            }
            if (treeItem != null) {
                if (this.isLayoutTreeItem) {
                    this.server = null;
                    if (treeItem.getParent() != null) {
                        this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                        this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                    } else {
                        this.member = null;
                        this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                    }
                } else if (treeItem.getParent() != null) {
                    if (treeItem.getParent().getParent() != null) {
                        this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                        this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                        this.server = (FileMasterServer)treeItem.getParent().getParent().getAdapter(FileMasterServer.class);
                    } else {
                        this.member = null;
                        this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                        this.server = (FileMasterServer)treeItem.getParent().getAdapter(FileMasterServer.class);
                    }
                }
            } else {
                this.member = null;
                this.dataset = null;
                this.server = null;
            }
        }
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        String datasetName = "";
        String memberName = "";
        if (this.dataset != null) {
            datasetName = this.dataset.getName();
        }
        if (this.member != null) {
            memberName = this.member.getName();
        }
        if (this.ismember != null) {
            this.vlsp = new ViewLayoutServerPage("Select Server", datasetName, memberName);
            this.nextPage = new UpdateLayoutPage("View Layout", this.server, datasetName, memberName, "", false);
            this.setWindowTitle("Layout");
            this.addPage((IWizardPage)this.vlsp);
            this.addPage((IWizardPage)this.nextPage);
        } else {
            this.setForcePreviousAndNextButtons(false);
            this.needsPreviousAndNextButtons();
            this.page1 = new AddLayoutPage("Add Layout", this.server, datasetName, memberName, this.isDirectoryListCaller);
            this.addPage((IWizardPage)this.page1);
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Add Layout")) {
            return this.page1.canFinish();
        }
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Select Server")) {
            return false;
        }
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("View Layout")) {
            return true;
        }
        if (this.page1.getNextPage().getTitle().equalsIgnoreCase("Add Layout")) {
            return ((UpdateLayoutPage)((AddLayoutPage2)this.page1.getNextPage()).getNextPage()).isPageComplete();
        }
        return ((UpdateLayoutPage)this.page1.getNextPage()).isPageComplete();
    }

    public boolean performFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Add Layout")) {
            return this.page1.doFinish();
        }
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("View Layout")) {
            return true;
        }
        return true;
    }
}

