/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.handlers;

import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.dsnlists.view.DSNListView;
import com.ca.filemaster.selection.views.SelectionView;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.filemaster.views.layout.LayoutView;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class RemoveItemHandler
extends AbstractHandler
implements IElementUpdater {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private FMLayoutTreeModel layoutModel = FMLayoutTreeModel.getInstance();
    private FMSelectionTreeModel selectionModel = FMSelectionTreeModel.getInstance();
    private FMDSNListTreeModel dsnlistModel = FMDSNListTreeModel.getInstance();
    private TT_TreeItem toBeRemoved = null;
    private boolean selectionView = false;
    private boolean layoutView = false;
    private boolean dirListView = false;
    private boolean dsnlistView = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page;
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
        String key = "CLOSING_VALUE";
        boolean showDiag = !store.getBoolean(key);
        boolean remove = false;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        boolean deleteServer = false;
        Command command = event.getCommand();
        command.getId();
        String deleteItem = "";
        IStructuredSelection selection = (IStructuredSelection)sel;
        Class<FileMasterServer> testClass = null;
        if (selection.isEmpty()) {
            return null;
        }
        if (((TT_TreeItem)selection.getFirstElement()).getValue().getAdapter(FileMasterServer.class) != null) {
            testClass = FileMasterServer.class;
            deleteServer = true;
            deleteItem = "server";
            this.dirListView = true;
        } else if (((TT_TreeItem)selection.getFirstElement()).getValue().getAdapter(FileMasterDataset.class) != null) {
            testClass = FileMasterDataset.class;
            deleteItem = "data set";
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            this.dirListView = this.model.isActiveView(page, page.findView("com.ca.filemaster.views.directorylist"));
            if (!(this.dirListView || (this.selectionView = this.model.isActiveView(page, page.findView("com.ca.filemaster.selection.views.selectionview"))) || (this.dsnlistView = this.model.isActiveView(page, page.findView("com.ca.filemaster.dsnlists.view.dsnlistview"))))) {
                this.layoutView = true;
            }
        } else if (((TT_TreeItem)selection.getFirstElement()).getValue().getAdapter(FileMasterMember.class) != null) {
            testClass = FileMasterMember.class;
            deleteItem = "member";
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            this.dirListView = this.model.isActiveView(page, page.findView("com.ca.filemaster.views.directorylist"));
            if (!(this.dirListView || (this.selectionView = this.model.isActiveView(page, page.findView("com.ca.filemaster.selection.views.selectionview"))) || (this.dsnlistView = this.model.isActiveView(page, page.findView("com.ca.filemaster.dsnlists.view.dsnlistview"))))) {
                this.layoutView = true;
            }
        } else {
            return null;
        }
        ArrayList<TT_TreeItem> list = new ArrayList<TT_TreeItem>(selection.size());
        for (Object item : selection) {
            TT_TreeItem treeItem;
            if (!(item instanceof TT_TreeItem) || (treeItem = ((TT_TreeItem)item).getParent(testClass)) == null) continue;
            list.add(treeItem);
        }
        if (showDiag) {
            if (list.size() == 0) {
                return null;
            }
            String question = null;
            if (list.size() > 1) {
                question = String.format("Do you want to remove these %d items", selection.size());
            } else {
                Object target = list.get(0);
                question = String.format("Do you want to remove %s: %s ", deleteItem, target.toString());
            }
            Shell shell = window.getShell();
            shell.setMinimized(false);
            shell.forceActive();
            shell.forceFocus();
            String toggleMessage = "Always remove items without this prompt";
            MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Remove", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)key);
            int returncode = result.getReturnCode();
            store.setValue(key, result.getToggleState());
            boolean bl = remove = returncode == 0 || returncode == 2;
            if (returncode == 3 || returncode == -1) {
                return null;
            }
        } else {
            remove = true;
        }
        if (remove) {
            for (TT_TreeItem value : list) {
                this.toBeRemoved = this.selectionView ? this.selectionModel.removeItem((Object)value) : (this.layoutView ? this.layoutModel.removeItem((Object)value) : (this.dsnlistView ? this.dsnlistModel.removeItem((Object)value) : this.model.removeItem((Object)value)));
            }
        }
        try {
            TT_TreeItem selectionIndex;
            Object[] expandedElements;
            TreeViewer viewer;
            IViewPart view;
            IWorkbenchPage page2 = window.getActivePage();
            if (this.selectionView) {
                view = page2.showView("com.ca.filemaster.selection.views.selectionview");
                if (view instanceof SelectionView) {
                    viewer = ((SelectionView)view).getViewer();
                    if (viewer != null) {
                        expandedElements = viewer.getExpandedElements();
                        viewer.setInput((Object)this.selectionModel.getDatasets());
                        viewer.refresh(true);
                        viewer.setExpandedElements(expandedElements);
                    }
                    selectionIndex = this.toBeRemoved;
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selectionIndex), true);
                    view.setFocus();
                }
            } else if (this.dsnlistView) {
                view = page2.showView("com.ca.filemaster.dsnlists.view.dsnlistview");
                if (view instanceof DSNListView) {
                    viewer = ((DSNListView)view).getViewer();
                    if (viewer != null) {
                        expandedElements = viewer.getExpandedElements();
                        viewer.setInput((Object)this.dsnlistModel.getDatasets());
                        viewer.refresh(true);
                        viewer.setExpandedElements(expandedElements);
                    }
                    selectionIndex = this.toBeRemoved;
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selectionIndex), true);
                    view.setFocus();
                }
            } else if (this.layoutView) {
                view = page2.showView("com.ca.filemaster.layout.views.layoutview");
                if (view instanceof LayoutView) {
                    viewer = ((LayoutView)view).getViewer();
                    if (viewer != null) {
                        expandedElements = viewer.getExpandedElements();
                        viewer.setInput((Object)this.layoutModel.getDatasets());
                        viewer.refresh(true);
                        viewer.setExpandedElements(expandedElements);
                    }
                    selectionIndex = this.toBeRemoved;
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selectionIndex), true);
                    view.setFocus();
                }
            } else {
                view = page2.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView) {
                    viewer = ((DirectoryListView)view).getViewer();
                    if (viewer != null) {
                        if (deleteServer) {
                            expandedElements = viewer.getExpandedElements();
                            viewer.setInput((Object)this.model.getServers());
                            viewer.setExpandedElements(expandedElements);
                        } else {
                            viewer.refresh(true);
                        }
                    }
                    selectionIndex = this.toBeRemoved;
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selectionIndex), true);
                    view.setFocus();
                }
            }
        }
        catch (PartInitException partInitException) {}
        this.selectionModel.save();
        this.layoutModel.save();
        this.dsnlistModel.save();
        this.model.save();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

