/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.customlayout.wizards.AddCRLPage;
import com.ca.filemaster.customlayout.wizards.UpdateCRLPage;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CRLWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private AddCRLPage page1;
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private FMLayoutTreeModel layoutModel = FMLayoutTreeModel.getInstance();
    private FMServerTreeModel DLModel = FMServerTreeModel.getInstance();
    private boolean isLayoutTreeItem = false;
    private boolean isDirectoryListCaller = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Add Custom Layout");
        Object object = selection.getFirstElement();
        if (object != null) {
            TT_TreeItem treeItem = this.layoutModel.findObject(object);
            this.isLayoutTreeItem = true;
            if (treeItem == null) {
                this.isDirectoryListCaller = true;
                treeItem = this.DLModel.findObject(object);
                this.isLayoutTreeItem = false;
            }
            if (treeItem != null) {
                if (this.isLayoutTreeItem) {
                    this.server = null;
                    if (treeItem.getParent() != null) {
                        this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                        this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                    } else {
                        this.member = null;
                        this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                    }
                } else if (treeItem.getParent() != null) {
                    if (treeItem.getParent().getParent() != null) {
                        this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                        this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                        this.server = (FileMasterServer)treeItem.getParent().getParent().getAdapter(FileMasterServer.class);
                    } else {
                        this.member = null;
                        this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                        this.server = (FileMasterServer)treeItem.getParent().getAdapter(FileMasterServer.class);
                    }
                }
            } else {
                this.member = null;
                this.dataset = null;
                this.server = null;
            }
        }
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        String datasetName = "";
        String memberName = "";
        if (this.dataset != null) {
            datasetName = this.dataset.getName();
        }
        if (this.member != null && this.member.getType().equalsIgnoreCase("CRL")) {
            memberName = this.member.getName();
        }
        this.page1 = new AddCRLPage("Add Custom Layout", this.server, datasetName, memberName, this.isDirectoryListCaller);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Add Custom Layout")) {
            return this.page1.canFinish();
        }
        return ((UpdateCRLPage)this.getContainer().getCurrentPage()).isPageComplete();
    }

    public boolean performFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Add Custom Layout")) {
            return this.page1.doFinish();
        }
        return ((UpdateCRLPage)this.getContainer().getCurrentPage()).doFinish();
    }
}

