/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerWizard;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterLayout;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.customlayout.wizards.CRLUpdate1;
import com.ca.filemaster.customlayout.wizards.CRLUpdate1Page;
import com.ca.filemaster.layout.wizards.AddLayoutPage;
import com.ca.filemaster.views.layout.LayoutView;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class CRLServerPage
extends FMServerWizard {
    protected final String CONTEXT_Update_HELP_ID = "com.ca.filemaster.help.customLayoutProperties";
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private CRLClass crl;
    private FileMasterLayout fmlayout;
    private FMLayoutTreeModel layoutModel = FMLayoutTreeModel.getInstance();
    private Object layoutObj;
    Element fmlayoutElement;
    TT_TreeItem fmlayoutItem;
    FileMasterLayoutField fmlayoutfield;
    Element fmlayoutfieldElement;
    private IWizardPage update1Page;

    public CRLServerPage(String pageName, FileMasterDataset dataset, FileMasterMember member, Object layoutObj) {
        super(pageName, "", "");
        this.layoutObj = layoutObj;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.customLayoutProperties");
    }

    public IWizardPage getNextPage() {
        if (this.layoutObj != null) {
            TT_TreeItem treeItem = this.layoutModel.findObject(this.layoutObj);
            if (treeItem != null) {
                if (treeItem.getParent() != null) {
                    this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                    this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                } else {
                    this.member = null;
                    this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                }
            } else {
                this.member = null;
                this.dataset = null;
            }
            this.crl = AddLayoutPage.getCRL(this.dataset, this.member, this.server);
        }
        if (this.crl == null) {
            this.layoutModel.removeItem((Object)this.member);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page1 = window.getActivePage();
                IViewPart view = page1.showView("com.ca.filemaster.layout.views.layoutview");
                if (view instanceof LayoutView) {
                    TreeViewer viewer = ((LayoutView)view).getViewer();
                    if (viewer != null) {
                        viewer.refresh(true);
                        view = page1.showView("com.ca.filemaster.layout.views.layoutview");
                        page1.activate((IWorkbenchPart)view);
                        page1.bringToTop((IWorkbenchPart)view);
                    }
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {}
        } else {
            if (this.dataset != null) {
                this.crl.setDatasetName(this.dataset.getName());
            }
            if (this.member != null) {
                this.crl.setMemberName(this.member.getName());
            }
            CRLUpdate1Page page = new CRLUpdate1Page("Custom Layout Update", this.crl, false, this.server);
            ((CRLUpdate1)this.getWizard()).addPage((IWizardPage)page);
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.dataset.getName());
            FileMasterMember fmmember = new FileMasterMember(null);
            fmmember.setName(this.member.getName());
            TT_TreeItem dsItem = null;
            TT_TreeItem memItem = null;
            dsItem = this.layoutModel.findObject((Object)fmdataset);
            if (dsItem != null) {
                int i = 0;
                while (i < dsItem.getChildren().length) {
                    if (((TT_TreeItem)dsItem.getChildren()[i]).getName().equalsIgnoreCase(this.member.getName())) {
                        memItem = (TT_TreeItem)dsItem.getChildren()[i];
                        break;
                    }
                    ++i;
                }
                memItem.getElement().setAttribute("description", this.crl.getDescription());
            }
            int numChildren = memItem.getChildren().length;
            int i = numChildren - 1;
            while (i >= 0) {
                this.layoutModel.removeItem((Object)((TT_TreeItem)memItem.getChildren()[i]), memItem);
                --i;
            }
            i = 0;
            while (i < this.crl.getLayouts().size()) {
                this.fmlayout = new FileMasterLayout(null);
                this.fmlayout.setName(String.valueOf(this.crl.getLayout(i).getLayoutMember()) + ": " + this.crl.getLayout(i).getTopLayoutField());
                this.fmlayout.setLevel(this.crl.getLayout(i).getTopLayoutLevelString());
                this.fmlayoutElement = this.layoutModel.addLayout(memItem.getElement(), this.fmlayout.getName(), this.crl.getLayout(i).getLayoutDataset(), this.crl.getLayout(i).getLayoutMember(), this.crl.getLayout(i).isDefault());
                this.fmlayoutItem = this.layoutModel.insertLayout(memItem, this.fmlayoutElement);
                int j = 0;
                while (j < this.crl.getLayout(i).getLayoutFields().size()) {
                    this.fmlayoutfield = new FileMasterLayoutField(null);
                    this.fmlayoutfield.setName(this.crl.getLayout(i).getLayoutField(j).getField());
                    this.fmlayoutfield.setLevel(this.crl.getLayout(i).getLayoutField(j).getLevelString());
                    if (this.crl.getLayout(i).getLayoutField(j).isSelected()) {
                        this.fmlayoutfieldElement = this.layoutModel.addLayoutField(this.fmlayoutElement, this.fmlayoutfield.getName(), this.fmlayoutfield.getLevel(), this.crl.getLayout(i).getLayoutField(j).isTop(), this.crl.getLayout(i).getLayoutField(j).isSelected(), this.crl.getLayout(i).getLayoutField(j).getPosition(), this.crl.getLayout(i).getLayoutField(j).getFormatType(), this.crl.getLayout(i).getLayoutField(j).getFormatNum(), this.crl.getLayout(i).getLayoutField(j).getFormatDec(), this.crl.getLayout(i).getLayoutField(j).getLogOperator(), this.crl.getLayout(i).getLayoutField(j).getOperator(), this.crl.getLayout(i).getLayoutField(j).getValue());
                        this.layoutModel.insertLayoutField(this.fmlayoutItem, this.fmlayoutfieldElement);
                    }
                    ++j;
                }
                ++i;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page1 = window.getActivePage();
                IViewPart view = page1.showView("com.ca.filemaster.layout.views.layoutview");
                if (view instanceof LayoutView) {
                    TreeViewer viewer = ((LayoutView)view).getViewer();
                    if (viewer != null) {
                        TT_TreeItem selection = this.layoutModel.findObjectInTree((Object)fmmember, this.layoutModel.findObject((Object)fmdataset));
                        Object[] expandedElements = viewer.getExpandedElements();
                        viewer.setInput((Object)this.layoutModel.getDatasets());
                        viewer.refresh(true);
                        viewer.setExpandedElements(expandedElements);
                        viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                        view = page1.showView("com.ca.filemaster.layout.views.layoutview");
                        page1.activate((IWorkbenchPart)view);
                        page1.bringToTop((IWorkbenchPart)view);
                    }
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {}
            this.layoutModel.save();
            FMHistory.clearList((String)"ServerAddLayoutPage1");
            FMHistory.insertHistory((Combo)this.serverCombo, (String)"ServerAddLayoutPage1");
            this.update1Page = this.getWizard().getPage("Custom Layout Update");
            return this.update1Page;
        }
        this.layoutModel.save();
        return null;
    }

    public IWizardPage getUpdatePage() {
        return this.update1Page;
    }

    public boolean doFinish() {
        return true;
    }
}

