/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.connect.MATServer;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.IMonitorListener;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.IMATView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class MonitorSchedulesView
extends ViewPart
implements IMATView,
IDoubleClickListener,
IMonitorListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    static int[] columnWidths;
    static int[] columnOrder;
    private IMATTableViewer viewer;
    public static final String ID = "com.ca.mat.views.monitorschedulesview";
    private final String SECTION_NAME = "Monitor Schedules";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.monitorschedulesview";
    private MonitorManager manager;
    public static final String VIEWER_MEMENTO_TYPE = "monitorschedulesview.viewer";
    private boolean initializing = true;

    public static boolean anyOpen() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = activeWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] references;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = references = page.getViewReferences();
            int n3 = references.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference viewRef = iViewReferenceArray[n4];
                String id = viewRef.getId();
                if (id.equals(ID) || id.startsWith("com.ca.mat.views.monitorschedulesview:")) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static void resetView() {
        columnWidths = null;
        columnOrder = null;
    }

    public void init(IViewSite site, IMemento memento) {
        try {
            super.init(site, memento);
            if (memento != null) {
                Singletons.getPersistenceManager().set(ID, memento);
            }
        }
        catch (PartInitException e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.INFO, "Could not load settings for Monitor Schedules View - resetting.", e);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.initializing = true;
        this.manager = Singletons.getMonitorManager();
        this.viewer = MATTableViewerFactory.createNew(parent);
        MATTableModel model = this.manager.getMonitorSchedulesTable();
        this.manager.addMonitorListener(this);
        this.viewer.addColumn("Schedule", 5, "Schedule", 1, true, false);
        this.viewer.addColumn("Description", 7, "Description", 1, true, true);
        this.viewer.addColumn("Modified by", 5, "Modified by", 1, true, true);
        this.viewer.addColumn("Modified on", 5, "Modified on", 4, true, true);
        this.viewer.addColumn("Modified at", 5, "Modified at", 6, true, true);
        this.viewer.addColumn("Start Date", 5, "Start Date", 4, false, true);
        this.viewer.addColumn("End Date", 5, "End Date", 4, false, true);
        this.viewer.addColumn("Days", 3, "Days", 2, false, true);
        this.viewer.addColumn("WD", 1, "Week Days", 1, false, true);
        this.viewer.addColumn("WE", 1, "Week Ends", 1, false, true);
        this.viewer.addColumn("SP", 1, "Specific Days", 1, false, true);
        this.viewer.addColumn("Mo", 1, "Monday", 1, false, true);
        this.viewer.addColumn("Tu", 1, "Tuesday", 1, false, true);
        this.viewer.addColumn("We", 1, "Wednesday", 1, false, true);
        this.viewer.addColumn("Th", 1, "Thursday", 1, false, true);
        this.viewer.addColumn("Fr", 1, "Friday", 1, false, true);
        this.viewer.addColumn("Sa", 1, "Saturday", 1, false, true);
        this.viewer.addColumn("Su", 1, "Sunday", 1, false, true);
        this.viewer.addColumn("Start Time 1", 3, "Start Time 1", 6, false, true);
        this.viewer.addColumn("End Time 1", 3, "End Time 1", 6, false, true);
        this.viewer.addColumn("Start Time 2", 3, "Start Time 2", 6, false, true);
        this.viewer.addColumn("End Time 2", 3, "End Time 2", 6, false, true);
        this.viewer.addColumn("Start Time 3", 3, "Start Time 3", 6, false, true);
        this.viewer.addColumn("End Time 3", 3, "End Time 3", 6, false, true);
        this.viewer.addColumn("Start Time 4", 3, "Start Time 4", 6, false, true);
        this.viewer.addColumn("End Time 4", 3, "End Time 4", 6, false, true);
        this.viewer.setDefaultSortColumn(0);
        this.viewer.setDefaultSortDirection(128);
        this.viewer.setCATableModel(model);
        this.viewer.addDoubleClickListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Singletons.getViewerSynchronizationManager().addViewer(VIEWER_MEMENTO_TYPE, this.viewer);
        this.viewer.refresh();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        this.initializing = false;
    }

    public void dispose() {
        this.manager.removeMonitorListener(this);
        Singletons.getViewerSynchronizationManager().removeViewer(this.viewer);
        IMemento memento = Singletons.getPersistenceManager().get(ID);
        if (memento != null) {
            this.saveState(memento);
        }
        super.dispose();
    }

    public IMATTableViewer getTableViewer() {
        return this.viewer;
    }

    public void setModel(MATTableModel model) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setCATableModel(model);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public IMATTableViewer getViewer() {
        return this.viewer;
    }

    public void doubleClick(DoubleClickEvent event) {
        IHandlerService cfr_ignored_0 = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    @Override
    public void monitorProfilesUpdated(MATTableModel profiles) {
    }

    @Override
    public void monitorHistoryUpdated(MATServer server, String profile, MATTableModel history) {
    }

    @Override
    public void monitorSchedulesUpdated(MATTableModel schedules) {
        this.viewer.setCATableModel(schedules);
        this.viewer.refresh();
    }
}

