/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.MATException;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.logging.Logging;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class AnalysisPagePresentationFactory {
    private static final String INSTANCE_CLASS_VIEW = "com.ca.mat.views.AnalysisDetachedView";
    private static final String INSTANCE_CLASS_DIALOG = "com.ca.mat.dialogs.AnalysisPageDialog";

    public static IAnalysisPagePresentation createNewTabbed() {
        return null;
    }

    public static IAnalysisSubpagePresentation showNewDetached(Class pageClass, String modelName, String dsn, int type, IAnalysisPagePresentation parent, String contextHelpId, MATTableModel externalModel, boolean deferPageFocus) throws MATException {
        String className = AnalysisPagePresentationFactory.checkRAP() ? INSTANCE_CLASS_DIALOG : INSTANCE_CLASS_DIALOG;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> cons = clazz.getConstructor(new Class[0]);
            IAnalysisSubpagePresentation subpagePresentation = (IAnalysisSubpagePresentation)cons.newInstance(new Object[0]);
            return subpagePresentation.showDetachedPage(pageClass, modelName, dsn, type, parent, contextHelpId, externalModel, deferPageFocus);
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.SEVERE, "Could not create analysis subview", e);
            throw new MATException("Reflection failed to instantiate class " + className, e);
        }
    }

    public static IAnalysisSubpagePresentation showNewDetached(Class pageClass, String modelName, String dsn, int type, IAnalysisPagePresentation parent, String contextHelpId, MATTableModel externalModel) {
        return AnalysisPagePresentationFactory.showNewDetached(pageClass, modelName, dsn, type, parent, contextHelpId, externalModel, false);
    }

    public static IAnalysisSubpagePresentation showNewDetached(Class pageClass, String modelName, String dsn, int type, IAnalysisPagePresentation parent) {
        return AnalysisPagePresentationFactory.showNewDetached(pageClass, modelName, dsn, type, parent, null, null, false);
    }

    private static boolean checkRAP() {
        Bundle bundle = Platform.getBundle((String)"com.ca.mat.rapfragment");
        return bundle != null && bundle.getState() != 1;
    }
}

