/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallStackInfoRowModel;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.rowmodels.TimeViewRowModel;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.TranViewPage;
import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;

public class CallStackPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        int type = -1;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        type = presentation.getAnalysisType();
        if (property.equals("hasCsContent")) {
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            MATTableModel modelCs = Singletons.getAnalysisManager().getModel(dsn, "Call Stack Info", type);
            if (modelCs == null) {
                return false;
            }
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            if (page instanceof TranViewPage && receiver instanceof TranViewRowModel) {
                TranViewRowModel rowModel = (TranViewRowModel)receiver;
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    arguments.put("Transaction", new Object[]{""});
                } else {
                    arguments.put("Transaction", new Object[]{tranName});
                }
            }
            if (model != null) {
                model = model.filterBy(arguments);
                MATTableRow[] mATTableRowArray = model.getRows();
                int n = mATTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MATTableRow row = mATTableRowArray[n2];
                    TimeViewRowModel timeRow = (TimeViewRowModel)row;
                    MATTableRow[] mATTableRowArray2 = modelCs.getRows();
                    int n3 = mATTableRowArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MATTableRow csRow = mATTableRowArray2[n4];
                        CallStackInfoRowModel callStackRow = (CallStackInfoRowModel)csRow;
                        if (timeRow.getTimTranc().equalsIgnoreCase(callStackRow.getPgitran())) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return false;
        }
        if (property.equals("hasCount") && receiver instanceof CallerIdRowModel) {
            return ((CallerIdRowModel)receiver).getCount() != 0;
        }
        return false;
    }
}

