/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.JVMInfoRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.JVMPage;
import com.ca.mat.views.subpages.AbstractJVMSubpage;
import com.ca.mat.views.subpages.JVMMethodsSubpage;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JVMMethodsHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        if (!commandId.equals("com.ca.mat.commands.analysis.jvmview.applicationmethods") && !commandId.equals("com.ca.mat.commands.analysis.jvmview.viamethods") && !commandId.equals("com.ca.mat.commands.analysis.jvmview.currentmethods") || obj == null || !(page instanceof AbstractJVMSubpage) && !(page instanceof JVMPage)) return null;
        String currentDisplayMode = "";
        JVMPage.JVMContextRestrictions currentContext = null;
        if (page instanceof AbstractJVMSubpage) {
            AbstractJVMSubpage jvmSubpage = (AbstractJVMSubpage)page;
            currentContext = jvmSubpage.getContextRestrictions();
            currentDisplayMode = currentContext.getDisplayMode();
        } else {
            if (!(page instanceof JVMPage)) throw new RuntimeException(String.format("Invalid page encountered (%s)", ((Object)((Object)this)).getClass().toString()));
            JVMPage jvmPage = (JVMPage)page;
            currentDisplayMode = jvmPage.getModeType();
            currentContext = jvmPage.new JVMPage.JVMContextRestrictions();
            if (jvmPage.getModeType().equals("display_mode_process")) {
                currentContext.setFrom("Process");
            } else if (jvmPage.getModeSubtype().equals("data_mode_application")) {
                currentContext.setFrom("Application");
            } else if (jvmPage.getModeSubtype().equals("data_mode_via")) {
                currentContext.setFrom("Via");
            } else if (jvmPage.getModeSubtype().equals("data_mode_current")) {
                currentContext.setFrom("Current");
            }
        }
        HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
        if (currentContext.getJVMMethodNameId() != null) {
            arguments.put(currentContext.getJVMMethodNameKey(), new Object[]{currentContext.getJVMMethodNameId()});
        }
        if (currentContext.getJVMMethodSourceId() != null) {
            arguments.put(currentContext.getJVMMethodSourceKey(), new Object[]{currentContext.getJVMMethodSourceId()});
        }
        if (currentContext.getJVMProcess() != null) {
            arguments.put("jvmpid", new Object[]{currentContext.getJVMProcess()});
        }
        if (currentContext.getJVMThread() != null) {
            arguments.put("jvmtcb", new Object[]{currentContext.getJVMThread()});
        }
        String section = null;
        section = "JVM Information";
        String aggregateMode = null;
        String dataMode = null;
        String displayMode = null;
        if (obj instanceof JVMInfoRowModel) {
            JVMInfoRowModel row;
            if (currentDisplayMode.equals("display_mode_process")) {
                row = (JVMInfoRowModel)obj;
                arguments.put("jvmpid", new Object[]{row.getProcessId()});
                currentContext.setJVMProcess(row.getProcessId());
                displayMode = "display_mode_methods";
                aggregateMode = "group_by_method";
                if (commandId.equals("com.ca.mat.commands.analysis.jvmview.applicationmethods")) {
                    dataMode = "data_mode_application";
                } else if (commandId.equals("com.ca.mat.commands.analysis.jvmview.viamethods")) {
                    dataMode = "data_mode_via";
                } else {
                    if (!commandId.equals("com.ca.mat.commands.analysis.jvmview.currentmethods")) throw new RuntimeException(String.format("invalid command being processed at (%1$s) - commandId (%2$s)", ((Object)((Object)this)).getClass().toString(), commandId));
                    dataMode = "data_mode_current";
                }
            } else if (currentDisplayMode.equals("display_mode_threads")) {
                row = (JVMInfoRowModel)obj;
                arguments.put("jvmtcb", new Object[]{row.getThread()});
                currentContext.setJVMThread(row.getThread());
                displayMode = "display_mode_methods";
                aggregateMode = "group_by_method";
                if (commandId.equals("com.ca.mat.commands.analysis.jvmview.applicationmethods")) {
                    dataMode = "data_mode_application";
                } else if (commandId.equals("com.ca.mat.commands.analysis.jvmview.viamethods")) {
                    dataMode = "data_mode_via";
                } else {
                    if (!commandId.equals("com.ca.mat.commands.analysis.jvmview.currentmethods")) throw new RuntimeException(String.format("invalid command being processed at (%1$s) - commandId (%2$s)", ((Object)((Object)this)).getClass().toString(), commandId));
                    dataMode = "data_mode_current";
                }
            } else {
                if (!currentDisplayMode.equals("display_mode_app") && !currentDisplayMode.equals("display_mode_methods") && !currentDisplayMode.equals("display_mode_threads")) throw new RuntimeException(String.format("Command (%1$s) not yet implemented for mode (%1$s)", commandId, currentDisplayMode));
                row = (JVMInfoRowModel)obj;
                if (row.getDataMode().equals("data_mode_application")) {
                    arguments.put("jvmmetha", new Object[]{row.getMethodId()});
                    arguments.put("jvmsrcea", new Object[]{row.getSourceId()});
                    currentContext.setJVMMethodNameKey("jvmmetha");
                    currentContext.setJVMMethodSourceKey("jvmsrcea");
                } else if (row.getDataMode().equals("data_mode_current")) {
                    arguments.put("jvmmethc", new Object[]{row.getMethodId()});
                    arguments.put("jvmsrcec", new Object[]{row.getSourceId()});
                    currentContext.setJVMMethodNameKey("jvmmethc");
                    currentContext.setJVMMethodSourceKey("jvmsrcec");
                } else {
                    if (!row.getDataMode().equals("data_mode_via")) throw new RuntimeException(String.format("%1$s: command(%2$s), page displayMode(%3$s), row dataMode(%4$s) - INVALID COMBINATION", ((Object)((Object)this)).getClass().toString(), commandId, currentDisplayMode, row.getDataMode()));
                    arguments.put("jvmmethv", new Object[]{row.getMethodId()});
                    arguments.put("jvmsrcev", new Object[]{row.getSourceId()});
                    currentContext.setJVMMethodNameKey("jvmmethv");
                    currentContext.setJVMMethodSourceKey("jvmsrcev");
                }
                currentContext.setJVMMethodName(row.getClassMethod());
                currentContext.setJVMMethodSource(row.getClassSource());
                currentContext.setJVMMethodNameId(row.getMethodId());
                currentContext.setJVMMethodSourceId(row.getSourceId());
                aggregateMode = "group_by_method";
                if (commandId.equals("com.ca.mat.commands.analysis.jvmview.applicationmethods")) {
                    dataMode = "data_mode_application";
                } else if (commandId.equals("com.ca.mat.commands.analysis.jvmview.viamethods")) {
                    dataMode = "data_mode_via";
                } else {
                    if (!commandId.equals("com.ca.mat.commands.analysis.jvmview.currentmethods")) throw new RuntimeException(String.format("Invalid command being processed at (%1$s) - commandId (%2$s)", ((Object)((Object)this)).getClass().toString(), commandId));
                    dataMode = "data_mode_current";
                }
                displayMode = "display_mode_methods";
            }
        }
        currentContext.setDisplayMode(displayMode);
        currentContext.setDataMode(dataMode);
        MATTableModel nextModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
        if (arguments != null) {
            nextModel = nextModel.filterBy(arguments);
        }
        if (aggregateMode != null) {
            nextModel = AnalysisUtils.aggregateJVM(nextModel, aggregateMode, dataMode, displayMode, dsn);
        }
        IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(JVMMethodsSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.jvmmethods", nextModel);
        ((AbstractJVMSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
        ((AbstractJVMSubpage)detachedView.getCurrentPage()).refreshHeader();
        detachedView.setPresentationName("JVM Methods");
        return null;
    }
}

