/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dashboard;

import com.ca.mat.Activator;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.dashboard.IDashboard;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.DelayViewRowModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class DashboardH
implements IDashboard,
ProgressListener,
StatusTextListener {
    Browser browser;
    MATTableModel data;
    MATTableModel[] dataDetails;
    MATTableModel timeViewData;
    boolean ready = false;
    String dsn;
    int type;
    Composite parent;

    @Override
    public void createDashboard(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addProgressListener((ProgressListener)this);
        long time = System.nanoTime();
        this.browser.setText(this.readHTMLFile());
        long difference = System.nanoTime() - time;
        System.out.println("HC Browser set HTML timing: " + difference / 1000000L);
    }

    public void updateDashboard(MATTableModel data, String dsn, int type) {
        data.sortByColumn(4, false);
        this.data = data;
        this.type = type;
        this.dsn = dsn;
        this.dataDetails = this.getDataDetails();
        this.updateCharts();
    }

    @Override
    public Control getControl() {
        return this.browser;
    }

    private MATTableModel[] getDataDetails() {
        MATTableModel[] result = new MATTableModel[this.data.getRows().length];
        int i = 0;
        this.timeViewData = Singletons.getAnalysisManager(this.browser.getDisplay()).getModel(this.dsn, "TimeView", this.type);
        MATTableRow[] mATTableRowArray = this.data.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            DelayViewRowModel delayRow = (DelayViewRowModel)row;
            HashMap<String, Object[]> delayLocArgs = new HashMap<String, Object[]>();
            delayLocArgs.put("ttype1", new Object[]{delayRow.getTType1()});
            delayLocArgs.put("ttype2", new Object[]{delayRow.getTType2()});
            MATTableModel model = Singletons.getAnalysisManager(this.browser.getDisplay()).getModel(this.dsn, "TimeView", this.type);
            model = model.filterBy(delayLocArgs);
            result[i] = AnalysisUtils.calculateDelayLocations(model, this.dsn, this.type, this.browser.getDisplay());
            result[i].sortByColumn(8, false);
            ++i;
            ++n2;
        }
        return result;
    }

    private String readHTMLFile() {
        BufferedReader reader = null;
        try {
            Bundle bundle = Activator.plugin.getBundle();
            Path path = new Path("HTML/dashboardH.html");
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            StringBuilder stringBuilder = new StringBuilder();
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void changed(ProgressEvent event) {
    }

    public void completed(ProgressEvent event) {
        Job dataPreparation = new Job("Prepare HC dashboard data"){

            protected IStatus run(IProgressMonitor monitor) {
                final String dataJSON = DashboardH.this.createJSON(DashboardH.this.data);
                final String tableData = DashboardH.this.createJSONForTable(DashboardH.this.dataDetails);
                DashboardH.this.browser.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        long time = System.nanoTime();
                        DashboardH.this.runJS("var data = " + dataJSON + ";");
                        DashboardH.this.runJS("var selection = 0;");
                        DashboardH.this.runJS("var tableData = " + tableData + ";");
                        DashboardH.this.runJS("paintChart1();");
                        DashboardH.this.runJS("paintChart2(0, 'Detail');");
                        long difference = System.nanoTime() - time;
                        System.out.println("HC Browser js execution: " + difference / 1000000L);
                        (this).DashboardH.this.ready = true;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        dataPreparation.schedule();
    }

    public void updateCharts() {
        if (this.ready) {
            this.browser.dispose();
            this.browser = new Browser(this.parent, 0);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            this.browser.addProgressListener((ProgressListener)this);
            long time = System.nanoTime();
            this.browser.setText(this.readHTMLFile());
            long difference = System.nanoTime() - time;
            System.out.println("HC Browser set HTML timing: " + difference / 1000000L);
        }
    }

    private void runJS(String jscript) {
        System.out.println("Executing " + jscript);
        boolean success = this.browser.execute(jscript);
        System.out.println("execution " + (success ? "successful" : "failed"));
    }

    public String createJSON(MATTableModel data) {
        Object delayRow;
        int n;
        MATTableRow[] mATTableRowArray;
        System.out.println("get data");
        StringBuilder sb = new StringBuilder();
        sb.append("{chartColors: [\"#ff0000\", \"#00ff00\"], chart1Title: 'Delay View',chart1XLabels: [");
        if (this.type != 3) {
            int i = 0;
            if (data != null) {
                mATTableRowArray = data.getRows();
                n = mATTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MATTableRow row = mATTableRowArray[n2];
                    if (row instanceof DelayViewRowModel) {
                        delayRow = (DelayViewRowModel)row;
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append("'" + ((MATTableRow)delayRow).getText(1) + "'");
                    }
                    if (++i == 5) break;
                    ++n2;
                }
            }
            sb.append("],chart1series: [{name: 'Active',data: [");
            int i1 = 0;
            if (data != null) {
                delayRow = data.getRows();
                int n3 = ((MATTableRow[])delayRow).length;
                n = 0;
                while (n < n3) {
                    MATTableRow row = delayRow[n];
                    if (row instanceof DelayViewRowModel) {
                        DelayViewRowModel delayRow2 = (DelayViewRowModel)row;
                        if (i1 != 0) {
                            sb.append(",");
                        }
                        sb.append(delayRow2.getActive() / 100.0);
                    }
                    if (++i1 == 5) break;
                    ++n;
                }
            }
            sb.append("]}");
        }
        if (this.type != 2 && this.type != 3) {
            sb.append(",");
        }
        if (this.type != 2) {
            sb.append(" {name: 'Wait',data: [");
            int i2 = 0;
            if (data != null) {
                mATTableRowArray = data.getRows();
                n = mATTableRowArray.length;
                int n4 = 0;
                while (n4 < n) {
                    MATTableRow row = mATTableRowArray[n4];
                    if (row instanceof DelayViewRowModel) {
                        delayRow = (DelayViewRowModel)row;
                        if (i2 != 0) {
                            sb.append(",");
                        }
                        sb.append(((DelayViewRowModel)delayRow).getWait() / 100.0);
                    }
                    if (++i2 == 5) break;
                    ++n4;
                }
            }
            sb.append("]}");
        }
        sb.append("],");
        sb.append(this.createJSONForDetails(this.dataDetails));
        sb.append("}");
        System.out.println("data:" + sb.toString());
        return sb.toString();
    }

    public String createJSONForDetails(MATTableModel[] dataDetails) {
        System.out.println("get data");
        StringBuilder sb = new StringBuilder();
        sb.append("subchartsData: [");
        int d = 0;
        while (d < dataDetails.length) {
            DelayLocationRowModel delayRow;
            MATTableRow row;
            int n;
            int n2;
            MATTableRow[] mATTableRowArray;
            MATTableModel data = dataDetails[d];
            if (d != 0) {
                sb.append(",");
            }
            sb.append("{categories: [");
            int i = 0;
            if (data != null) {
                mATTableRowArray = data.getRows();
                n2 = mATTableRowArray.length;
                n = 0;
                while (n < n2) {
                    row = mATTableRowArray[n];
                    if (row instanceof DelayLocationRowModel) {
                        delayRow = (DelayLocationRowModel)row;
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append("'" + delayRow.getText(0) + "'");
                    }
                    if (++i == 5) break;
                    ++n;
                }
            }
            sb.append("],series: [{name: 'Total', data:[");
            i = 0;
            if (data != null) {
                mATTableRowArray = data.getRows();
                n2 = mATTableRowArray.length;
                n = 0;
                while (n < n2) {
                    row = mATTableRowArray[n];
                    if (row instanceof DelayLocationRowModel) {
                        delayRow = (DelayLocationRowModel)row;
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(delayRow.getText(8));
                    }
                    if (++i == 5) break;
                    ++n;
                }
            }
            sb.append("]}]}");
            ++d;
        }
        sb.append("]");
        return sb.toString();
    }

    public String createJSONForTable(MATTableModel[] dataDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int d = 0;
        while (d < dataDetails.length) {
            this.data = dataDetails[d];
            if (d != 0) {
                sb.append(",");
            }
            sb.append("[");
            sb.append("[\"Module\", \"CSECT\", \"Offset\", \"Description\", \"Stmt\", \"D\", \"C\", \"X\", \"Active %\"]");
            int i = 0;
            if (this.data != null) {
                MATTableRow[] mATTableRowArray = this.data.getRows();
                int n = mATTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MATTableRow row = mATTableRowArray[n2];
                    sb.append(",[");
                    if (row instanceof DelayLocationRowModel) {
                        int j = 0;
                        while (j <= 8) {
                            if (j != 0) {
                                sb.append(",");
                            }
                            sb.append("\"" + row.getText(j) + "\"");
                            ++j;
                        }
                    }
                    sb.append("]");
                    if (++i == 5) break;
                    ++n2;
                }
            }
            sb.append("]");
            ++d;
        }
        sb.append("]");
        return sb.toString();
    }

    public void changed(StatusTextEvent event) {
    }

    @Override
    public void updateDashboard(MATTableModel data, String dsn, String profile, int type) {
    }
}

