/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

/**
 * @author polra04
 *
 */
import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.view.wizardpages.CRLClass.LayoutField;
import com.ca.fmp.ims.view.wizards.FileMasterWizard;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class GenericUpdate2Page extends FileMasterWizard implements
		SelectionListener {

	static final String cacopyright = "Copyright  2016 CA";
	protected final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.modifyCLRules"; //$NON-NLS-1$
	
	protected static final String CHARACTER = "C - Character";
	protected static final String NUMERIC = "N - Numeric";
	protected static final String PACKED = "P - Packed";
	protected static final String HEXADECIMAL = "X - Hex";
	protected static final String BINARY = "B - Binary";
	protected static final String TEXT = "T - Text";
	protected static final String FIELD_NAME = "Field Name...";


	protected Text txtRecLayout;
	private Button selectAllClearButton;
	protected Tree topLevelTree;
	protected CheckboxTreeViewer checkboxTreeViewer;

	protected String error;
	protected CRLClass crl;
	protected CRLClass.Layout tempLayout;
	protected int selectedIndex;
	private LayoutField layoutField;
	protected ArrayList<CRLClass.LayoutField> fields;
	public int lineNumber;
	protected boolean[] checkedStatus;
	
	protected boolean selectable;
	protected TreeViewer treeViewer;
	
	private TextCellEditor textEditor;
	private boolean canFinish = false;
	
	public GenericUpdate2Page(String pageName, String title, CRLClass crl, int selectedIndex,
			FileMasterServer server, boolean selectable) {
		super(pageName, crl.getDatasetName(), server);
		this.crl = crl;
		this.tempLayout = crl.getLayout(selectedIndex).getCopy();
		this.selectedIndex = selectedIndex;
		
		this.selectable = selectable;
		
		if(selectable){
			checkedStatus = new boolean[tempLayout.getLayoutFields().size()];
			for(int i = 0; i < checkedStatus.length; i++){
				if(tempLayout.getLayoutFields().get(i).isSelected()){
					checkedStatus[i] = true;
				} else {
					checkedStatus[i] = false;
				}
			}
		}
		setTitle(title);
	}

	@Override
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		setControl(container);
		container.setLayout(new GridLayout(1, false));

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);
		
		Composite compositeTop = new Composite(container, SWT.NONE);
		GridData gd_compositeTop = new GridData(SWT.FILL, SWT.FILL, false, false,
				1, 1);
		gd_compositeTop.widthHint = 267;
		compositeTop.setLayoutData(gd_compositeTop);
		compositeTop.setLayout(new GridLayout(2, false));

		Label lblDataSet = new Label(compositeTop, SWT.NONE);
		lblDataSet.setText("&Record layout:");

		txtRecLayout = new Text(compositeTop, SWT.READ_ONLY);
		txtRecLayout.setEditable(false);
		GridData gd_txtRecLayout = new GridData(SWT.FILL, SWT.CENTER, true,
				false, 1, 1);
		gd_txtRecLayout.widthHint = 280;
		txtRecLayout.setLayoutData(gd_txtRecLayout);
		
		txtRecLayout.setText(crl.getLayout(selectedIndex).getLayoutDataset()
				+ "(" + crl.getLayout(selectedIndex).getLayoutMember() + ")");
		txtRecLayout.addTraverseListener(new TraverseListener(){
			@Override
			public void keyTraversed(TraverseEvent e) {
				if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
					if(topLevelTree.getSelection().length == 0){
						topLevelTree.setSelection((TreeItem)
								getTreeItems(topLevelTree.getItems())[0]);
					}
       				topLevelTree.setFocus();
				}
			}
		});

		Composite compositeTable = new Composite(container, SWT.NONE);
		GridData gd_compositeTable = new GridData(SWT.FILL, SWT.FILL, true,
				true, 1, 1);
		gd_compositeTable.heightHint = 249;
		compositeTable.setLayoutData(gd_compositeTable);
		compositeTable.setLayout(new GridLayout(1, false));
		
		createViewer(compositeTable);
		
		if(selectable){
			checkboxTreeViewer.setContentProvider(new ITreeContentProvider(){

				@Override
				public void dispose() {
				}

				@Override
				public void inputChanged(Viewer viewer, Object oldInput,
						Object newInput) {
				}

				@Override
				public Object[] getElements(Object inputElement) {
					ArrayList<CRLClass.LayoutField> elements = new ArrayList<CRLClass.LayoutField>();
					for(int i = 0; i < fields.size(); i++){
						if(fields.get(i).getLevel() == 1){
							elements.add(fields.get(i));
						}
					}
					
					return elements.toArray();
				}

				@Override
				public Object[] getChildren(Object parentElement) {
					CRLClass.LayoutField e = (CRLClass.LayoutField)parentElement;
					int index = getIndex(e);
					int childrenLevel = fields.get(index + 1).getLevel();
					
					ArrayList<CRLClass.LayoutField> children = new ArrayList<CRLClass.LayoutField>(); 
					for(int i = index + 1; i < fields.size(); i++){
						if(fields.get(i).getLevel() == childrenLevel){
							children.add(fields.get(i));
						} else if (fields.get(i).getLevel() < childrenLevel && fields.get(i).getLevel() > e.getLevel()){
							children.add(fields.get(i));
							childrenLevel = fields.get(i).getLevel();
						} else if(fields.get(i).getLevel() == e.getLevel()){
							break;
						}
					}
					
					return children.toArray();
				}

				@Override
				public Object getParent(Object element) {
					return null;
				}

				@Override
				public boolean hasChildren(Object element) {
					CRLClass.LayoutField e = (CRLClass.LayoutField)element;
					int index = getIndex(e); 
					
					if(index + 1 < fields.size()){
						if(fields.get(index + 1).getLevel() > e.getLevel()){
							return true;
						} else {
							return false;
						}
					}
					return false;
				}
				
			});
			checkboxTreeViewer.setInput(null);
			checkboxTreeViewer.addCheckStateListener(new ICheckStateListener() {
				
				@Override
				public void checkStateChanged(CheckStateChangedEvent event) {
					for(int i = 0; i < fields.size(); i++){
						if(fields.get(i).equals(event.getElement())){
							checkedStatus[i] = !checkedStatus[i];
							break;
						}
					}
				}
			});
			
			selectAllClearButton = new Button(compositeTable, SWT.NONE);
			GridData gd_selectAllClearButton = new GridData(SWT.LEFT, SWT.CENTER,
					false, false, 1, 1);
			gd_selectAllClearButton.widthHint = 120;
			selectAllClearButton.setLayoutData(gd_selectAllClearButton);
			selectAllClearButton.setText("Select &All");
			selectAllClearButton.addSelectionListener(this);
			
			selectAllClearButton.addTraverseListener(new TraverseListener(){
				@Override
				public void keyTraversed(TraverseEvent e) {
					if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS) {
						int selectedElement;
						
						if(topLevelTree.getSelection().length == 0){
							selectedElement = getTreeItemCount(topLevelTree.getItems()) - 1;
							topLevelTree.setSelection((TreeItem)
									getTreeItems(topLevelTree.getItems())[selectedElement]);
						} else {
							selectedElement = getIndex(topLevelTree.getItems(),
									topLevelTree.getSelection()[topLevelTree.getSelection().length - 1]);	
						}
						
						checkboxTreeViewer.editElement(fields.get(selectedElement), 6);
	       				topLevelTree.setFocus();
					}
				}
			});
		} else {
			treeViewer.setContentProvider(new ITreeContentProvider(){

				@Override
				public void dispose() {
				}

				@Override
				public void inputChanged(Viewer viewer, Object oldInput,
						Object newInput) {
				}

				@Override
				public Object[] getElements(Object inputElement) {
					ArrayList<CRLClass.LayoutField> elements = new ArrayList<CRLClass.LayoutField>();
					for(int i = 0; i < fields.size(); i++){
						if(fields.get(i).getLevel() == 1){
							elements.add(fields.get(i));
						}
					}
					
					return elements.toArray();
				}

				@Override
				public Object[] getChildren(Object parentElement) {
					CRLClass.LayoutField e = (CRLClass.LayoutField)parentElement;
					int index = getIndex(e);
					int childrenLevel = fields.get(index + 1).getLevel();
					
					ArrayList<CRLClass.LayoutField> children = new ArrayList<CRLClass.LayoutField>(); 
					for(int i = index + 1; i < fields.size(); i++){
						if(fields.get(i).getLevel() == childrenLevel){
							children.add(fields.get(i));
						} else if (fields.get(i).getLevel() < childrenLevel && fields.get(i).getLevel() > e.getLevel()){
							children.add(fields.get(i));
							childrenLevel = fields.get(i).getLevel();
						} else if(fields.get(i).getLevel() == e.getLevel()){
							break;
						}
					}
					
					return children.toArray();
				}

				@Override
				public Object getParent(Object element) {
					return null;
				}

				@Override
				public boolean hasChildren(Object element) {
					CRLClass.LayoutField e = (CRLClass.LayoutField)element;
					int index = getIndex(e); 
					
					if(index + 1 < fields.size()){
						if(fields.get(index + 1).getLevel() > e.getLevel()){
							return true;
						} else {
							return false;
						}
					}
					return false;
				}
				
			});
			treeViewer.setInput(null);
			
			((TestingToolsWizardDialog) getWizard().getContainer()).getButton(
					IDialogConstants.FINISH_ID).addTraverseListener(new TraverseListener(){
					@Override
					public void keyTraversed(TraverseEvent e) {
						if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS) {
							int selectedElement;
							
							if(topLevelTree.getSelection().length == 0){
								selectedElement = getTreeItemCount(topLevelTree.getItems()) - 1;
								topLevelTree.setSelection((TreeItem)
										getTreeItems(topLevelTree.getItems())[selectedElement]);
							} else {
								selectedElement = getIndex(topLevelTree.getItems(),
										topLevelTree.getSelection()[topLevelTree.getSelection().length - 1]);	
							}
							
							treeViewer.editElement(fields.get(selectedElement), 6);
		       				topLevelTree.setFocus();
						}
					}
			});
		}

		((TestingToolsWizardDialog) getWizard().getContainer()).getButton(
				IDialogConstants.FINISH_ID).setText("OK");
		treeUpdate();
		
		txtRecLayout.setFocus();
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	protected void createViewer(Composite parent) {
		if(selectable){
			checkboxTreeViewer = new CheckboxTreeViewer(parent,
					SWT.BORDER | SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.MULTI);

			checkboxTreeViewer.addCheckStateListener(new ICheckStateListener() {
				@Override
				public void checkStateChanged(CheckStateChangedEvent event) {
					if (checkboxTreeViewer.getCheckedElements().length == 
							getTreeItemCount(checkboxTreeViewer.getTree().getItems())) {
						selectAllClearButton.setText("&Clear Selections");
					} else {
						selectAllClearButton.setText("Select &All");
					}
				}
			});

			topLevelTree = checkboxTreeViewer.getTree();
		} else {
			treeViewer = new TreeViewer(parent, SWT.BORDER
					| SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI);
			setTreeViewer(treeViewer);

			topLevelTree = treeViewer.getTree();
		}
		
		topLevelTree.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		topLevelTree.setLinesVisible(true);
		topLevelTree.setHeaderVisible(true);
		topLevelTree.setFocus();
		
		topLevelTree.addListener(SWT.MouseDown, new Listener() {
			public void handleEvent(Event event) {
				Point pt = new Point(event.x, event.y);
				TreeItem item = topLevelTree.getItem(pt);
				if (item == null) {
					topLevelTree.setMenu(null);
					return;
				}
				for (int i = 0; i < topLevelTree.getColumnCount(); i++) {
					Rectangle rect = item.getBounds(i);
					if (rect.contains(pt)) {
						
						if(i == (topLevelTree.getColumnCount() - 1)) {
							lineNumber = getIndex(topLevelTree.getItems(), item);
							Object[] obj;
							if(selectable){
								obj  = (Object[]) checkboxTreeViewer.getInput();
							} else {
								obj  = (Object[]) treeViewer.getInput();
							}
							layoutField = (CRLClass.LayoutField) obj[lineNumber];
							
							String formatType = layoutField.getFormatType();
							
							topLevelTree.setMenu(buildTableMenu(formatType));
						} else {
							topLevelTree.setMenu(null);
						}
					}
				}
			}
			
		});
		
		topLevelTree.addTraverseListener(new TraverseListener(){
			@Override
			public void keyTraversed(TraverseEvent e) {
				if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
					
					if(topLevelTree.getSelection().length == 0){
						topLevelTree.setSelection((TreeItem)getTreeItems(topLevelTree.getItems())[0]);
						e.doit = false;
					} else {
						int selectedElement = getIndex(topLevelTree.getItems(), topLevelTree.getSelection()[0]);
						
						if(selectable){
							checkboxTreeViewer.editElement(fields.get(selectedElement), 4);	
						} else {
							treeViewer.editElement(fields.get(selectedElement), 4);
						}
					}
        			
        		} else if(e.detail == SWT.TRAVERSE_TAB_PREVIOUS){

        			if(topLevelTree.getSelection().length == 0){
						if(selectable){
							checkboxTreeViewer.editElement(fields.get(getTreeItems(topLevelTree.getItems()).length - 1), 6);
						} else {
							treeViewer.editElement(fields.get(getTreeItems(topLevelTree.getItems()).length - 1), 6);	
						}
						e.doit = false;
        			} else {
        				int selectedElement = getIndex(topLevelTree.getItems(),
        						topLevelTree.getSelection()[topLevelTree.getSelection().length - 1]);
        				
        				if(selectedElement > 0){
        					if(selectable){
            					checkboxTreeViewer.editElement(fields.get(selectedElement - 1), 6);	
            				} else {
            					treeViewer.editElement(fields.get(selectedElement - 1), 6);
            				}
            				e.doit = false;
        				} else {
        					topLevelTree.setSelection(new TreeItem[0]);
            				txtRecLayout.setFocus();
        				}
        			}
        		}
			}
		});
		
		createColumns();
	}
	
	public void createMenuItem(Menu menu, String text) {
		final MenuItem menuItem = new MenuItem(menu, SWT.PUSH);
		menuItem.setText(text);
		menuItem.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				String value = fields.get(lineNumber).getValue();
				if (((MenuItem) event.widget).getText().equals(FIELD_NAME)) {
					dialog = new TestingToolsWizardDialog(getShell(),
							new GenericFieldNameWizard(crl.getLayout(selectedIndex).getLayoutDataset(),
									crl.getLayout(selectedIndex).getLayoutMember()));
					dialog.create();
					dialog.open();
				} else if(!value.matches("([CTXPBN]*\\d*['\"]?[0-9A-Za-z]*['\"]?\\s*)*")) {
					value = "";
				} 
				if (((MenuItem) event.widget).getText().equals(CHARACTER)) {
					fields.get(lineNumber).setValue(value + " C'' ");
				} else if (((MenuItem) event.widget).getText().equals(TEXT)) {
					fields.get(lineNumber).setValue(value + " T'' ");
				} else if (((MenuItem) event.widget).getText().equals(HEXADECIMAL)) {
					fields.get(lineNumber).setValue(value + " X'' ");
				} else if (((MenuItem) event.widget).getText().equals(PACKED)) {
					fields.get(lineNumber).setValue(value + " P'' ");
				} else if (((MenuItem) event.widget).getText().equals(BINARY)) {
					fields.get(lineNumber).setValue(value + " B'' ");
				} else if (((MenuItem) event.widget).getText().equals(NUMERIC)) {
					fields.get(lineNumber).setValue(value + " N'' ");
				}
				checkboxTreeViewer.refresh();
			}
		});
	}	
	
	private Menu buildTableMenu(String type) {
		
		Menu tableMenu = new Menu(getShell(), SWT.POP_UP);
		
		if(type.equals("C") || type.equals("A")) {
			createMenuItem(tableMenu, CHARACTER);
			createMenuItem(tableMenu, TEXT);
		} else if(type.equals("PS") || type.equals("P")) {
			createMenuItem(tableMenu, NUMERIC);
			createMenuItem(tableMenu, PACKED);
		} else if(type.equals("NS") || type.equals("N") || type.equals("BS") || type.equals("B")) {
			createMenuItem(tableMenu, NUMERIC);
		}
		
		createMenuItem(tableMenu, HEXADECIMAL);
		new MenuItem(tableMenu, SWT.SEPARATOR);
		createMenuItem(tableMenu,FIELD_NAME);
		
		return tableMenu;
	}

	public void getSelectedfields(String fieldsName) {
		//String[] tokens = tableItems[0].getText().split("\\s");
		 fields.get(lineNumber).setValue(fieldsName);
		 setPageComplete(isPageComplete());
	}

	protected void createColumns() {
		String[] titles = { "Field Name", "Position", "Type", "Format",
				"And/Or", "Operator", "Compare Value or Field Name" };
		int[] bounds = { 210, 55, 95, 60, 80, 130, 210 };
		
		for (int i = 0; i < titles.length; i++) {
			final Tree tree;
			TreeViewerColumn treeViewerColumn;
			
			if(selectable){
				treeViewerColumn = new TreeViewerColumn(checkboxTreeViewer, SWT.NONE);
				tree = checkboxTreeViewer.getTree();
			}
			else {
				treeViewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
				tree = treeViewer.getTree();
			}
			
			TreeColumn treeColumn = treeViewerColumn.getColumn();

			treeColumn.setText(titles[i]);
			treeColumn.setWidth(bounds[i]);
			
			switch (i) {
			case 0: //Field Name
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return crlLayoutField.getLevelField();
					}
				});
				break;
			case 1: //Position
				treeViewerColumn.getColumn().setAlignment(SWT.RIGHT); 			
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return Integer.toString(crlLayoutField.getPosition());
					}
				});
				break;
			case 2: //Type
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return crlLayoutField.getFormatString().equalsIgnoreCase("A") ? "Character" : crlLayoutField.getFormatString();
					}
				});
				break;
			case 3: //Format
				treeViewerColumn.getColumn().setAlignment(SWT.RIGHT);			
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						//return String.valueOf(crlLayoutField.getLength()==0? "" : crlLayoutField.getLength());
						//return crlLayoutField.getFormatLength();
						if(crlLayoutField.getFormatDec()!= 0){
							return crlLayoutField.getFormatNum() + "." + crlLayoutField.getFormatDec();
						}
						else if(crlLayoutField.getFormatNum() != 0){
							return String.valueOf(crlLayoutField.getFormatNum());
						}
						else{
							return crlLayoutField.getFormatLength();
						}
					}
				});
				break;												
			case 4: //And/Or
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						if(crlLayoutField.getLogOperator() == CRLClass.NONE){
							return "";
						} else {
							return CRLClass.logOperators[crlLayoutField.getLogOperator()];	
						}
					}
				});
				
				treeViewerColumn.setEditingSupport(new EditingSupport(
						treeViewerColumn.getViewer()) {
					@Override
					protected void setValue(Object element, Object value) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						crlLayoutField.setLogOperator((Integer)value);
						if(selectable){
							checkboxTreeViewer.refresh();
						} else {
							treeViewer.refresh();
						}
					}

					@Override
					protected Object getValue(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return crlLayoutField.getLogOperator();
					}

					@Override
					protected CellEditor getCellEditor(Object element) {
						ComboBoxCellEditor comboEditor = new ComboBoxCellEditor(
								tree, CRLClass.logOperators, SWT.READ_ONLY);
						((CCombo)comboEditor.getControl()).addSelectionListener(new SelectionListener(){
							@Override
							public void widgetSelected(SelectionEvent e) {
								canFinish = true;
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
						comboEditor.getControl().addTraverseListener(new TraverseListener(){
							@Override
							public void keyTraversed(TraverseEvent e) {
								int selectedElement = getIndex(topLevelTree.getItems(), topLevelTree.getSelection()[0]);
								if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
									if(selectable){
										checkboxTreeViewer.editElement(fields.get(selectedElement), 5);	
									} else {
										treeViewer.editElement(fields.get(selectedElement), 5);
									}
				        		} else if(e.detail == SWT.TRAVERSE_TAB_PREVIOUS){
			        				topLevelTree.setSelection((TreeItem)
			        						getTreeItems(topLevelTree.getItems())[selectedElement]);	
			        				e.doit = false;
				        		}
								canFinish = true;
							}
						});
						
						return comboEditor;
					}

					@Override
					protected boolean canEdit(Object element) {
						return true;
					}
				});
				
				break;
			case 5: //Operator
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						if(crlLayoutField.getOperator() == CRLClass.NONE){
							return "";
						} else {
							return CRLClass.operators[crlLayoutField.getOperator()];	
						}
					}
				});
				
				treeViewerColumn.setEditingSupport(new EditingSupport(
						treeViewerColumn.getViewer()) {
					@Override
					protected void setValue(Object element, Object value) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						if((Integer)value < 0 || (Integer)value > 7){
							crlLayoutField.setOperator(0);
						} else {
							crlLayoutField.setOperator((Integer)value);	
						}
						if(crlLayoutField.getOperator() == CRLClass.NONE){
							crlLayoutField.setLogOperator(CRLClass.NONE);
							crlLayoutField.setValue("");
						}
						if(selectable){
							checkboxTreeViewer.refresh();
						} else {
							treeViewer.refresh();
						}
						setPageComplete(isPageComplete());
					}

					@Override
					protected Object getValue(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return crlLayoutField.getOperator();
					}

					@Override
					protected CellEditor getCellEditor(Object element) {
						final Object cellElement = element;
						final ComboBoxCellEditor comboEditor = new ComboBoxCellEditor(
								tree, CRLClass.operators, SWT.READ_ONLY);
						((CCombo)comboEditor.getControl()).setVisibleItemCount(8);
						((CCombo)comboEditor.getControl()).addSelectionListener(new SelectionListener(){
							@Override
							public void widgetSelected(SelectionEvent e) {
								for(int i = 0; i < getTreeItemCount(tree.getItems()); i++){
									
									CRLClass.LayoutField field;
									field = (LayoutField)((TreeItem)getTreeItems(tree.getItems())[i]).getData();
									
									if(((CRLClass.LayoutField)cellElement).equals(field)){
										
										fields.get(i)
												.setOperator(((CCombo)comboEditor.getControl()).getSelectionIndex());
										
										setPageComplete(isPageComplete());
										break;
									}
								}
								canFinish = true;
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
							}
						});
						
						comboEditor.getControl().addTraverseListener(new TraverseListener(){
							@Override
							public void keyTraversed(TraverseEvent e) {
								int selectedElement = getIndex(topLevelTree.getItems(), topLevelTree.getSelection()[0]);
								if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
									if(selectable){
										checkboxTreeViewer.editElement(fields.get(selectedElement), 6);	
									} else {
										treeViewer.editElement(fields.get(selectedElement), 6);
									}
				        		} else if(e.detail == SWT.TRAVERSE_TAB_PREVIOUS){
				        			if(selectable){
				        				checkboxTreeViewer.editElement(fields.get(selectedElement), 4);	
				        			} else {
				        				treeViewer.editElement(fields.get(selectedElement), 4);
				        			}
				        		}
								canFinish = true;
							}
						});
						
						return comboEditor;
					}

					@Override
					protected boolean canEdit(Object element) {
						return true;
					}
				});
				
				break; 
			case 6: //Compare Value or Field Name
				treeViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return crlLayoutField.getValue();
					}
				});
				
				treeViewerColumn.setEditingSupport(new EditingSupport(
						treeViewerColumn.getViewer()) {
					
					@Override
					protected void setValue(Object element, Object value) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						crlLayoutField.setValue((String)value);
						if(selectable){
							checkboxTreeViewer.refresh();
						} else {
							treeViewer.refresh();
						}
					}

					@Override
					protected Object getValue(Object element) {
						CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField) element;
						return crlLayoutField.getValue();
					}

					@Override
					protected CellEditor getCellEditor(Object element) {
						textEditor = new TextCellEditor(tree);
						
						if(selectable){
							((Text) textEditor.getControl()).setTextLimit(32);
						}
						((Text) textEditor.getControl())
								.addModifyListener(new ModifyListener() {
									@Override
									public void modifyText(ModifyEvent e) {
										Widget source = e.widget;
										
										if(tree.getSelectionCount() == 1){
											int index = getIndex(tree.getItems(), tree.getSelection()[0]);
											fields.get(index).setValue(
													((Text) textEditor.getControl()).getText());
											if (source instanceof Text) {
													setPageComplete(isPageComplete());
												}
											}
										canFinish = true;
										}
									
								});
										
						((Text)textEditor.getControl()).addFocusListener(new FocusListener()
						{
							@Override
							public void focusGained(
									org.eclipse.swt.events.FocusEvent e) {
							}

							@Override
							public void focusLost(
									org.eclipse.swt.events.FocusEvent e) {
								setPageComplete(isPageComplete());
								
							}								
						});
						
						Object obj;
						if(selectable){
							obj  = ((StructuredSelection)checkboxTreeViewer.getSelection()).getFirstElement();
						} else {
							obj  = ((StructuredSelection)treeViewer.getSelection()).getFirstElement();
						}
						layoutField = (LayoutField) obj;
						String type = layoutField.getFormatType();
						textEditor.getControl().setMenu(buildTableMenu(type));
						
						textEditor.getControl().addTraverseListener(new TraverseListener(){
							@Override
							public void keyTraversed(TraverseEvent e) {
								int selectedElement = getIndex(topLevelTree.getItems(), topLevelTree.getSelection()[0]);
								
								if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
									if(getTreeItemCount(topLevelTree.getItems()) == selectedElement + 1){
										topLevelTree.setSelection(new TreeItem[0]);
										e.doit = true;
									} else {
										
										if(selectable){
											checkboxTreeViewer.cancelEditing();
											checkboxTreeViewer.refresh();
										} else {
											treeViewer.cancelEditing();
											treeViewer.refresh();
										}
										
										topLevelTree.setSelection((TreeItem)
												getTreeItems(topLevelTree.getItems())[selectedElement + 1]);
										e.doit = false;
									}
				        		} else if(e.detail == SWT.TRAVERSE_TAB_PREVIOUS){
				        			if(selectable){
				        				checkboxTreeViewer.editElement(fields.get(selectedElement), 5);	
				        			} else {
				        				treeViewer.editElement(fields.get(selectedElement), 5);
				        			}
				        		}
							}
						});
						//@parra12: Following line of code enables the limit of 55 characters in the compare value column.
						((Text) textEditor.getControl()).setTextLimit(55);
						return textEditor;
					}

					@Override
					protected boolean canEdit(Object element) {
						return true;
					}
					
				});
				
				break;
			}
		}
		
		if(selectable){
			checkboxTreeViewer.getControl().addDisposeListener(new DisposeListener(){
				@Override
				public void widgetDisposed(DisposeEvent e) {
					if (textEditor != null) textEditor.deactivate();
				}
			});
		} else {
			treeViewer.getControl().addDisposeListener(new DisposeListener(){
				@Override
				public void widgetDisposed(DisposeEvent e) {
					if (textEditor != null) textEditor.deactivate();
				}
			});
		}
	}
	


	public void treeUpdate() {
		fields = tempLayout.getLayoutFields();
		
		if(selectable){
			checkboxTreeViewer.getTree().setRedraw(false);
			checkboxTreeViewer.setUseHashlookup(true);
			checkboxTreeViewer.setInput(fields.toArray(new Object[fields.size()]));
			checkboxTreeViewer.refresh();
			checkboxTreeViewer.expandToLevel(AbstractTreeViewer.ALL_LEVELS);
			LayoutField lf;
			for(int i = 0; i < fields.size(); i++){
				lf = fields.get(i);
				if(lf.isSelected()){
					checkboxTreeViewer.setChecked(lf, true);
				}
			}
			checkboxTreeViewer.getTree().setRedraw(true);
		} else {
			treeViewer.setUseHashlookup(true);
			treeViewer.setInput(fields.toArray(new Object[fields.size()]));
			treeViewer.refresh();
			treeViewer.expandToLevel(AbstractTreeViewer.ALL_LEVELS);
		}
		
		setPageComplete(isPageComplete());
	}
	
	public void setTreeViewer(TreeViewer treeViewer){
		this.treeViewer = treeViewer;
	}

	@Override
	public boolean isPageComplete() {
		error = "";
		boolean atLeastOneCondition = false;
		boolean returnVal = false;
							
		returnVal = super.isPageComplete();
		if (returnVal==false)
			return false;
		
		int itemCount = fields.size();
			
		Tree tree;
		if(selectable){
			if(itemCount == 0){
				error = error + "Insert at least one layout\n ";
				returnVal = false;
				selectAllClearButton.setEnabled(false);
			} else {
				if (checkboxTreeViewer.getCheckedElements().length == itemCount){
					selectAllClearButton.setText("&Clear Selections");
				} else {
					selectAllClearButton.setText("Select &All");
				}
				selectAllClearButton.setEnabled(true);
			}
			tree = checkboxTreeViewer.getTree();
		} else {
			tree = treeViewer.getTree();
		}

		String value;
		int operator, logOperator;
		// Compare Value or Field Name validation
		for (int i = 0; i < itemCount; i++) 
		{							
			LayoutField lf = fields.get(i);
			
			value       = lf.getValue();
			operator    = lf.getOperator();
			logOperator = lf.getLogOperator();
			
			if(value.length() == 0 && operator == CRLClass.NONE && logOperator == CRLClass.NONE){
				continue;
			}
			
			String fieldName  = lf.getField();
			String formatType = lf.getFormatType().equals("A") ? "C" : lf.getFormatType();
			/*if(formatType.equals("N") || formatType.equals("P") || formatType.equals("B"))
				formatType += "S";*/
			int length		  = lf.getLength();
			int formatNum     = lf.getFormatNum();
			int formatDec     = lf.getFormatDec();
			
			if(atLeastOneCondition == false && value.trim().length() > 0){
				atLeastOneCondition = true;
			}
			
			switch (Validator.CLConditionField(value, formatType,formatNum,formatDec, length, true)) {
				case Validator.NO_ERROR:
					break;					
				case Validator.CL_NON_MATCHING_QUOTES:
					error = error + Validator.errorMsg[Validator.CL_NON_MATCHING_QUOTES] + " in field name " + fieldName+"\n ";						
					break;
				case Validator.CL_UNSUPPORTED_CHARS:
					error = error + Validator.errorMsg[Validator.CL_UNSUPPORTED_CHARS]  + " in field name " + fieldName+"\n ";
					break;						
				case Validator.CL_TOO_LONG:
					error = error + Validator.errorMsg[Validator.CL_TOO_LONG] + " in field name " + fieldName+"\n ";
					break;						
				case Validator.CL_INCOMPATIBILE_TYPE:
					error = error + Validator.errorMsg[Validator.CL_INCOMPATIBILE_TYPE]  + " in field name " + fieldName+"\n ";
					break;						
				case Validator.CL_INVALID:
					error = error + Validator.errorMsg[Validator.CL_INVALID]  + " in field name " + fieldName+"\n ";
					break;								
				case Validator.CL_FORMAT_ERROR:
					error = error + Validator.errorMsg[Validator.CL_FORMAT_ERROR] + " in field name " + fieldName+"\n ";
					break;
				case Validator.CL_FIELD_NAME:
					boolean fieldFound = false;
					LayoutField compareToField;
					Object[] treeItems = getTreeItems(tree.getItems());
					for (int j = 0; j < treeItems.length; j++){	
						compareToField = ((LayoutField)((TreeItem)treeItems[j]).getData());
						
						if (value.trim().toUpperCase().equals(compareToField.getField())){	
							fieldFound = true;
						    compareToField = ((LayoutField)((TreeItem)treeItems[j]).getData());
						  //@parra12: removed to fix defect 3222
							/*if (!(length == compareToField.getLength()
								  )){
								error = error + "Length of " + compareToField.getField() + " field name does not match length of " + fieldName + " field name\n ";
							}
							if (!(formatType.equalsIgnoreCase(compareToField.getFormatType()))){
								error = error + "Type of " + compareToField.getField() + "  field name does not match type of " + fieldName + " field name\n";
							}*/
							break;							
						}	
					}
					if (!fieldFound)	
						error = error + "Field name "+value.trim()+" was not found in the layout. Error in field name " + fieldName+"\n ";
					break;					
				case Validator.CL_WHITE_SPACE:
					error = error + Validator.errorMsg[Validator.CL_INVALID]  + " in field name " + fieldName+"\n ";
					break;
				case Validator.CL_VALUE_NOT_IN_QUOTES:
					error = error + Validator.errorMsg[Validator.CL_VALUE_NOT_IN_QUOTES]  + " in field name " + fieldName+"\n ";
					break;
				case Validator.CL_EMPTY_VALUE:
					error = error + Validator.errorMsg[Validator.CL_EMPTY_VALUE]  + " in field name " + fieldName+"\n ";
					break;
				case Validator.Hexadecimal_LENGTH_INVALID:
					error = error + Validator.errorMsg[Validator.Hexadecimal_LENGTH_INVALID]  + " in field name " + fieldName+"\n ";
					break;
			}
			
			if(((LayoutField)((TreeItem)getTreeItems(tree.getItems())[i]).getData())!=null){
			if(((LayoutField)((TreeItem)getTreeItems(tree.getItems())[i]).getData()).getOperator() == CRLClass.NONE
					&& value.length() > 0){
				error = error + "Missing operator in field name " + fieldName+"\n ";
			}
			
			if(((LayoutField)((TreeItem)getTreeItems(tree.getItems())[i]).getData()).getOperator() != CRLClass.NONE
					&& value.length() == 0){
				error = error + "Missing compare value in field name " + fieldName+"\n ";
			}
		}
		}
		if (error.length() > 0) {
			setErrorMessage(error);
			return false;
		}
		
		/*if(!selectable && atLeastOneCondition == false){
			return false;
		}*/
		
		setErrorMessage(null);
		return true && canFinish;						
	}

	@Override
	public void modifyText(ModifyEvent e) {
		setPageComplete(isPageComplete());
	}

	public boolean doFinish() {
	
		return true;
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		if(e.getSource() == selectAllClearButton){
			if (selectAllClearButton.getText() == "Select &All") {
				for(int i = 0; i < checkedStatus.length; i++){
					checkedStatus[i] = true;
					checkboxTreeViewer.setChecked(fields.get(i), true);
				}
				selectAllClearButton.setText("&Clear Selections");
			} else {
				selectAllClearButton.setText("Select &All");
				for(int i = 0; i < checkedStatus.length; i++){
					checkedStatus[i] = false;
					checkboxTreeViewer.setChecked(fields.get(i), false);
				}
			}
		}
	}
	
	private int getIndex(CRLClass.LayoutField element){
		for(int i = 0; i < fields.size(); i++){
			if(fields.get(i).equals(element)){
				return i;
			}
		}
		return -1;
	}
	
	private int getIndex(TreeItem[] rootItems, TreeItem item){
		int index = -1;
		ArrayList<TreeItem> items = new ArrayList<TreeItem>();

		for(int i = 0; i < rootItems.length; i++){
			if(rootItems[i].getItemCount() > 0){
				items.add(rootItems[i]);
				items.addAll(getSubTree(rootItems[i]));
			} else {
				items.add(rootItems[i]);
			}
		}

		for(int i = 0; i < items.size(); i++){
			if(items.get(i).equals(item)){
				return i;
			}
		}
		
		return index;
	}

	private ArrayList<TreeItem> getSubTree(TreeItem treeItem){
		ArrayList<TreeItem> temp = new ArrayList<TreeItem>();

		TreeItem[] t = treeItem.getItems();
		for(int i = 0; i < t.length; i++){
			if(t[i].getItemCount() > 0){
				temp.add(t[i]);
				temp.addAll(getSubTree(t[i]));
			} else {
				temp.add(t[i]);
			}
		}
		return temp;
	}
	
	protected int getTreeItemCount(TreeItem[] rootItems){
		ArrayList<TreeItem> items = new ArrayList<TreeItem>();

		for(int i = 0; i < rootItems.length; i++){
			if(rootItems[i].getItemCount() > 0){
				items.add(rootItems[i]);
				items.addAll(getSubTree(rootItems[i]));
			} else {
				items.add(rootItems[i]);
			}
		}
		return items.size();
	}
	
	protected Object[] getTreeItems(TreeItem[] rootItems){
		ArrayList<TreeItem> items = new ArrayList<TreeItem>();

		for(int i = 0; i < rootItems.length; i++){
			if(rootItems[i].getItemCount() > 0){
				items.add(rootItems[i]);
				items.addAll(getSubTree(rootItems[i]));
			} else {
				items.add(rootItems[i]);
			}
		}
		return items.toArray();
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
	}	
}
