/***********************************************************************

Copyright (c) 2017 CA.  All rights reserved.

This software and all information contained therein is confidential and
proprietary and shall not be duplicated, used, disclosed or disseminated
in any way except as authorized by the applicable license agreement,
without the express written permission of CA ("CA"). All authorized
reproductions must be marked with this language.

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT
PERMITTED BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY
OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL
CA BE LIABLE TO THE END USER OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE,
DIRECT OR INDIRECT, FROM THE USE OF THIS SOFTWARE, INCLUDING WITHOUT
LIMITATION, LOST PROFITS, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA,
EVEN IF CA IS EXPRESSLY ADVISED OF SUCH LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.serverwizards;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.model.GetMemberRequestType;
import com.ca.fmp.ims.model.ManagePrefsRequest;
import com.ca.fmp.ims.model.generated.DataSetInfoType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.GetMemberType;
import com.ca.fmp.ims.model.generated.ManagePrefsResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsType;
import com.ca.fmp.ims.model.generated.MemberTypeType;
import com.ca.fmp.ims.model.generated.PrefsActionType;
import com.ca.fmp.ims.model.generated.PrefsParmFilesType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.databaselist.DatabaseListView;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.TestingToolsActivator;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.core.IConstants;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyDigit;

/**
 * TODO: EC - add more documentation.
 * What does this class do.
 *
 * @author navri01
 */
public class AddServerWizardPage extends WizardPage implements ModifyListener, SelectionListener {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	Logger log = Logger.getLogger(getClass().getName());
	private Text name;
	private Text host;
	private Text port;
	private FileMasterServer server = null;
	private FMServerTreeModel model = FMServerTreeModel.getInstance();
	private boolean newserver = true;
	private boolean changed = false;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.fmp.ims.help.serverWizardPageNew"; //$NON-NLS-1$
    private final String OLD_CONTEXT_HELP_ID = "com.ca.fmp.ims.help.serverWizardPageOld"; //$NON-NLS-1$
	private Combo protocol;

	/**
	 * TODO: EC why do you have two constructors.
	 * @param pageName
	 * @param title
	 * @param titleImage
	 */
	public AddServerWizardPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
		setDescription("Specify Server Details"); 
	}

	public AddServerWizardPage() {
		super("");
	}

	/*
	 * TODO: EC - usually methods start with small caps first.. Why is it different here.
	 */
	public void SetServer (FileMasterServer server){
		this.server = server;
		newserver = (server==null)?true:false;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		// TODO: EC use another method since this is deprecated
		ScopedPreferenceStore store = new ScopedPreferenceStore(new ConfigurationScope(), TestingToolsActivator.PLUGIN_ID);

		GridData data;
		Label label;

		Composite top = new Composite(parent, SWT.NONE);
		top.setLayout(new GridLayout(1,false));
		Composite two_col = new Composite(top, SWT.NONE);
		two_col.setLayout(new GridLayout(2,false));
		label = new Label (two_col, SWT.NONE);
		label.setText("&Name:"); 
		label.setAlignment(SWT.RIGHT);
		data = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
        data.grabExcessHorizontalSpace = false;
//        data.horizontalAlignment = GridData.END;
        label.setLayoutData(data);

		name = new Text(two_col, SWT.BORDER);
		data =  new GridData(GridData.FILL_HORIZONTAL);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = GridData.BEGINNING;
		name.setLayoutData(data);

		label = new Label (two_col, SWT.NONE);
		label.setText("&Host:"); 
		label.setAlignment(SWT.RIGHT);
		data = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
        data.grabExcessHorizontalSpace = false;
//        data.horizontalAlignment = GridData.END;
        label.setLayoutData(data);
		host = new Text(two_col, SWT.BORDER);
		data =  new GridData(GridData.FILL_HORIZONTAL);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = GridData.BEGINNING;
		host.setLayoutData(data);

		label = new Label (two_col, SWT.NONE);
		label.setText("&Port:"); 
		label.setAlignment(SWT.RIGHT);
		data = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
        data.grabExcessHorizontalSpace = false;
//        data.horizontalAlignment = GridData.END;
        label.setLayoutData(data);
		port = new Text(two_col, SWT.BORDER);
		port.setTextLimit(5);
		port.setToolTipText(String.format("Port must be number not greater than %d", 0xffff)); 
		data =  new GridData(GridData.FILL_HORIZONTAL);
        GC gc = new GC(port);
        try {
            Point extent = gc.textExtent("0");//$NON-NLS-1$
            data.widthHint = 5 * extent.x;
        } finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = GridData.BEGINNING;
		port.addVerifyListener(new verifyDigit(false));
		port.setLayoutData(data);
		port.addFocusListener(new FocusListener(){

			public void focusGained(FocusEvent e) {
				port.setSelection(0, port.getText().length());
			}

			public void focusLost(FocusEvent e) {
			}} );
		
		label = new Label(two_col, SWT.NONE);
		label.setText("P&rotocol:");
		data = new GridData();
		data.grabExcessHorizontalSpace = false;
		data.horizontalAlignment = GridData.BEGINNING;
		label.setLayoutData(data);
		protocol = new Combo(two_col, SWT.CHECK | SWT.READ_ONLY);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.grabExcessHorizontalSpace = false;
		data.horizontalAlignment = GridData.BEGINNING;
		protocol.setLayoutData(data);
        protocol.add("HTTP");
        protocol.add("HTTPS");
		protocol.setToolTipText(String.format(
				"Select the server protocol"));
		
        // setup values
        if (newserver) { // new server
			name.setText(HexUtil.EMPTY); 
			host.setText(HexUtil.EMPTY); 
			port.setText(store.getString(IConstants.DEFAULT_SERVER_PORT));
			protocol.select(1);
		} else { // update server
			name.setText(server.getName());
			host.setText(server.getHostname());
			port.setText(Integer.toString(server.getPort()));
			protocol.setText(server.getProtocol());
        }
        
        // TODO: EC - where is the place that handles this.  Can't you just do, new ModifyLisnter here.
		name.addModifyListener(this);
		port.addModifyListener(this);
		host.addModifyListener(this);
		protocol.addModifyListener(this);
        // adjust text boxes
        TextUtil.setWidth(name, 30);
        TextUtil.setWidth(host, 20);
        // TODO: EC - please add brackets for if/else even if it is just one line.
        if (newserver)
        	PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, NEW_CONTEXT_HELP_ID);
        else
        	PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, OLD_CONTEXT_HELP_ID);

        getShell().getDefaultButton().setText("OK");
		setControl(top);
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
	 */
	public void modifyText(ModifyEvent event) {
		changed = true;
		getWizard().getContainer().updateButtons();
	}

	public boolean performUpdate() {
		if (newserver) { // new server
			try {
				Element serverElement = model.addServer(name.getText(), host.getText(), Integer.parseInt(port.getText()), "", "N", protocol.getText());
				TT_TreeItem result = model.insertServer(serverElement);
				// TODO EC - where are the brackets
				if (result != null)
					server = (FileMasterServer) result.getValue();
			} catch (NumberFormatException e) {
				// TODO Auto-generated catch block
				log.log(Level.INFO, e.getClass().getSimpleName(), e);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				log.log(Level.INFO, e.getClass().getSimpleName(), e);
			}
		} else { // update stuff
			cancelOldSessionIfneeded(server);
			TT_TreeItem selection = model.findObject(server);
		    server.setName(name.getText());
			server.setPort(Integer.parseInt(port.getText()));
			server.setHostname(host.getText());
			server.setProtocol(protocol.getText());
			model.dlistMap.put((server.getUUIDString()).hashCode(), selection);
			
			// Load mainframe preferences if they are not loaded											
			if (server.getStatusText().equalsIgnoreCase("active") && selection.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("N")){								
				ManagePrefsType managePrefsType= new ManagePrefsType();		
				managePrefsType.setAction(PrefsActionType.G);
			
				XMLDocument xmlDocument = null;
				try {
					xmlDocument = new XMLDocument(new ManagePrefsRequest(server, managePrefsType).createXml());
					int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
		    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
		    		if(uuid.equalsIgnoreCase("\""))
		    			throw new TTException();
				} catch (TTException e) {
					e.printStackTrace();
				}				
													
				HashMap<String, Object> map = new HashMap<String, Object>();
				SendRequestToMainframe req = new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
				
				if(req.getResult() == Status.CANCEL_STATUS){
					return false;
				}
				
				// Extract needed element
				GUIResponseType response = req.getGuiResponseType();
				if (response == null) {
					return false;
				}
				
				ManagePrefsResponseType  managePrefsResponse = response.getManagePrefsResponse();				
				if (managePrefsResponse == null) {
					return false;
				}				
								 				
				Element serverElement = model.updatePrefs(server.getElement(),
						managePrefsResponse.getPrefsParmFiles().getDsnLists(),
						managePrefsResponse.getPrefsParmFiles().getSelCriteria(),
						managePrefsResponse.getPrefsParmFiles().getCustRecLay(),
						managePrefsResponse.getPrefsParmFiles().getSegmentXref(),
						managePrefsResponse.getPrefsParmFiles().getEnvirons());
						
				model.updateModelPrefs(serverElement, (FileMasterServer) server);													
				model.updateserver(server.getElement(), server, "Y");
				model.save();									
			} else if(!selection.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("Y")){
				model.updateserver(selection.getElement(), server, "N");
		    }				
		}

		if (server == null) { // shouldn't happen
			return false;
		}
		final IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		Shell shell = window.getShell();
		shell.setMinimized(false);
		shell.forceActive();
		shell.forceFocus();
		try {
			// force server view into focus
			final IWorkbenchPage page = window.getActivePage();
			IViewPart view = page.showView(DatabaseListView.ID);
			if (view instanceof DatabaseListView) {
				TreeViewer viewer = ((DatabaseListView) view).getViewer();
				if (viewer != null) {
					if (newserver)
						viewer.setInput(model.getServers());
					else
						viewer.refresh(true);
					TT_TreeItem selectionserver = model.findObject(server);
					viewer.setSelection(new StructuredSelection(selectionserver),
							true);
				}
			}
		} catch (final PartInitException e) {
		}
        model.save();
        return true;

	}

	/**
	 * TODO: EC - nobody is calling this method, remove it.
	 * // TODO Add getter documentation for newserver
	 *
	 * @return Returns newserver.
	 */
	public boolean isNewserver() {
		return newserver;
	}

	/**
	 * TODO: EC - nobody is calling this method, remove it.
	 * @param newserver Set newserver to new value.
	 *
	 */
	public void setNewserver(boolean newserver) {
		this.newserver = newserver;
	}

	/**
	private void setUserID() {
		UserID.setEnabled(true);
		useridlabel.setEnabled(true);
	}
*/
    /* (non-Javadoc)
     * @see org.eclipse.jface.wizard.WizardPage#isPageComplete()
     */

    public boolean isPageComplete () {
        String connection = name.getText().trim();
        if (connection.length() == 0) {
            setErrorMessage("Missing Name"); 
            return false;
        }
        if (host.getText().trim().length() == 0) {
            setErrorMessage("Missing Host"); 
            return false;
        }
        String portStr = port.getText().trim();
        if (portStr.length() == 0) {
            setErrorMessage("Missing Port"); 
            return false;
        }
        try {
            int port = Integer.parseInt(portStr);
            if (port <0 || port > 0xffff) {
                setErrorMessage(String.format("Port must be number not greater than %d", 0xffff)); 
                return false;
            }
        }
        catch (NumberFormatException exc) {
            setErrorMessage("Port entry must be a number"); 
            return false;
        }
        TTServer checkit = model.getServer(connection);
        if (checkit != null){
        	if (newserver || checkit != server){
        		setErrorMessage("Duplicate server name"); 
        		return false;
        	}
        }
        setErrorMessage(null);
        
        // TODO: EC - where did the changed variable come from? this line is confusing me.
        // can't you just say return true?
        // need more doc
        return changed;
        }


	public void widgetSelected(SelectionEvent e) {
		changed = true;
		getWizard().getContainer().updateButtons();
	}


	/** 
	 * TODO: EC - why is this an empty method.
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

    public FileMasterServer getServer() {
        return server;
    }
    
    /**
	 * @param currentServer
	 * 			If user changed the host name or the port value we need to cancel the sessions from previous server
	 * @return
	 */
	private void cancelOldSessionIfneeded(TTServer currentServer) {
		// TODO Auto-generated method stub
		if(currentServer.getPort()!= Integer.parseInt(port.getText()) || !currentServer.getHostname().equalsIgnoreCase(host.getText().trim())){
			FileMasterSession.cancelOneSession((FileMasterServer)currentServer);
		}
	}
}